/***************************************************************************
                          kbearquickconnect.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qvariant.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
#include <klocale.h>
#include <klineedit.h>
#include <kapplication.h>
#include <kpassdlg.h>
#include <knuminput.h>
#include <kprotocolinfo.h>
#include <kmessagebox.h>
#include <kmdcodec.h>
#include <kcombobox.h>
#include <dcopclient.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearquickconnect.h"
#include "kbear.h"
#include "base/site.h"
#include <netdb.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <string.h>

//-----------------------------------------------
KBearQuickConnect::KBearQuickConnect(QWidget *parent, const char *name)
	: KBearQuickConnectBase(parent,name,true),m_hasKBearFTP(false)
{
	
	bool hasFTP = false;
	QStringList protList = KProtocolInfo::protocols();
	for( QStringList::Iterator it = protList.begin(); it != protList.end(); ++it ) {
		if( ( KProtocolInfo::outputType( *it ) == KProtocolInfo::T_FILESYSTEM )
			&& KProtocolInfo::supportsListing( *it )
			&& KProtocolInfo::supportsReading( *it )
			&& KProtocolInfo::supportsWriting( *it )
			&& KProtocolInfo::supportsMakeDir( *it )
			&& KProtocolInfo::supportsDeleting( *it ) ) {
							
			if( *it == "ftp" )
				hasFTP = true;
			else if( *it == "kbearftp" )
				m_hasKBearFTP = true;
			if( (*it != "floppy") && (*it != "file") && ( (*it).left(6) != "webdav") )
				m_protocolComboBox->insertItem( *it );
			
		}
	}		
	if( hasFTP ) {
		if( m_hasKBearFTP ) {
			m_protocolComboBox->setCurrentText( "kbearftp" );
			m_protocolComboBox->removeItem( m_protocolComboBox->currentItem() );
		}
		m_protocolComboBox->setCurrentText( "ftp" );
	}
	slotSelectedProtocol( m_protocolComboBox->currentText() );
	connect( m_protocolComboBox, SIGNAL( activated( const QString& )),
					this, SLOT( slotSelectedProtocol( const QString& ) ) );
	m_hostNameEdit->setFocus();
}
//-----------------------------------------------
KBearQuickConnect::~KBearQuickConnect(){
}
//-----------------------------------------------
void KBearQuickConnect::slotSetAnonymous() {
	if( m_anonymousCheck->isChecked() ) {
		m_userNameEdit->setText( QString::fromLatin1("anonymous") );
		m_passwordEdit->setText( KBear::email() );
		m_remoteDirEdit->setFocus();
	}
	else {
		m_userNameEdit->setText("");
		m_passwordEdit->setText("");
		m_userNameEdit->setFocus();
	}
}
//-----------------------------------------------
void KBearQuickConnect::accept(){
	Connection c;
	if( m_protocolComboBox->currentText() == "ftp" && m_hasKBearFTP )
		c.setProtocol( "kbearftp" );
	else
		c.setProtocol( m_protocolComboBox->currentText() );
	
	c.setAnonym( m_anonymousCheck->isChecked() );
	c.setHost( m_hostNameEdit->text() );
	c.setPort( m_portSpinBox->value() );
	c.setUser( m_userNameEdit->text() );
	c.setPass( m_passwordEdit->password() );
	c.setRemotePath( m_remoteDirEdit->text() );

	KURL url = c.url();
	if( ! url.hasHost() ) {
		KMessageBox::error ( this, i18n("You must set a host !"));
		return;
	}

	if( ! url.isValid() || url.isMalformed() ) {
		KMessageBox::error ( this, i18n("Invalid URL:\n%1\n\nPlease try again.").arg(url.prettyURL()));
		return;
	}
	
	if( saveSite() ) {
		Site s( c );
		QString pass = s.pass();
		QTextStream txtStream( &pass, IO_ReadOnly );
		QCString bArray;
		txtStream >> bArray;
		QCString result = KCodecs::base64Encode( bArray );
		s.setPass( result.data() );
		QByteArray data;
		QDataStream arg(data, IO_WriteOnly);
		arg << s;
		if( ! kapp->dcopClient()->send("kbearsitemanagerdb", "SiteManagerDBInterface", "saveSite(Site)", data ) )
			kdDebug()<<"DCOP call saveSite(Site)  to kbearsitemanagerdb failed !!!!"<<endl;
	}
	emit openConnection( c );
	QDialog::accept();
}
//-----------------------------------------------
void KBearQuickConnect::reject(){
	QDialog::reject();
}
//-----------------------------------------------
void KBearQuickConnect::slotSelectedProtocol( const QString& protocol ){
	char p[25];
	strcpy( p, "ssh" );
	if( protocol != "sftp" && protocol != "fish" ) // ssh protocols
		strcpy( p, protocol.latin1() );
	setservent( true );  // open /etc/services
	struct servent* serv = getservbyname( p, NULL );   // find default port for specified protocol
	if( serv ) {
		int port = (int)ntohs( (unsigned short int)serv->s_port);
		m_portSpinBox->setValue( port );
	}
	endservent();  // close /etc/services
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearquickconnect.moc"
#endif
