/***************************************************************************
                          kbearchildviewpart.cpp  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qsizepolicy.h>
#include <qlayout.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <ktoolbar.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearchildviewpart.h"

//-----------------------------------------------
KBearChildViewPart::KBearChildViewPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name)
	:	KBearPart( parentWidget, widgetName, parent, name ),
		m_toolBarUpper( 0L ), m_toolBarLower( 0L ),
		m_statusBarUpper( 0L ), m_statusBarLower( 0L ),
		m_partViewer( 0L )

{
}
//-----------------------------------------------
KBearChildViewPart::~KBearChildViewPart(){
	kdDebug()<<"KBearChildViewPart::~KBearChildViewPart()"<<endl;
}
//-----------------------------------------------
void KBearChildViewPart::showToolBarUpper( bool show ) {
	if( ! m_toolBarUpper )
		return;
	if( show )
		m_toolBarUpper->show();
	else
		m_toolBarUpper->hide();
}
//-----------------------------------------------
void KBearChildViewPart::showToolBarLower( bool show ) {
	if( ! m_toolBarLower )
		return;
	if( show )
		m_toolBarLower->show();
	else
		m_toolBarLower->hide();
}
//-----------------------------------------------
void KBearChildViewPart::showStatusBarUpper( bool show ) {
	if( ! m_statusBarUpper )
		return;
	if( show )
		m_statusBarUpper->show();
	else
		m_statusBarUpper->hide();
}
//-----------------------------------------------
void KBearChildViewPart::showStatusBarLower( bool show ) {
	if( ! m_statusBarLower )
		return;
	if( show )
		m_statusBarLower->show();
	else
		m_statusBarLower->hide();
}
//-----------------------------------------------
bool KBearChildViewPart::validURL( const KURL& url ) {
	if( url.isMalformed() || ! url.isValid() ) {
		QString tmp = i18n("Invalid URL:\n%1").arg( url.prettyURL() );
		KMessageBox::error( widget(), tmp );
		return false;
	}
	return true;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearchildviewpart.moc"
#endif
