/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __KZ_SMART_BOOKMARK_H__
#define __KZ_SMART_BOOKMARK_H__

#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_SMART_BOOKMARK		  (kz_smart_bookmark_get_type ())
#define KZ_SMART_BOOKMARK(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_SMART_BOOKMARK, KzSmartBookmark))
#define KZ_SMART_BOOKMARK_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_SMART_BOOKMARK, KzSmartBookmarkClass))
#define KZ_IS_SMART_BOOKMARK(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_SMART_BOOKMARK))
#define KZ_IS_SMART_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_SMART_BOOKMARK))
#define KZ_SMART_BOOKMARK_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_SMART_BOOKMARK, KzSmartBookmarkClass))

typedef struct _KzSmartBookmark      KzSmartBookmark;
typedef struct _KzSmartBookmarkClass KzSmartBookmarkClass;
typedef struct _KzSmartBookmarkPriv  KzSmartBookmarkPriv;

typedef struct _KzSmartBookmarkProperty
{
	gchar    *regex;
	gchar    *uri;
	gchar    *encode;
	gboolean  urlencode;
} KzSmartBookmarkProperty;

struct _KzSmartBookmark
{
	KzBookmark parent;

	KzSmartBookmarkPriv *priv;
};

struct _KzSmartBookmarkClass
{
	KzBookmarkClass parent_class;
};

GType	     kz_smart_bookmark_get_type	       (void) G_GNUC_CONST;

KzBookmark  *kz_smart_bookmark_new	       (void);

void	     kz_smart_bookmark_append_property (KzSmartBookmark *bookmark,
					        const gchar *regex,
					        const gchar *uri,
					        const gchar *encode,
					        gboolean urlencode);
void 	     kz_smart_bookmark_remove_property (KzSmartBookmark *bookmark);

gchar	    *kz_smart_bookmark_get_smart_uri   (KzSmartBookmark *bookmark,
					        const gchar *text);
const GList *kz_smart_bookmark_get_smart_list  (KzSmartBookmark *bookmark);
void         kz_smart_bookmark_set_smart_list  (KzSmartBookmark *bookmark,
					        GList *list);

G_END_DECLS

#endif /* __KZ_SMART_BOOKMARK_H__ */
