/*

Vendors support routines
karpski
Brian Costello

*/

#include <stdio.h>
#include <config.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <pthread.h>
#include <gtk/gtk.h>

#include "vendors.h"
#include "proto.h"
#include "connects.h"
#include "karpski.h"
#include "gtk_misc.h"

t_vendors *first_vendors = NULL;	/* The linked list of vendors */

extern GtkWidget *logtext;
extern int logfd;

int charval(char c)
{
   if ((c>='0') && (c<='9'))
      return(c-'0');
   
   if ((c>='A') && (c<='F'))
      return(10+c-'A');
   
   if ((c>='a') && (c<='f'))
      return(10+c-'a');
   
   fprintf(stderr, "Invalid char value: %c\n", c);
   return(0);
}


unsigned short int hexval(char *s, int len)
{
   int place,i, sum;
   
   place = 1;
   sum = 0;
   
   for (i=0; i<len; i++)
   {
      sum += charval(s[len-i-1]) * place;
      place *= 16;
   }
   return(sum);
}

char *copy_vendname(char *s)
{
   char buf[256];
   int i=0;
   int j=0;
   
   while ((s[i] != '\n') && (s[i] != '(') && (s[i] != '[') && (s[i] != ';') && (!((s[i] == ' ') && (s[i+1] == ' '))))
   {
      buf[j++] = s[i++];
   }
   buf[j] = '\0';
   return((char *)strdup(buf));
}


char *find_vendstr(char mac[])
{
   t_vendors *tv;
   
   for (tv = first_vendors ; tv ; tv=tv->next)
   {
      if (!strncasecmp(tv->vend_id, mac, 8))
         return(tv->vend_str);
   }
   logmsg(&logtext, logfd, 0, "Vendor id %s not found\n", mac);
   return(NULL);   
}

void read_vendors()
{
   FILE *infile;
   char s[256];
   unsigned char vid[3];
   char fn[256];
   t_vendors *t_vend;
   
   first_vendors = NULL;
   
   sprintf(fn, "%svendor_codes.dat", KARPSKI_DATA_DIR);
   infile = fopen(fn, "r");
   if (infile == NULL)
   {
      perror("fopen vendor_codes.dat ");
      exit(1);
   }
   while(fgets(s, 256, infile))
   {
      if ((s[0] == '\n') || (!s[0]) || (s[0]=='#'))
         continue;
      t_vend = (t_vendors *)MALLOC(sizeof(t_vendors), "New vendor - vendors.c");
      vid[0] = hexval(&s[0], 2);
      vid[1] = hexval(&s[2], 2);
      vid[2] = hexval(&s[4], 2);
      strcpy(t_vend->vend_id, print_addr(vid, 3, ':'));
      strcpy(t_vend->vend_str, copy_vendname(&s[8]));
      t_vend->next = first_vendors;
      first_vendors = t_vend;
   }
}

