/* $Id: print_logo.c,v 1.8 2004/11/22 00:52:42 rikster5 Exp $ */

/*******************************************************************************
 * print_logo.c
 *
 * Copyright (C) 2001 by Colin Brough
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

#include "config.h"
#include <stdio.h>
#ifdef HAVE_LOCALE_H
# include <locale.h>
#endif
/*----------------------------------------------------------------------*/

void print_logo_data(FILE *f)
{
    fputs(
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffffffffffffffffff2d10080808000a1429ffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffffffffffffff1808364f5a535a5a4f3e220008ffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffffffffff08214f5b635f5b5f5b5b5b63635b390820ffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffffff27144f5f5b5b5a5b5a5a5b5a5b5a5b5a68531800ffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffffff142a5f5b5b5a5b5a5b5b5a5b5a5b5a5b5a5a5f633100ffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffffff0831685b5b5a5b5a5b5a5a5b5a5b5a5b535b5b5b5b5f4304ffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffffff35185b5b5a5a5b5a5b5b5a5b5b5b5a5b5b5e5b5a5a5a5b633e00ffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffff350d5a5f5a5b5b5a5b5a5b5a5b5a5a5b5a5b5a5b5a5b5b5b5b632908ffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fffff0d5b5b5b5a5b5a5b5b5a5b5a5b5b5a5b5b5b5f635f5f635f5b5b5b08ffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"fff08475f5a5b5a5b5a5b5a5b5a5b5a5a5b5f5a4f31221c1822395a5f633e00ffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"f3521635b5a5b5a5b5a5b5a5b5b5a5b5b5f3e100827393e3e390808395f5b00ffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"f01535f5a5b5a5b5a5b5a5b5a5b5a5b5b211873ceffffffffffce390043630dffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff3"
	"529635b5a5b5b5a5b5b5a5b5b5a5b632921deffffffffffffffffff4f004300000035"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff0"
	"c4f5b5b5a5b5a5b5a5b5a5b5a5b5f3608c6ffffffffffffffffffffce080021a37c08"
	"14ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff1"
	"85f5b5a5b5a5b5a5b5a5b5a5b5f3908b5ffffffffffffffffffffffff5408bdffffc6"
	"1044ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff353"
	"9635a5b5a5b5b5a5b5a5b5b5f4f08b5ffffffffffffffffffffffffff7b08efffffff"
	"ad00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff084"
	"75b5b5a5b5a5b5a5b5a5b5a5b106bffffffffffffffffffffffffffff9400deffffff"
	"f710ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff085"
	"a5b5b5a5b5b5a5b5a5b5a633e10e7ffffffffffffffffffffffffffff9d01efffffff"
	"ff35ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff215"
	"f5b5a5a5b535b5b535b5b5b0873ffffffffffffffffffffffffffffff840af7ffffff"
	"ff39ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff35365"
	"f5a5b585a5f5a5b5e5b5f4a00c6ffffffffffffffffffffffffffffff6b29ffffffff"
	"ff39ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff104f5"
	"b5b5a5b5a5b5a5b5a5a5f2910f7ffffffffffffffffffffffffffffff5a4affffffff"
	"ff29ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff105a5"
	"b5a5b5a5b5a5b5a5b5b5b104affffffffffffffffffffffffffffffff217bffffffff"
	"ef0dffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff215f5"
	"a5b5a5b5b5a5b5b5a5b5a0894ffffffffffffffffffffffffffffffbd08ceffffffff"
	"d410ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff29685"
	"b5a5b5a5b5a5b5a5b5b4a08deffffffffffffffffffffffffffffff634affffffffff"
	"9d1cffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff353e5b5"
	"a5b5b5a5b5a5b5a5a5f3e10efffffffffffffffffffffffffffffef10a6fffffffff7"
	"31ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff27435f5"
	"a5b5a5b5a5b5a5b5b633e10e7ffffffffffffffffffffffad5ad47b0094deffffffad"
	"00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff08535b5"
	"b5b5a5b5b5a5b5b5a5b4308ceffffffffffffffffffffef08007b3900006bffffff3e"
	"3effffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff015e5b5"
	"a5a5b5a5b5a5b5a5b5f3e08ceffffffffffffffffffffe700189400000094ffffce10"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff185f5b5"
	"b5a5b5b5a5b5f5f5b5b5a08ceffffffffffffffffffffffc16b298c8473ffffff5a3e"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff2d2a685a5"
	"a5b5a5b5f53222a535f5b0094fffffffffffff9efc1706c6b210063efffffffbd01ff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff0a3e5b5a5"
	"b5b5a5f53113f4310224f084fffffffffb65b39100d3474863e2b0d1c94efbd21ffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff004a5f5b5"
	"a5a5f4f0958d5d5a6581818007ca67c39265786aad0c6933417b4c7660d1c013effff"
	"ffffffffffffffffff4b2a1c14112affffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff085a5b5a5"
	"b5b5b113fd5d4d0d4d5cdcd9b34316da2c7d4d0b166140a60b8d4d4d5bf75311020ff"
	"ffffffffffff1026295883868e866d1b20ffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff22685a5b5"
	"b5f2a1fc7d4d0d0d0d4d0d0d5d5d0dda2352b0a0a2b86c6d5d4d0d0d0d4d8d5b89154"
	"04092001003faad0d5d5d8d8d8d8d5cd7c00ffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff29475b5b5b5"
	"a5b116dd5d0d0d0d0d4d5d0d0d0d0d0b88e7f91b1d5d5d4d0d0d0d0d0d0d0d0d4d8d5"
	"aa6e4a669bd5d5d4d0d0d0d0d0d0d4d4d5a62a29ffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff185a5b5a5a5"
	"b5f117cd8d0d0d4d5aa91d4d0d0d0d0d4d8d8d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d4"
	"d4d5d5d5d5d4d0d0d0d0d0d0d0d0d0d0d0d8c75810ffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffff215b5b5b5b5"
	"a5f1674d5d4d0d57f086ed5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0"
	"d0d4d0d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d59114ffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffff29395f5a5a5a5"
	"b682257d5d0d586000043b5d5d5d4d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d5b81bffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffff085f5b5b5b5b5"
	"b63362bd0d4d59b86aa350a2b75b4d5d5d5d5d4d4d4d4d4d4d4d4d0d0d0d0d0d0d0d0"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d8c03f20ffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffff35635a5a5a535"
	"a5b5308a6d4d0d5d5d5d5a6581f081f587c91b4bcc7c7c7c7c7d5d4d4d0d0d0d0d0d0"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d546ffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffff0c535f5b5b5b5f5"
	"b5a53017cd8d0d0d4d0d4d4d5d5aa4300000001080000000000439bd5d5d4d0d0d0d0"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4c70dffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffff22635a585a5a5b5"
	"a5b5a016ed5d0d0d0d0d0d4d0d0d8d5bca69b93867560756e5018012b75cdd5d4d0d0"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d59b00ffffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffff144f5f5b5b5a5b5b5"
	"a5b5b0934d5d4d0d0d0d0d0d0d0d0d0d4d4d5d8d5d8d5d8ddddcd1809202a6ec6d5d4"
	"d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d5503effffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffff21635b5a5a5b5a5a5"
	"b5b5a21003fc7d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d8bb86580dffffff3e187cc6"
	"d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4bf0dffffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffff0c4f5b5a5b5b5a5b5b5"
	"a5b5b145a3e1bc7d4d0d0d0d0d0d0d0d0d0d0d0d0d4c76018113e35ffffffffff2018"
	"5fb8d5d8d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d56d2dffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffffff225f5b5a5b5a5b5a5b5"
	"a5b5a14cef73231cdd4d0d0d0d0d0d0d0d0d0d0d4d54a14ffffffffffffffffffffff"
	"190d58b1d5d5d4d4d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d8bb04ffff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffffff145a5f5a5b5a5b5b5a5b5"
	"a5b4f22f7ffe71c58d5d0d0d0d0d0d0d0d0d0d4d57501ffffffffffffffffffffffff"
	"ffff3e083475aad5d5d4d4d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d5463eff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffff14395f5b5b5a5b5a5b5a5b5"
	"a5f3e4affffffb600b1d4d0d0d0d0d0d0d0d0d5b400ffffffffffffffffffffffffff"
	"ffffffff2900001b4d93c7d0d5d8d5d4d4d4d0d0d0d0d0d0d0d0d0d88d3eff\n"
	"ffffffffffffffffffffffffffffffffffffffffffffff045b5b5a5b5a5b5b5a5b5a5"
	"b632d4fffffffff4f34d5d4d0d0d0d0d0d0d4d54a00ffffffffffffffffffffffffff"
	"ffffffffffffffff320c18315886a2bcc6d5d5d5d8d4d4d4d0d0d0d4b817ff\n"
	"ffffffffffffffffffffffffffffffffffffffffffff0c4a5f5b5a5b5a5b5a5b5b5a5"
	"b632173ffffffffde0977d5d0d0d0d0d0d0d56e0017ffffffffffffffffffffffffff"
	"ffffffffffffffffffffffff3d2010080d2a466d9bb4c6d0d5d5d4d4d014ff\n"
	"ffffffffffffffffffffffffffffffffffffffffff2d36635b5a585a5b535b5a585a5"
	"b5f217bffffffffff9400b1d8d0d0d0d0d8aa0108ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffff4b391c0a0a184683c6d5d83fff\n"
	"ffffffffffffffffffffffffffffffffffffffffff1863585a5b5a5b5b5e5b5b5a5b5"
	"a682184ffffffffffff4f1bc7d4d0d0d4d5297c63ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffff200a468a29ff\n"
	"ffffffffffffffffffffffffffffffffffffffff08535f5b5a5b5a5b5a5b5a5b5a5b5"
	"b5b1c8cfffffffffffff71c17b8d5ddcd3443ff4fffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffff3e140014\n"
	"ffffffffffffffffffffffffffffffffffffff273e5f5a5b5a5b5a5b5a5b5b5a5b5a5"
	"b5b149dffffffffffffffe7430d7c7c264fefff21ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffffff18685a5b5a5b5a5b5a5b5a5b5a5b5a5"
	"b5a18c6ffffffffffffffffff73000073fffff718ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffff1c4f5b5b5a5b5b5a5b5b5a5b5a5b5a5b5"
	"b5318deffffffffffffffffffffc6c6ffffffde10ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffffff22635a5b5a5b5a5b5a5b5a5b5b5a5b5a5"
	"f4329f7ffffffffffffffffffffffffffffffef10ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffffff10535b5b5a5b5a5b5b5a5b5a5b5a5b5a5b6"
	"3294affffffffffffffffffffffffffffffffce08ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffff273e5f5b5a5b5b5a5b5a5b5a5b5a5b5b5a5b5"
	"f216bffffffffffffffffffffffffffffffffc600ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffffff215f5b5a5b5a5b5a5b5a5b5b5a5b5a5b5a5b6"
	"32191ffffffffffffffffffffffffffffffffce08ffffffffffffffffffffffffffff"
	"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffffff04535f5a5b5a5b5a5b5a5b5a5b5a5b5b5a5b5b5"
	"b18b5ffffffffffffffffffffffffffffffffb500ffffffffffffffffffffffffffff"
	"ffffffffffffffff201c2dffffffffffffffffffffffffffffffffffffffff\n"
	"ffffffffffffffffffffffffffff204a5f5b5a5b5a5b5b5a5b5b5a5b5a5b5a5b5a5b4"
	"f10deffffffffffffffffffffffffffffffffb500ffffffffffffffffffffffffffff"
	"ffffffffffff21a7d4ddc8b3b3afa39d9d7e843e08102dffffffffffffffff\n"
	"ffffffffffffffffffffffffffff215f5b5a5b5a5b5a5b5a5b5a5b5f5a5b5a5b5a5b3"
	"e31ffffffffffffffffffffffffffffffffffce00ffffffffffffffffffffffffffff"
	"ffffffffffff7efff9f9f6f9f9f9f9f9f9fffff9e5af7332ffffffffffffff\n"
	"ffffffffffffffffffffffffff204a5f5a5b5b5a5b5b5a5b5b5b424f5b5a5b5a5b632"
	"96bfffffffffffffffffffffffffffffffffff708ffffffffffffffffffffffffffff"
	"ffffffffff4ff1b6363535363535363e3e5a5f63a3f9fff147ffffffffffff\n"
	"ffffffffffffffffffffffffff2e685a5b5a5b5a5b5a5b5a5b5f17315f5b5a5b5b5f1"
	"87bfffffffffffffffffffffffffffffffffff921ffffffffffffffffffffffffffff"
	"ffffffffffa3ff4a2e91969d9d919d91896a5e500db6f9f96c00ffffffffff\n"
	"ffffffffffffffffffffffff14535b5a5b5b5a5b5a5b5a5b5a682920685a5b5a5b5b1"
	"09bffffffffffffffffffffffffffffffffffff3e0affffffffffffffffffffffffff"
	"fffffffffff1c855cdd9d4d9d4d9d4d9d9d9d9d461e5f9c87032ffffffffff\n"
	"ffffffffffffffffffffffff295f5a5b5b5a5b5b5a5b5b5a5b6336215b5b5b5a5b4f1"
	"8efffffffffffffffffffffffffffffffffffff6b00ffffffffffffffffffffffffff"
	"ffffffff7cff7cabd4d4d4d1d4d1d4d1d4d1d9839df9ed70c829ffffffffff\n"
	"ffffffffffffffffffffff10535f5b5a5a585a5b535f5a585a5b3e185f5a5a5b5f314"
	"affffffffffffffffffffffffffffffffffffff940004ffffffffffffffffffffffff"
	"ffffffffdae58bd4d4cdd4ccd4ccd1ccd1d4cd6dedf99d8c9cffffffffffff\n"
	"ffffffffffffffffffffff29685a5b5b5a5b5a5b5a5b5a5b5b5f43215a5b5b5a5f1c8"
	"4ffffffffffffffffffffffffffffffffffffffad084700ffffffffffffffffffffff"
	"ffffff53f99dabd4d4d4d1d4d1d4d4d4ccd4b384f9f98cd447ffffffffffff\n"
	"ffffffffffffffffffff104f5b5b5a5a5b5a5b5a5b5a5b5a5a5b4a115a5b5a5b5a10c"
	"6ffffffffffffffffffffffffffffffffffffffd40c4f4a00ffffffffffffffffffff"
	"ffffffb6f98bcdd4d4cdd4ccd4ccd1d4d1d483d4f9d4a7c8ffffffffffffff\n"
	"ffffffffffffffffffff21685b5a5b5b5b5a5b5b5a5b5b5a5b5b5a084f5b5b5f3636f"
	"fffffffffffffffffffffffffffffffffffffffef08396847043effffffffffffffff"
	"ffff5af9baa1d4d4cdd4d4d1d4d1d4ccd4c592f9f9a3d45bffffffffffffff\n"
	"ffffffffffffffffff1c4f5b5a5b5a5a5b5a5b5a5b5a5b5a5b5a5310435f5a63148cf"
	"fffffffffffffffff9d7bfffffffffffffffffff7212a63634f0d14ffffffffffffff"
	"ffff92ff8bbfd4d4ccd4cdd4ccd4d1d4d491cbf9edafbc27ffffffffffffff\n"
	"ffffffffffffffffff215f5b5a5b5b5a5b5a5b5a5b5a5b5a5b5f5b1839635b4f18def"
	"fffffffffffffef6b42089bffffffffffffffffff4f18685a5b5a2900ffffffffffff"
	"fffff1e58fd4d4d1d4d1d4d1d4d1ccd1c570f1f9b7dd70ffffffffffffffff\n"
	"ffffffffffffffff003e5f5a5b5a5a5b5a5b5a5b5a5b5a5b5a5b5f21215b63225afff"
	"fffffffffffff9d10f9a714d4ffffffffffffffff73085b5b5b5b63430d0cffffffff"
	"ff70ffa3b3d4ccd4cdd4ccd4cdd4d4d4a7bcf9f19ddd4fffffffffffffffff\n"
	"ffffffffffffffff0d5b5b5b5b5a5b5b5b5a5b5b5a5b5b5a5b5a6336105b5b08adfff"
	"fffffffffffffef4a92ff4f17d4ffffffffffffff9b015a5b5a5a5b5f5a391000ffff"
	"ffc8f99cd1d4d4d1d4d1d4d1d4d4d4d17eedf9b7c89dffffffffffffffffff\n"
	"ffffffffffffffff35635a5a5b535b5a535b5a585a5b535b5a585b43085f2918effff"
	"fffffffffffffffde1cdded293cffffffffffffffd4084f5b5a5b5a5b5b635b290800"
	"47f9c883cdcdccd4d9d9d4d4d4d1d9ab5ff9f98cdd5bffffffffffffffffff\n"
	"ffffffffffffff0c4f5b5b5b5a5f5a5b5f5a5b5a5b5a5f5a5b5a5f5308310063fffff"
	"fffffffffffffffff8447f9f1217bfffffffffffff717365f5b5a5b5a5a5b5b5f4f21"
	"b6f96c365566667a6e7a91abcdccd450a7f9e592c8ffffffffffffffffffff\n"
	"ffffffffffffff31685a5b5a5b5b5a5b5a5b5b5a5b5b5a5b5b5a5b5f210000cefffff"
	"ffffffffffffffffff739539d36006bc6ffffffffff4f185f5a5b5a5b5b5a5a633e53"
	"f9ed7ebbb3ababa1a1997a6150515031f1ffa3b370ffffffffffffffffffff\n"
	"ffffffffffff294f5b5a5b5a5b5a5b5a5b5a5b5a5b5a5b5a5b5a5b63310073fffffff"
	"ffffffffffffff78c310a0008182110084ae7ffffff94005a5b5b5a5b5a5b5b5b39af"
	"ffb6a1bbbbc2c2bbbbbbc3c3b3ab4468f9f97cb73effffffffffffffffffff\n"
	"ffffffffffff22635b5a5b5a5b5a5b5b5a5b5a5b5a5b5b5a5b5a5b5b4f00bdfffffff"
	"fffffffffff9d1800214a5b535f5b5b4f1821d4ffffd4004f5b5a5b5a5b5a5b534af1"
	"f17eb3bfbbb3bbb3bbb3b3bbbbcc61184f3e211000ffffffffffffffffffff\n"
	"ffffffffff4c3e5f5a5b5a5b5a5b5a5b5a5b5b5a5b5a5b5a5b5a5a5b5a084afffffff"
	"fffffffd43c04294f685b5b5b5b5a5b5f631817deffff2127685a5b5b5a5b5f3e70f9"
	"b651b3abb3c2c2c3c3c2c2bbc27a11314a4f534f10ffffffffffffffffffff\n"
	"ffffffffff1c5a5b5b5a5b5b5a5b5b5a5b5a5b5a5b5b5a5b5a5b5a5b633e008cfffff"
	"fffe75a0a1047635b5a5b5a5a5a5b5a5b5b5a005affff6b085b5b5f535b5a6331a6ed"
	"36314235423632446189a7c3910847635b5b5b683635ffffffffffffffffff\n"
	"ffffffffff215f5a5b5a5b5a5b5b5b5a5b5a5b5a5b5a5b5b5a5b5b5a5b5f1c00adffe"
	"7a62100295b5f5b5a5b5a5b5b5b5a5b5a5b5f2a0af7ffb500535b5a5a5b5b533ee5f1"
	"e5f1ededdda36c4f3921186e2e2d685a5b5a5a5b3e35ffffffffffffffffff\n"
	"ffffffffff36635b5a5b5a5b4f535a5b5a5b5a5b5a5b5a5b5a5b5a5b5a5b5f2900291"
	"000184f5f5b5a5b5a5b5b5a5b5a5b5a5b5a5b5a01a6ffef103e635b5b5a5f4a4af9f9"
	"f9f6f9f1f9fffff9f9e5c8680c5b5b5b5a5b5b633535ffffffffffffffffff\n"
	"ffffffff14535b5a5b5b5a6322315f5b5b5a5b5b5b5f685f5f5b5a5b5a5a5b5f43293"
	"14f5b635a5b5a5b5a5b5a5b5a5b5f5f63685b63183effff3e185f5b5a5b5b3684f9f1"
	"f1f9f9f9f19dd4f9f9f9ff8422635a5b5a5b5a5f21ffffffffffffffffffff\n"
	"ffffffff185f5b5a5b5a5b5f391c5f5b5a5b5a5b5a36221936535f5a5b5a5b5a5b686"
	"35b5a5b5b5a5b5a5b5a5b5a5b5b4f292d213e5f3121f7ff94085a5b5a5b5b31c88470"
	"f1dd8cd4b34f5be5ddedf97c2163585a5b5a5b5f11ffffffffffffffffffff\n"
	"ffffffff355f5a5b5a5b5a5b53104a5f5b5a5b5f2a1f666635115a5b5a5b5b5a5b5a5"
	"b5a5b5a5b5a5b5b5a5b5b5a5b5b1800005f29000818f7ffe70c4f5f5a5f5331edaf91"
	"f9b34fe57c103ef9634ff18c0147635b5a5b5b4f08ffffffffffffffffffff\n"
	"ffffff394f5b5b5b5a5b5b5a632a21635b5a5b5310b1ddddd5501c5b5b5a5a5b5a5b5"
	"35b5a5b5a5b5a5b5a5b5a5b5f2910c639a7f17c008cffffff2136635b5b5335e5f9f9"
	"f1f9f9f973549df99d91ed4f2e183e5b5b5a632900ffffffffffffffffffff\n"
        "ffffff105a5b5a5b5a5b5a5b5f530d4f5b5b5f364ad8d0d0d4cd2a365f5b5b5a5b5a5"
        "b5a5b5b5a5b5b5a5b5a5b5b4f008cffbd21e7f96863ffffff63105b5b5a5b29ddf9f1"
        "f1f1f6f9c8a3f1f9f9f9f9edf1ba214f5b5f4f008e31ffffffffffffffffff\n"
        "ffffff185f5b5b5a5b5a5b5a5b6318105f5b5b118dd5d0d0d0d591115b5a5b5a5b5b5"
        "a5b5a5b5a5b5a5b5a5b5a682910f7ffff5a63fff121adffffa6005a5f5b5b217cf9f9"
        "f9f1f1f1f9f9f1f1f6f1f1f9f9f94f4a5f5b1135dd830d040c1400ffffffff\n"
        "ffff48365f5b5a5a5b5b5a5b5a5b43003e635318bbd4d0d0d0d0d5313b5f5a5b5a5b5"
        "a5b5a5b5b5b5b5b5a5b633e0084ffffffef2a9dffa721f7ffde083e5a5b684f1447af"
        "edf9f9f9f9f9f9f9f9f9f6f1f9f95a5b53220ab8d4d5c7c0a293831fffffff\n"
        "ffff1c4f5b5a5b5b5a5b5a5b5a5b5f2d00533643d5d4d0d0d0d0d886095b5b5b5a5b5"
        "a5b5f53535a5f5a585f4f003cffffffffffbd1091ff4a5affff21001021364a5a3108"
        "215b7092afb7d4ddf1f1f6f9ed7e361a082ab1d8d0d0d0d4d4d8dd4700ffff\n"
        "ffff145a5b5a5a5b5a5b5a5b5b5a5b5f21080986d5d0d0d0d0d0d0d531225f5b5b5b5"
        "f5336100a113e5b634f0039efffffffffffffbd18c8ed0d9bff7308ffff0c08081008"
        "3535353514000a183542473b350414358dd5d4d0d0d0d0d0d4d58314ffffff\n"
        "ffff215b5b5b5b5a5b5a5b5a5a5b5a5b5f29008ed5d0d0d0d0d0d0d4bc0a2a5f635b3"
        "610359bb17f0d3e31004fe7ffffffffffffffffad18e5a318efc600ffffffffffffff"
        "ffffffff1175c0b1a2977e77a2cdc7d8d5d0d0d0d0d0d0d4d88a10ffffffff\n"
        "ffff2e635a5a5b5a5b5b5a5b5f5b5f5b682a34c0d4d0d0d0d0d0d0d0d8a6181122112"
        "69bd4d5d4dd660021a6ffffffffffffffffffffff6b3eed2acef714ffffffffffffff"
        "ffffff0883d5d4d4d4d4d8d8d4d0d0d0d0d0d0d0d0d0d5d56600ffffffffff\n"
        "ffff395b5b5b5a5b5a5b5b5f4f43433e1414bcd8d0d0d0d0d0d0d0d0d0d5b875588ac"
        "dd5d4d0d4d88d1ce7ffffffffffffffffffffffffff4f1008deff35ffffffffffffff"
        "ffff007cd5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d58d1f00ffffffffffff\n"
        "ff4c3e5f5a5b5a5b5b5f4f22000000083fb1d4d0d0d0d0d0d0d0d0d0d0d0d4d5d5d5d"
        "4d0d0d0d0d59e21fffffffffffffffffffffffffffff76363efff6800ffffffffffff"
        "ff116ed5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d56d11ffffffffffffffff\n"
        "ff2d4a5b5b5a5b5a5b4f103583a2a6b4d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d0d"
        "0d0d0d0d0d88d2af7ffffffffffffffffffffffffffffffffffffc600ffffffffffff"
        "394ad5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d5cd4600ffffffffffffffffff\n"
        "ff20535b5a5b5b5a682a34d5ddd5d4d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d0d0d8664ffffffffffffffffffffffffffffffffffffffff718ffffffffff2a"
        "3fd0d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d44a00ffffffffffffffffffff\n"
        "ff18535f5a5b535b5b1160ddd0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d0d0d5475bffffffffffffffffffffffffffffffffffffffff31ffffffffff46"
        "d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d58d19ffffffffffffffffffffff\n"
        "ff215a5b5a5b5e5b5b1174d8d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d0d4c7179dffffffffffffffffffffffffffffffffffffffff4affffffff2acd"
        "d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d87e16ffffffffffffffffffffff\n"
        "ff1c5a5b5a5b5a5b5b0974d5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d0d4b110e7ffffffffffffffffffffffffffffffffffffffff4affffff0aaad5"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d534ffffffffffffffffffffff\n"
        "ff215f5b5a5b5a5b5f0960d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d0d5773effffffffffffffffffffffffffffffffffffffffff5bffff1c91d8d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4c618ffffffffffffffffffff\n"
        "ff315f5b5b5a5b5b5b1150d5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d4d5466fffffffffffffffffffffffffffffffffffffffffff5effff47d5d4d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d535ffffffffffffffffffff\n"
        "ff2a635a5b5a5b5a682a35d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d4cd18adffffffffffffffffffffffffffffffffffffffffff4f0c1fc0d4d0d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d59b08ffffffffffffffffffff\n"
        "ff315f5a585a5b5a5b4f0ab1d5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d4b110e7ffffffffffffffffffffffffffffffffffffffffff310086d8d0d0d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d5aa14ffffffffffffffffffffff\n"
        "ff2a5f5b5b5a5b5a5b5b0966d5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d0d5583effffffffffffffffffffffffffffffffffffffffffef091fcdd4d0d0d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d0d0d4d5d56d0affffffffffffffffffffffff\n"
        "ff2a635b5a5b5a5b5a5f3e18c6d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d5aa00a4ffffffffffffffffffffffffffffffffffffffffffef0175d5d0d0d0d0"
        "d0d0d0d0d0d0d0d0d0d0d0d0d4d5d58a3129ffffffffffffffffffffffffff\n"
        "ff215f5b5a5b5a5b5b5b5a097cd5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d0d57401efffffffffffffffffffffffffffffffffffffffffffa6009bd8d0d0d0d0"
        "d0d0d0d0d0d0d0d0d0d0d0d4d59b3f1cffffffffffffffffffffffffffffff\n"
        "ff215a5b5b5a5b5a5a5b5f3231d5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d4d53436ffffffffffffffffffffffffffffffffffffffffffff5a00b4d4d0d0d0d0"
        "d0d0d0d0d0d0d0d0d0d4d5b84929ffffffffffffffffffffffffffffffffff\n"
        "ff185b5b5a5b5a5b5b5a5b580997d8d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d4bb0094ffffffffffffffffffffffffffffffffffffffffffff2d0dc7d5d0d0d0d0"
        "d0d0d0d0d0d0d0d4d5c67c0a4bffffffffffffffffffffffffffffffffffff\n"
        "ff14535f5a5b5b5a5b5a5b5f322ad5d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "0d57e36ffffffffffffffffffffffffffffffffffffffffffffde014ad5d0d0d0d0d0"
        "d0d0d0d0d0d4d5c67c2bffffffffffffffffffffffffffffffffffffffffff\n"
        "ff004f5b5a5b5a5b5a5b5a5b5f097fd5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "4d5497effffffffffffffffffffffffffffffffffffffffffff8c0091d8d0d0d0d0d0"
        "d0d0d0d4d5c66a18ffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ff21395f5a5b5a5b5b5a5b5a633b26c7d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "4d0299dffffffffffffffffffffffffffffffffffffffffffff2a1fc7d4d0d0d0d0d0"
        "d0d0d4d5911fffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffff2a635b5a5b5a5b5a5b5a5b5f1c34d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "4b10cdeffffffffffffffffffffffffffffffffffffffffff8c00aad8d0d0d0d0d0d0"
        "d0d5cd5f1cffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffff215b5b5a5b5b5a5b5a5b5a5b4f0986d8d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "57736ffffffffffffffffffffffffffffffffffffffffff9d0075d4d0d0d0d0d0d0d0"
        "d5b818ffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffff204f5f5b5a5b5a5b5b5a5b5a683b18c6d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "d575bffffffffffffffffffffffffffffffffffffffff7b005fd5d4d0d0d0d0d0d4d5"
        "a60dffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffff21295f5b5a5b5a5b5a5b5b5a5b5f1166d5d4d0d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "5506cfffffffffffffffffffffffffffffffffffff75a0043d5d4d0d0d0d0d0d4d58a"
        "04ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffff014a5f5a5b5a5b5a5b5a5b5a5b4f09a6d5d0d0d0d0d0d0d0d0d0d0d0d0d0d4d"
        "5497cffffffffffffffffffffffffffffffffffce36006ed5d4d0d0d0d0d0d4d57c08"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffff085a5b5b5a5b5a5b5a5b5b5a683617bfd4d0d0d0d0d0d0d0d0d0d0d0d0d0d"
        "53191ffffffffffffffffffffffffffffffd4630117aad5d4d0d0d0d0d0d0d58a08ff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffff21115e5b5b5a5b5a5b5a5b5a5b5b1a46d5d4d0d0d0d0d0d0d0d0d0d0d0d4c"
        "d1fadffffffffffffffffffffffffffef8410146ec6d4d0d0d0d0d0d0d0d8b10affff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffff1c185a5f5b5b5a5b5b5a5b5a5b58016dd5d4d0d0d0d0d0d0d0d0d0d0d0c"
        "704baffffffffffffffffffffffff9d210031c7ddd4d0d0d0d0d0d0d0d0d531ffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffff1c1043635b5b5a5b5a5b5b5a634f019ed8d0d0d0d0d0d0d0d0d0d0d4a"
        "610deffffffffffffffffffde94390cffff1731a6d5d4d0d0d0d0d0d0dd7419ffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffff2d00295a5f5b5a5b5a5b5a5b632235d5d0d0d0d0d0d0d0d0d0d0d57"
        "736ffffffffffffffd484350000ffffffffff39006ed5d4d0d0d0d4d5aa04ffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffff0010475b5f5f5b5f5f5f685b10b1d4d0d0d0d0d0d0d0d0d4dd5"
        "732fffffff7deb65a00002dffffffffffffffffff0058cdd5ddd5d5bf29ffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffff0008293e3e3e392121210158d5d4d0d0d0d0d0d0d0d4aa0"
        "d013e351818000a39ffffffffffffffffffffffffff0c1b6a6d6a4d0dffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffffffff0000141014ffffffff0c43bfd5d4d0d0d0d0d0d57c1"
        "1ff5a5a5a5affffffffffffffffffffffffffffffffffff2a2a2affffffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffffffffffffffffffffffffffff2a188ad5d4d4d0d0d4d534f"
        "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffffffffffffffffffffffffffffffff0946a6cdd5d5d58a0cf"
        "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffff2a0c18636d4604fff"
        "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff\n"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffff34111134fffff"
        "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
        "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
	"\n\n", f);
}

/*----------------------------------------------------------------------*/

void print_logo(FILE *f, int x, int y, float size)
{
    fprintf(f,
	    "%%----------------------------------------\n"
	    "%% Now the jpilot penguin logo; this is data\n"
	    "%% saved as Postscript from xv, then included\n"
	    "%% into the C code of jpilot!!\n\n"
	    "/origstate save def\n"
	    "20 dict begin\n"
	    "/pix 100 string def\n"
	    "%d %d translate\n"
	    "100.00800 %f mul 131.97600 %f mul scale\n"
	    "100 132 8\n"
	    "[100 0 0 -132 0 132]\n"
	    "{currentfile pix readhexstring pop}\n"
	    "image\n", x, y, size, size);
    print_logo_data(f);
    fputs("end origstate restore\n\n"
	  "%%----------------------------------------\n"
	  "%% End of logo\n"
	  "%%----------------------------------------\n", f);
}
