/****************************************************************************
 *                          VVPRemoteIviSim.cc
 *
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "VVPRemoteIviSim.h"


/********************************************************************
 * VVPRemoteIviSim()
 ********************************************************************/
VVPRemoteIviSim::VVPRemoteIviSim(
        Tcl_Interp *interp, int argc, char **argv, VPIProcVecStruct *pv) :
    IviSim(interp, argc, argv)
{
    d_pv = pv;

    /*** Setup the simulation resolution ***/
    Int32 res = pv->vpi_get(vpiTimePrecision, 0);

    setSimResolution(res);
}

/********************************************************************
 * ~VVPRemoteIviSim()
 ********************************************************************/
VVPRemoteIviSim::~VVPRemoteIviSim()
{

}

/********************************************************************
 * vpi_register_systf
 ********************************************************************/
void VVPRemoteIviSim::vpi_register_systf(const struct t_vpi_systf_data *ss)
{
    d_pv->vpi_register_systf(ss);
}

/********************************************************************
 * vpi_printf
 ********************************************************************/
void VVPRemoteIviSim::vpi_printf(const char*fmt, ...)
{
    fprintf(stderr, "FIXME: VVPRemoteIviSim::vpi_printf()\n");
}

/********************************************************************
 * vpi_mcd_close()
 ********************************************************************/
Uint32 VVPRemoteIviSim::vpi_mcd_close(Uint32 mcd)
{
    return d_pv->vpi_mcd_close(mcd);
}

/********************************************************************
 * vpi_mcd_name
 ********************************************************************/
Char *VVPRemoteIviSim::vpi_mcd_name(Uint32 mcd)
{
    return d_pv->vpi_mcd_name(mcd);
}

/********************************************************************
 * vpi_mcd_open()
 ********************************************************************/
Uint32 VVPRemoteIviSim::vpi_mcd_open(char *name)
{
    return d_pv->vpi_mcd_open(name);
}

/********************************************************************
 * vpi_mcd_printf()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_mcd_printf(Uint32 mcd, const char*fmt, ...)
{
    fprintf(stderr, "FIXME: VVPRemoteIviSim::vpi_mcd_printf()\n");
    return -1;
}

/********************************************************************
 * mcd_vprintf()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_mcd_vprintf(Uint32 mcd, const char*fmt, va_list ap)
{
    fprintf(stderr, "FIXME: VVPRemoteIviSim::vpi_mcd_vprintf()\n");
    return -1;
}

/********************************************************************
 * vpi_register_cb()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_register_cb(p_cb_data data)
{
    return d_pv->vpi_register_cb(data);
    return 0;
}

/********************************************************************
 * vpi_remove_cb()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_remove_cb(vpiHandle ref)
{
    return d_pv->vpi_remove_cb(ref);
}

/********************************************************************
 * vpi_sim_control()
 ********************************************************************/
void VVPRemoteIviSim::vpi_sim_control(Int32 operation, ...)
{
}

/********************************************************************
 * vpi_handle()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_handle(Int32 type, vpiHandle ref)
{
    return d_pv->vpi_handle(type, ref);
}

/********************************************************************
 * vpi_iterate()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_iterate(Int32 type, vpiHandle ref)
{
    return d_pv->vpi_iterate(type, ref);
}

/********************************************************************
 * vpi_scan()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_scan(vpiHandle iter)
{
    return d_pv->vpi_scan(iter);
}

/********************************************************************
 * vpi_handle_by_index()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_handle_by_index(vpiHandle ref, Int32 index)
{
    return d_pv->vpi_handle_by_index(ref, index);
}

/********************************************************************
 * vpi_get_time()
 ********************************************************************/
void VVPRemoteIviSim::vpi_get_time(vpiHandle obj, s_vpi_time*t)
{
    d_pv->vpi_get_time(obj, t);
}
 
/********************************************************************
 * vpi_get()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_get(Int32 property, vpiHandle ref)
{
    return d_pv->vpi_get(property, ref);
}

/********************************************************************
 * vpi_get_str()
 ********************************************************************/
Char* VVPRemoteIviSim::vpi_get_str(Int32 property, vpiHandle ref)
{
    return d_pv->vpi_get_str(property, ref);
}

/********************************************************************
 * vpi_get_value()
 ********************************************************************/
void VVPRemoteIviSim::vpi_get_value(vpiHandle expr, p_vpi_value value)
{
    d_pv->vpi_get_value(expr, value);
}

/********************************************************************
 * vpi_put_value()
 ********************************************************************/
vpiHandle VVPRemoteIviSim::vpi_put_value(vpiHandle obj, p_vpi_value value,
				     p_vpi_time when, Int32 flags)
{
    return d_pv->vpi_put_value(obj, value, when, flags);
}

/********************************************************************
 * vpi_free_object()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_free_object(vpiHandle ref)
{
    return d_pv->vpi_free_object(ref);
}

/********************************************************************
 * vpi_get_vlog_info()
 ********************************************************************/
Int32 VVPRemoteIviSim::vpi_get_vlog_info(p_vpi_vlog_info vlog_info_p)
{
    return d_pv->vpi_get_vlog_info(vlog_info_p);
}

