/****************************************************************************
 *                               PsPixmapObj.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a wrapper around a pixmap... This allows us to 
 *         implement various back-ends and use the same drawing code...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_PS_PIXMAP_OBJ_H
#define INCLUDED_PS_PIXMAP_OBJ_H
#include <tk.h>
#include "vector.h"
#include "types.h"
#include "GCObj.h"
#include "PixmapObj.h"
#include "ObjWidgetBase.h"
#include "LogMgr.h"
#include "FileAccObj.h"
#include "ivi_String.h"
#include "Stack.h"
#include <stdarg.h>

class GCObj;
class PsGC;
class PixmapPt;
class PixmapRange;
class PsPmClip;
class PsPixmapObj : public PixmapObj {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * PsPixmapObj()
         ************************************************************/
        PsPixmapObj(
                Tcl_Interp        *interp,
                Uint32             objc,
                Tcl_Obj           *const objv[]);

        /************************************************************
         * ~PsPixmapObj()
         ************************************************************/
        virtual ~PsPixmapObj();

        /************************************************************
         * CreateInst()
         ************************************************************/
        static int CreateInst(
                ClientData         clientData,
                Tcl_Interp        *interp,
                int                objc,
                Tcl_Obj           *const objv[]);

        /************************************************************
         * InstCmd()
         ************************************************************/
        virtual int InstCmd(int objc, Tcl_Obj *const objv[]);

        /************************************************************
         * SetMargins()
         ************************************************************/
        void SetMargins(Uint32 head, Uint32 foot, Uint32 lside, Uint32 rside);

        /************************************************************
         * line()
         ************************************************************/
        virtual void line(GC gc, Uint32 x1, Uint32 y1, Uint32 x2, Uint32 y2);

        /************************************************************
         * rect()
         ************************************************************/
        virtual void rect(GC gc, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * fill_rect()
         ************************************************************/
        virtual void fill_rect(GC gc, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * ComputeTextLayout()
         ************************************************************/
        virtual Tk_TextLayout ComputeTextLayout(
                Tk_Font font, Char *str, Int32 len, Int32 wraplen,
                Tk_Justify justify,
                Int32 flags, Int32 *width, Int32 *height);

        /************************************************************
         * DrawTextLayout()
         ************************************************************/
        virtual void DrawTextLayout(
                GC gc, Tk_TextLayout layout, Uint32 x, Uint32 y, 
                Int32 first, Int32 last);

        /************************************************************
         * FreeTextLayout()
         ************************************************************/
        virtual void FreeTextLayout(Tk_TextLayout layout);

        /************************************************************
         * createGC()
         ************************************************************/
        virtual GC createGC(GCObj &gcObj);

        /************************************************************
         * freeGC()
         ************************************************************/
        virtual void freeGC(GCObj &gcObj);

        /************************************************************
         * copy 
         *
         * Copy data from (x,y)-(x+width,y+height) to (x1, y1)
         ************************************************************/
        virtual void copy(PixmapObj *obj, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height, Uint32 x1, Uint32 y1);

        /************************************************************
         * copy 
         *
         * Copy data from (x,y)-(x+width,y+height) to (x1, y1)
         ************************************************************/
        virtual void copy(PixmapObj *obj, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * blank()
         *
         * sets the color of the pixmap to the background color...
         ************************************************************/
        virtual void blank();

#if 0
        /************************************************************
         * operator =
         ************************************************************/
        virtual void operator = (const PixmapRange &rng);
#endif

        /************************************************************
         * setBgColor()
         ************************************************************/
        virtual void setBgColor(Tk_3DBorder background);

        /************************************************************
         * width()
         ************************************************************/
        virtual Uint32 width() const;

        /************************************************************
         * getRealWidth()
         ************************************************************/
        Uint32 getRealWidth() const;

        /************************************************************
         *  height()
         ************************************************************/
        virtual Uint32 height() const;

        /************************************************************
         * getRealHeight()
         ************************************************************/
        Uint32 getRealHeight() const;

        /************************************************************
         * width_height()
         ************************************************************/
        virtual void width_height(Uint32 width, Uint32 height);

        /************************************************************
         * setWinRect()
         ************************************************************/
        void setWinRect(Uint32 x, Uint32 y, Uint32 w, Uint32 h);

        /************************************************************
         * prvSetWinRect()
         ************************************************************/
        void prvSetWinRect(Uint32 x, Uint32 y, Uint32 w, Uint32 h);

        /************************************************************
         * clrWinRect()
         ************************************************************/
        void clrWinRect();

        /************************************************************
         * getType()
         *
         * returns the type of this pixmap...
         ************************************************************/
        virtual PixmapObj::PixmapType getType() const;

        /************************************************************
         * getOptionSpec()
         ************************************************************/
        static Tk_OptionSpec *getOptionSpec();

        /************************************************************
         * getCmdStructs()
         ************************************************************/
        ObjWidgetBase::CmdStruct *getCmdStructs();

        /************************************************************
         * setPaperSize()
         ************************************************************/
        int setPaperSize(const char *size);

        /************************************************************
         * newPage()
         ************************************************************/
        void newPage();

        /************************************************************
         * StartPage()
         ************************************************************/
        void StartPage();

        /************************************************************
         * EndPage()
         ************************************************************/
        void EndPage();

        /************************************************************
         * getWinRect()
         ************************************************************/
        void getWinRect(Uint32 &x, Uint32 &y, Uint32 &w, Uint32 &h);


    /****************************************************************
     * Public Data
     ****************************************************************/
    public:
        static Tk_OptionTable    d_OptTab;

        Uint32 ok;

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * InstCmd()
         ************************************************************/
        static int InstCmd(
                ClientData        clientData,
                Tcl_Interp       *interp,
                int               objc,
                Tcl_Obj          *const objv[]);

        /************************************************************
         * Configure()
         ************************************************************/
        int Configure(int objc, Tcl_Obj *const objv[]);

        /************************************************************
         * ConfigPaper()
         ************************************************************/
        int ConfigPaper();

        /************************************************************
         * OutputHeader()
         ************************************************************/
        void OutputHeader();

        /************************************************************
         * ConfigFile()
         ************************************************************/
        int ConfigFile();

        struct PaperSize;
        /************************************************************
         * FindPaperSize()
         ************************************************************/
        PaperSize *FindPaperSize(const char *name);

        /************************************************************
         * emit()
         ************************************************************/
        void emit(const char *fmt, ...);

        /************************************************************
         * translate()
         ************************************************************/
        void translate(Uint32 &x, Uint32 &y);

        /************************************************************
         * SetGC()
         ************************************************************/
        void SetGC(GC gc);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Tcl_DString         dStr;

        /*** All paper measurements based on portrait orientation ***/
        struct PaperSize {
            char     *name;
            Uint32    x;
            Uint32    y;
        };

        /*** Option spec ***/
        enum {
            Opt_PaperSize       = 0x0001,
            Opt_PaperOrient     = 0x0002,
            Opt_OutputFilename  = 0x0004,
            Opt_NumOpts         = 0x8000
        };

        static PaperSize  d_paperSizes[];


        struct PsPixmapConfig {
            char        *paperSizeStr;
            char        *paperOrientStr;
            char        *outputFilename;
        };

        PaperSize            *d_paperSize;
        PsPixmapConfig        d_config;
        bool                  d_isLandscape;
        bool                  d_paperConfigured;
        bool                  d_headerOutput;
        FileAccObj           *d_fileAcc;

        Uint32                d_originX;
        Uint32                d_originY;
        Uint32                d_winW;
        Uint32                d_winH;

        Uint32                d_headMargin;
        Uint32                d_footMargin;
        Uint32                d_lsideMargin;
        Uint32                d_rsideMargin;

        Tcl_Interp           *d_interp;
        String                d_instName;
        PsGC                 *d_currGC;
        Uint32                d_currPage;
        Stack<PsPmClip>       d_clipStack;
        bool                  d_pageDone;

        static char           d_prvBuf[8192];
};

#endif /* INCLUDED_PS_PIXMAP_OBJ_H */

