/****************************************************************************
 *                            IviUintHashTab.cc
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "IviUintHashTab.h"
#include <stdio.h>

/********************************************************************
 * IviUintHashTabBase()
 ********************************************************************/
IviUintHashTabBase::IviUintHashTabBase()
{
    d_treeRoot = new IviUintHashTabLevel(0);
}

/********************************************************************
 * ~IviUintHashTabBase()
 ********************************************************************/
IviUintHashTabBase::~IviUintHashTabBase()
{
    delete d_treeRoot;
}

/********************************************************************
 * base_add()
 ********************************************************************/
void IviUintHashTabBase::base_add(IviUintHashTabEntryBase *entry)
{
    Uint32                  key = entry->getKey();
    IviUintHashTabLevel    *level = d_treeRoot;

    /**** Search through each level, adding levels as we go... ****/
    for (Uint32 i=0; i<7; i++) {
        Uint32 idx = (key >> (4*(7-i))) & 0x0F;

        if (level->d_children[idx] == 0) {
            level->d_children[idx] = new IviUintHashTabLevel(i+1);
        }

        level = (IviUintHashTabLevel *)level->d_children[idx];
    }

    level->d_children[key & 0x0F] = entry;
}

/********************************************************************
 * base_find()
 ********************************************************************/
IviUintHashTabEntryBase *IviUintHashTabBase::base_find(Uint32 key)
{
    IviUintHashTabLevel    *level = d_treeRoot;

    for (Uint32 i=0; i<7; i++) {
        Uint32 idx = ((key >> (4*(7-i))) & 0x0F);

        if (level->d_children[idx] == 0) {
            return 0;
        }

        level = (IviUintHashTabLevel *)level->d_children[idx];
    }

    if (!level) {
        return 0;
    } else {
        return (IviUintHashTabEntryBase *)level->d_children[key&0x0F];
    }
}

/********************************************************************
 * base_remove()
 ********************************************************************/
void IviUintHashTabBase::base_remove(IviUintHashTabEntryBase *e)
{
    Uint32                  key   = e->getKey();
    IviUintHashTabLevel    *level = d_treeRoot;

    for (Uint32 i=0; i<7; i++) {
        Uint32 idx = ((key >> (4*(7-i))) & 0x0F);

        if (level->d_children[idx] == 0) {
            fprintf(stderr, "ERROR: Trying to remove non-existent UintHash "
                    "entry (key=0x%08x)\n", e->getKey());
            return;
        }

        level = (IviUintHashTabLevel *)level->d_children[idx];
    }

    if (!level) {
        fprintf(stderr, "ERROR: Hash entry in UintHash attempted "
                "double-removal: key=0x%08x\n", e->getKey());
        return;
    } else {
        level->d_children[key&0x0F] = 0;
    }
}


