/****************************************************************************
 *                                alu.v
 *
 * Author: Matthew Ballance
 * Desc:   Implements a simple ALU... 
 ****************************************************************************/
`include "alu_ops.v"

module alu(
    clk,
    valid,
    in_a,
    in_b,
    out,
    op);

input           clk, valid;
input [31:0]    in_a, in_b;
input [7:0]     op;
output[31:0]    out;
reg   [31:0]    out, acc;


always @ (posedge clk)
begin
    if (valid == 1) begin
        case (op)
            `OP_ADD:
                out = in_a + in_b;

            `OP_SUB:
                out = in_a - in_b;

            `OP_MUL:
                out = in_a * in_b;

            `OP_DIV:
                out = in_a / in_b;

            `OP_SHL:
                out = in_a << in_b;

            `OP_SHR:
                out = in_a >> in_b;

            `OP_MOV:
                acc = out;

            `OP_ACC:
            begin
                acc = acc + in_a + in_b;
                out = acc;
            end

            default:
                out = 'bx;
        endcase
    end
end

endmodule


