/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/gdk/gl/query.h
//! @brief A C++ wrapper interface for the Open-GL query functions.

#ifndef INTI_GDK_GL_QUERY_H
#define INTI_GDK_GL_QUERY_H

#ifndef __GDK_GL_QUERY_H__
#include <gdk/gdkglquery.h>
#endif

namespace Inti {

namespace Gdk {

class Display;

namespace GL {

//! @name Query Methods
//! @{

bool query_extension(const Gdk::Display *display = 0);
//!< Indicates whether the window system supports the OpenGL extension (GLX, WGL, etc).
//!< @param display The Gdk::Display where the query is sent to, or null for the default display.
//!< @return <EM>true</EM> if OpenGL is supported, <EM>false</EM> otherwise.

bool query_version(int *major, int *minor, const Gdk::Display *display = 0);
//!< Gets the version numbers of the OpenGL extension to the window system.
//!< @param major Return location for the major version number of the OpenGL extension.
//!< @param minor Return location for the minor version number of the OpenGL extension.
//!< @param display The Gdk::Display where the query is sent to, or null for the default display.
//!< @return <EM>false</EM> if it fails, <EM>true</EM> otherwise.
//!<
//!< <BR>In the X Window System, it returns the GLX version. In the Microsoft
//!< Windows, it returns the Windows version.

bool query_gl_extension(const char *extension);
//!< Determines whether a given OpenGL extension is supported.
//!< @param extension The name of the OpenGL extension.
//!< @returns <EM>true</EM> if the OpenGL extension is supported, <EM>false</EM> if not supported.
//!<
//!< <BR>There must be a valid current rendering context to call query_gl_extension().
//!< This method returns information about OpenGL extensions only. This means that
//!< window system dependent extensions (for example, GLX extensions) are not reported
//!< by query_gl_extension().

GdkGLProc get_proc_address(const char *proc_name);
//!< Gets the address of the OpenGL, GLU, or GLX function.
//!< @param proc_name The function name.
//!< @return The address of the function named by proc_name.

//! @}

} // namespace GL

} // namespace Gdk

} // namespace Inti

#endif // INTI_GDK_GL_QUERY_H

