<?php
/**
 * Maintenance module that deletes old linked attachments.
 *
 * $Horde: imp/lib/Maintenance/Task/delete_attachments_monthly.php,v 1.4 2004/08/02 08:35:22 jan Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Andrew Coleman <mercury@appisolutions.net>
 * @package Horde_Maintenance
 */
class Maintenance_Task_delete_attachments_monthly extends Maintenance_Task {

    /**
     * Purges the old linked attachment folders.
     *
     * @access public
     *
     * @return boolean  Whether any old attachments were deleted.
     */
    function doMaintenance()
    {
        global $conf, $prefs;
        require_once IMP_BASE . '/lib/Compose.php';
        require_once 'Horde/Auth.php';
        require_once 'VFS.php';

        $current_ts = time();
        $monthday = date('m');
        if ($monthday > 1) {
            $daystring = strtotime(sprintf('-%d days', $monthday), $current_ts);
        }
        $timestring = sprintf('-%d month', $prefs->getValue('delete_attachments_monthly_keep'));
        $prev_ts = strtotime($timestring, $current_ts);

        $vfs = &VFS::singleton($conf['vfs']['type'], Horde::getDriverConfig('vfs', $conf['vfs']['type']));
        $olddirs = $vfs->listFolders(IMP_VFS_LINK_ATTACH_PATH . '/' . Auth::getAuth(), array(), false);
        if (is_a($olddirs, 'PEAR_Error')) {
            return $olddirs;
        }

        foreach ($olddirs as $dir) {
            $base = basename($dir['val']);
            if (strnatcmp($base, $prev_ts) < 0 && $base !== basename(IMP_VFS_LINK_ATTACH_PATH)) {
                $vfs->deleteFolder(str_replace($base, '', $dir['val']), $base, true);
            }
        }

        return true;
    }

    /**
     * Returns information for the maintenance function.
     *
     * @access public
     *
     * @return string  Description of what the operation is going to do during
     *                 this login.
     */
    function describeMaintenance()
    {
        global $prefs;

        return sprintf(_("All old linked attachments more than %s months old will be deleted."), $prefs->getValue('delete_attachments_monthly_keep'));
    }

}
