/* 
 * BrowserController.h created by phr on 2000-10-21 09:35:37 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: BrowserController.h,v 1.7 2003/06/29 17:28:34 probert Exp $
 */

#ifndef _BROWSERCONTROLLER_H_
#define _BROWSERCONTROLLER_H_

#include <AppKit/AppKit.h>

@class ImageCache;

@interface BrowserController : NSObject
{
  id delegate;

  NSBrowser *_browser;
  NSMutableArray *_files;
  NSString *_path;
  NSImageView *_imageView;
  ImageCache *_imageCache;

  NSString *currentPath;
  NSImageRep *currentImgRep;
  NSDictionary *currentAttribs;
  int reps;
  NSSize currentImgSize;
}

- (id)initWithBrowser:(NSBrowser *)browser;
- (void)dealloc;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (void)setPath:(NSString *)path;
- (void)setImageView:(NSImageView *)imageView;

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column;
- (void)browser:(NSBrowser *)sender willDisplayCell:(id)cell atRow:(int)row column:(int)column;

- (BOOL)browser:(NSBrowser *)sender isColumnValid:(int)column;

- (void)showImage:(NSBrowser *)sender;

//- (BOOL)browser:(NSBrowser *)sender selectCellWithString:(NSString *)title inColumn:(int)column;

- (NSString *)currentPath;
- (NSImageRep *)currentImgRep;
- (NSDictionary *)currentAttribs;
- (int)currentImgRepCount;
- (NSSize)currentImgSize;

@end

@interface NSObject (BrowserControllerDelegates)

- (void)browserSelectionDidChange:(id)sender;

@end

#endif // _BROWSERCONTROLLER_H_
