/* $Id: input-context.c,v 1.1.1.1 2002/08/31 04:18:02 himi Exp $ */


#include <stdlib.h>

#include <iiimp.h>

#include "input-method.h"
#include "input-context.h"


IIIMF_status
iiimf_ic_new(IIIMF_im *		im,
	     void *		client_data,
	     IIIMF_ic **	ic_ret)
{
    IIIMF_ic *	ic;

    if (NULL == im) return IIIMF_STATUS_IM_INVALID;

    ic = (IIIMF_ic *)malloc(sizeof (IIIMF_ic));
    if (NULL == ic) return IIIMF_STATUS_MALLOC;

    ic->ic_id = 0;
    ic->state = 0;
    ic->im = im;
    ic->language = NULL;
    ic->input_method = NULL;
    ic->language_list = NULL;
    ic->preedit_maximum_length = -1;
    ic->client_data = client_data;
    ic->next = im->ic_list;
    im->ic_list = ic;

    *ic_ret = ic;
    return IIIMF_STATUS_SUCCESS;
}


void
iiimf_ic_delete(IIIMF_ic *	ic)
{
    IIIMF_im *	im;
    IIIMF_ic *	p;

    im = ic->im;

    if (ic == im->ic_list) {
	im->ic_list = ic->next;
    } else {
	for (p = im->ic_list; NULL != p; p = p->next) {
	    if (p->next == ic) {
		p->next = ic->next;
	    }
	}
    }

    iiimp_string_list_delete(im->data_s, ic->language_list);
    free(ic);
}


IIIMF_status
iiimf_ic_id_set(IIIMF_ic *	ic,
		int		ic_id)
{
    ic->ic_id = ic_id;
    return IIIMF_STATUS_SUCCESS;
}


void *
iiimf_ic_data_get(IIIMF_ic *	ic)
{
    return ic->client_data;
}


void *
iiimf_ic_data_set(
    IIIMF_ic *	ic,
    void *	client_data)
{
    void *	p;
    p = ic->client_data;
    ic->client_data = client_data;
    return p;
}


IIIMF_status
iiimf_ic_langauage_set(IIIMF_ic * ic, const char * language)
{
    IIIMF_status	status;
    IIIMP_string *	p;

    if (NULL == language) {
	iiimp_string_delete(ic->im->data_s, ic->language);
	ic->language = NULL;
	return IIIMF_STATUS_SUCCESS;
    }

    status = iiimf_data_string_ascii_new(ic->im->data_s, language, &p);
    if (IIIMF_STATUS_SUCCESS != status) {
	return status;
    }
    iiimp_string_delete(ic->im->data_s, ic->language);
    ic->language = p;

    return IIIMF_STATUS_SUCCESS;
}


IIIMF_status
iiimf_ic_input_method_set(IIIMF_ic * ic, const char * input_method)
{
    IIIMF_status	status;
    IIIMP_string *	p;

    if (NULL == input_method) {
	iiimp_string_delete(ic->im->data_s, ic->input_method);
	ic->input_method = NULL;
	return IIIMF_STATUS_SUCCESS;
    }

    status = iiimf_data_string_ascii_new(ic->im->data_s, input_method, &p);
    if (IIIMF_STATUS_SUCCESS != status) {
	return status;
    }
    iiimp_string_delete(ic->im->data_s, ic->input_method);
    ic->input_method = p;

    return IIIMF_STATUS_SUCCESS;
}


IIIMF_status
iiimf_ic_preedit_maximum_length_set(IIIMF_ic * ic, int preedit_maximum_length)
{
    ic->preedit_maximum_length = preedit_maximum_length;
    return IIIMF_STATUS_SUCCESS;
}


int
iiimf_ic_id(IIIMF_ic * ic)
{
    return ic->ic_id;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
