#ifndef IIIMLINEDIT_HH_
#define IIIMLINEDIT_HH_
#include <iiimcf.h>
#include <qlineedit.h>
#include "IIIMPreedit.hh"
#include "IIIMStatus.hh"
#include "IIIMLookupChoice.hh"

class IIIMLineEdit : public QLineEdit
{
    Q_OBJECT;

    int iiimcf_flag;
    IIIMCF_handle handle;
    IIIMCF_context ctx;
    IIIMPreeditWidget *ppw;
    IIIMStatusWidget *psw;
    IIIMLookupChoiceWidget *plw;

    IIIMCF_language get_language(
	const char *id
    );
    IIIMPreeditWidget *get_preedit();
    IIIMStatusWidget *get_status();
    IIIMLookupChoiceWidget *get_lookup_choice();
    IIIMCF_context get_context();
    void toggle_im(
	IIIMCF_context c,
	bool flag
    );
    void commit_string();
    void deal_with_iiimcf_event();
    void update_UI();

    void resizeEvent(
	QResizeEvent *pre
    );
    void moveEvent(
	QMoveEvent *pme
    );

  protected:
    void keyPressEvent(
	QKeyEvent *e
    );

  signals:
    void ref_changed();

  public:
    IIIMLineEdit(
	IIIMCF_handle iiimcfhandle,
	QWidget *parent = 0,
	const char *name = 0
    );
    ~IIIMLineEdit();
};
#endif

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */


