/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

/*
 * "$Id: csc_entry_internal.c,v 1.1.1.1 2000/10/29 16:44:24 himi Exp $"
 */

#pragma ident	"@(#)csc_entry_internal.c 1.12	99/05/26 SMI"

#include <string.h>

#include "csc_entry.h"
#include "csc_entry_internal.h"

#include "trace_message.h"

#define CSC_ENTRY_GROUP(base)	base##_open, base##_conv, base##_close
#define CSC_ENTRY_GROUP2(base)	{#base, base##_open, base##_conv, base##_close}


static csc_entry_internal_t	csc_entry_internal[] = {
#if !defined(CSC_ENT_INT_FAKE)
	CSC_ENTRY_GROUP2(big5_ct),
	CSC_ENTRY_GROUP2(big5w_ct),
	CSC_ENTRY_GROUP2(cns_ct),
	CSC_ENTRY_GROUP2(cnsw_ct),
	CSC_ENTRY_GROUP2(ct_big5),
	CSC_ENTRY_GROUP2(ct_big5w),
	CSC_ENTRY_GROUP2(ct_cns),
	CSC_ENTRY_GROUP2(ct_cnsw),
	CSC_ENTRY_GROUP2(ct_euc),
	CSC_ENTRY_GROUP2(ct_eucw),
	CSC_ENTRY_GROUP2(ct_pck),
	CSC_ENTRY_GROUP2(ct_pckw),
	CSC_ENTRY_GROUP2(ct_utf16),
	CSC_ENTRY_GROUP2(ct_utf8),
	CSC_ENTRY_GROUP2(ct_utf8w),
	CSC_ENTRY_GROUP2(ctex_mbs),
	CSC_ENTRY_GROUP2(ctex_wcs),
	CSC_ENTRY_GROUP2(euc_ct),
	CSC_ENTRY_GROUP2(eucw_ct),
	CSC_ENTRY_GROUP2(iconv_relay),
	CSC_ENTRY_GROUP2(iconv_relay_mb_wc),
	CSC_ENTRY_GROUP2(iconv_relay_wc_mb),
	CSC_ENTRY_GROUP2(mbs_ctex),
	CSC_ENTRY_GROUP2(mbs_wcs),
	CSC_ENTRY_GROUP2(nil),
	CSC_ENTRY_GROUP2(pck_ct),
	CSC_ENTRY_GROUP2(pckw_ct),
	CSC_ENTRY_GROUP2(utf16_ct),
	CSC_ENTRY_GROUP2(utf8_ct),
	CSC_ENTRY_GROUP2(utf8w_ct),
	CSC_ENTRY_GROUP2(wcs_ctex),
	CSC_ENTRY_GROUP2(wcs_mbs),

#if 0
	{"utf16_utf8",		CSC_ENTRY_GROUP(iconv_relay)},
	{"iconv_relay",		CSC_ENTRY_GROUP(iconv_relay)},
	{"iconv_relay_wc_mb",	CSC_ENTRY_GROUP(iconv_relay_wc_mb)},
	{"iconv_relay_mb_wc",	CSC_ENTRY_GROUP(iconv_relay_mb_wc)},
/*  	{"mbs_ct",		CSC_ENTRY_GROUP(mbs_ct)}, */
/*  	{"wcs_ct",		CSC_ENTRY_GROUP(wcs_ct)}, */
	{"utf16_ct",		CSC_ENTRY_GROUP(utf16_ct)},
/*  	{"ct_mbs",		CSC_ENTRY_GROUP(ct_mbs)}, */
/*  	{"ct_wcs",		CSC_ENTRY_GROUP(ct_wcs)}, */
	{"ct_utf16",		CSC_ENTRY_GROUP(ct_utf16)},
	{"wcs_utf16",		CSC_ENTRY_GROUP(wcs_utf16)},
	{"mbs_wcs",		CSC_ENTRY_GROUP(mbs_wcs)},
	{"wcs_mbs",		CSC_ENTRY_GROUP(wcs_mbs)},
	{"euc_ct",		CSC_ENTRY_GROUP(euc_ct)},
	{"eucw_ct",		CSC_ENTRY_GROUP(eucw_ct)},
	{"mbs_ctex",		CSC_ENTRY_GROUP(mbs_ctex)},
	{"wcs_ctex",		CSC_ENTRY_GROUP(wcs_ctex)},
	{"pck_ct",		CSC_ENTRY_GROUP(pck_ct)},
	{"pckw_ct",		CSC_ENTRY_GROUP(pckw_ct)},
	{"ct_euc",		CSC_ENTRY_GROUP(ct_euc)},
	{"ct_eucw",		CSC_ENTRY_GROUP(ct_eucw)},
	{"ctex_mbs",		CSC_ENTRY_GROUP(ctex_mbs)},
	{"ctex_wcs",		CSC_ENTRY_GROUP(ctex_wcs)},
	{"ct_pck",		CSC_ENTRY_GROUP(ct_pck)},
	{"ct_pckw",		CSC_ENTRY_GROUP(ct_pckw)},
	{"nil",			CSC_ENTRY_GROUP(nil)},
#endif /* 0 */
#endif /* CSC_ENT_INT_FAKE */
	{NULL, 			NULL, NULL, NULL}	/* Trailer */
};

csc_entry_internal_t *
csc_lookup_entry_internal(
	csc_entry_internal_t *	entry,
	const char *		sym,
	int			len)
{
#if !defined(CSC_ENT_INT_FAKE)
	TRACE_MESSAGE('l', ("csc_lookup_entry_internal: %.*s", len, sym));

	if (NULL == entry) {
		entry = csc_entry_internal;
	} else {
		entry += 1;
	}

	for (; NULL != entry->entry_name; entry++) {
		if (0 == strncmp(entry->entry_name, sym, len)) {
			TRACE_MESSAGE('l', (": found\n"));
			return entry;
		}
	}
	TRACE_MESSAGE('l', ("\n"));
#else /* CSC_ENT_INT_FAKE */
	TRACE_MESSAGE('l', ("csc_lookup_entry_internal: %.*s: FAKE\n", len, sym));
#endif /* CSC_ENT_INT_FAKE */
	return NULL;
}
