#ifndef _KEYBOARDCONFIG_H_
#define _KEYBOARDCONFIG_H_

enum _BaseKeyList {
	VK_invalid  = -2,
	VK_movearea = -1,
	VK_quotedbl = 0,
	/* first line of keyboard */
	VK_1,
	VK_2,
	VK_3,
	VK_4,
	VK_5,
	VK_6,
	VK_7,
	VK_8,
	VK_9,
	VK_0,
	VK_minus,
	VK_equal,

	/* second line of keyboard */
	VK_q,
	VK_w,
	VK_e,
	VK_r,
	VK_t,
	VK_y,
	VK_u,
	VK_i,
	VK_o,
	VK_p,
	VK_bracketleft,
	VK_bracketright,
	VK_backslash,

	/* third line of keyboard */
	VK_a,
	VK_s,
	VK_d,
	VK_f,
	VK_g,
	VK_h,
	VK_j,
	VK_k,
	VK_l,
	VK_semicolon,
	VK_apostrophe,
	
	/* forth line of keyboard */
	VK_z,
	VK_x,
	VK_c,
	VK_v,
	VK_b,
	VK_n,
	VK_m,
	VK_colon,
	VK_period,
	VK_slash,

	MAX_BASEKEY_NUM
};

enum _CtrlKeyList {
	VK_BackSpace = 0,
	VK_Tab,
	VK_Caps_Lock,
	VK_Enter,
	VK_Shift_L,
	VK_Control_L,
	VK_Alt_L,
	VK_space,
	VK_escape,

	MAX_CTRLKEY_NUM
};

enum _KeyboardType {
	KEYBOARD_STRING_TYPE = 0,
	KEYBOARD_KEY_TYPE,
};

#define MAX_VK_NUM  		(MAX_BASEKEY_NUM + MAX_CTRLKEY_NUM)
#define MAX_KEYBOARD_NUM 	32

#define KEYLIST_LOWER		"`1234567890-=qwertyuiop[]\\asdfghjkl;\'zxcvbnm,./";
#define KEYLIST_UPPER		"~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?";
#define KEYLIST_LABEL		"`1234567890-=QWERTYUIOP[]\\ASDFGHJKL;\'ZXCVBNM,./";
	
#define BACKSPACE_KEY_LABEL	"<-"
#define TAB_KEY_LABEL		"Tab"
#define CAPS_KEY_LABEL		"Caps"
#define ENTER_KEY_LABEL 	"Enter"
#define SHIFT_KEY_LABEL		"Shift"
#define CTRL_KEY_LABEL		"Ctrl"
#define ALT_KEY_LABEL		"Alt"
#define SPACE_KEY_LABEL		" "
#define ESCAPE_KEY_LABEL	"Esc"

typedef struct _BaseKeyStruct {
	char 		*lower_str;
	char 		*upper_str;
} BaseKeyStruct;

typedef struct _CtrlKeyStruct {
	char 		*label_str;
} CtrlKeyStruct;

typedef struct _KeyboardLayout {
	char 		*ename;
	char 		*name_in_ko;
	char 		type;
#if 0
	int 		encode;
#endif
	BaseKeyStruct	basekey[MAX_BASEKEY_NUM];
	CtrlKeyStruct	ctrlkey[MAX_CTRLKEY_NUM];
} KeyboardLayout;

KeyboardLayout *keyboard_layout_new (void);
int Keyboards_Init (int *n_keyboards, KeyboardLayout ***keyboards);
#ifdef TEST_RUN
void Keyboards_Print (void);
#endif

#endif     /*  _KEYBOARDCONFIG_H_  */

