/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "PYIM.h"
#include "ZyBasic.h"
#include "PyBig5.h"

VOID FilterCandiForward(JINT nSesID, ImToXSun * to);
VOID FilterCandiBackward(JINT nSesID, ImToXSun * to, JINT EndBak);
ImToXSun* BackToFirstPage(JINT nSesID, int phrasenum);
ImToXSun* CommitCandidate(int nSesID, ImToXSun * to, int index);

JINT tones[256], TonesNum;

VOID GetPreeditTones(CHAR *raw, JINT hz_caret, JINT length) {
    int i, j;
    if(raw[hz_caret] == CY_SEP) hz_caret ++;
    for (i = hz_caret, j = 0; i < length; i ++) {
	if (raw[i] == CY_SEP) {
	    if( (i > 0) && IsTone(raw[i - 1])) tones[j] = raw[i - 1];
	    else tones[j] = 0;
	    j ++;
	}
    }
    if(raw[length - 1] != CY_SEP) {
	if(!IsTone(raw[length - 1])) tones[j] = 0;
        else if(IsTone(raw[length - 1])) tones[j] = raw[length - 1];
	j ++;
    }
    TonesNum = j;
}

JINT GetTone(JINT nHzcode) {
    JINT    hi, low;
    JINT    res;
    JINT    t1, t2, t3, t4;

    hi = (nHzcode >> 8) & 0x00FF;
    low = nHzcode & 0x00FF;

    t1 = t2 = t3 = t4 = 0;
    res = 0;

    if ((hi >= 0xA4) && (hi <= 0xC6) && (low >= 0x40) && (low <= 0xFE)) {
	if(low >= 0xA1) low -= 0x22;
	t1 = (hi - 0xA4) * 157 + (low - 0x40) + 1;
	t2 = t1 / 8;
	t4 = (t1 % 8) * 4;
	if(t4 == 0) res = (int) (BIG5TONE[t2 - 1] & 0x000F);
	else res = (int)( BIG5TONE[t2] >> (32 - t4) ) & 0x000F;
    }
    else if ((hi >= 0xC9) && (hi <= 0xF9) && (low >= 0x40) && (low <= 0xFE)) {
	if(low >= 0xA1) low -= 0x22;
	t1 = (hi - 0xC9) * 157 + (low - 0x40) + 1; 
	t2 = t1 / 8 + 676;
	t4 = (t1 % 8) * 4;
	if(t4 == 0) res = (int) (BIG5TONE[t2 - 1] & 0x000F);
	else res = (int)( BIG5TONE[t2] >> (32 - t4) ) & 0x000F;
    }
    
    return res + 50;
}

JINT GetDYZTone(JINT nHzindex) {
    JINT    res = 0;
    JINT    t1, t2, t3, t4;
    
    t1 = t2 = t3 = t4 = 0;
/*
printf("HZIndex = %d\n", nHzindex);
*/
    t1 = nHzindex + 1;
    t2 = t1 / 8;
    t4 = (t1 % 8) * 4;
    if(t4 == 0) res = (int) (DYZTONE[t2 - 1] & 0x000F);
    else res = (int)(DYZTONE[t2] >> (32 - t4) ) & 0x000F;
/*
printf("DYZ Tone = %d\n", res);
*/
    return res + 50;
}

JINT IsDYZ(JINT nHzcode) {
    JINT    nHiHzPos, nLowHz;
    JINT    i, j;

    nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
    nLowHz   = nHzcode & 0x00FF;

    j = 0;

    for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++) {
	if( (DYZLIST[i] & 0x00FF) == nLowHz ) break;
    }

    if(i == INDEXOFDYZLIST[nHiHzPos + 1]) return FALSE;
    else return TRUE;
}

JINT MatchTone(JINT nHzcode, JINT nTone) {
    JINT    nHiHzPos, nLowHz;
    JINT    i, j;

    nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
    nLowHz   = nHzcode & 0x00FF;

    j = 0;

    if((nTone == 0) || (GetTone(nHzcode) == nTone)) return TRUE;
    else if(IsDYZ(nHzcode)) {
        for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++) {
	    if( (DYZLIST[i] & 0x00FF) == nLowHz ) 
		if(GetDYZTone(i) == nTone) return TRUE;
        }
	return FALSE;
    }
    else return FALSE;
}

ImToXSun* BackToFirstPage(JINT nSesID, int phrasenum) {
    ImToXSun* firstpage;
    firstpage = (ImToXSun*) IM_trans(nSesID, IMXK_Return, IMXK_Return, 0);
    if((phrasenum > 0) && (firstpage->nCandiStart != 0))
    	firstpage = (ImToXSun*) IM_trans(nSesID, IMXK_Return, IMXK_Return, 0);
    return firstpage;
}

/* select candidates whose tones are same as preedit. */
VOID FilterCandiForward(JINT nSesID, ImToXSun * to) {
    int i, j, k = 0, startbak;
    int phrasenum, singlenum, hznum;
    ImToXSun* thepage; 
    UCHAR temp[5];
/*
printf("\nto->nCandiStart = %d to->nCandiEnd = %d\n", to->nCandiStart, to->nCandiEnd);
*/
    startbak = to->nCandiStart;
    phrasenum = to->nTotalPhraseNum;
    singlenum = to->nTotalSingleHzNum;
    to->nChoiceNum = 0;

    thepage = BackToFirstPage(nSesID, phrasenum);

    if(to->nCandiStart < phrasenum) {
        while((thepage->nCandiStart + thepage->nChoiceNum) < to->nCandiStart) {
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
        }
        while((k < 5) && ((thepage->nCandiStart + thepage->nChoiceNum) <= phrasenum)) {
	    for(i = 0; i < thepage->nChoiceNum; i ++) {
	        if((i + thepage->nCandiStart) < to->nCandiStart) continue;
	        j = 0;
	        while((thepage->pwLookupChoice[i][j] != 0) && (j < TonesNum)) {
/*
	            if((tones[j] != 0) && (GetTone(thepage->pwLookupChoice[i][j]) != tones[j]))
*/
		    if(!MatchTone(thepage->pwLookupChoice[i][j], tones[j]))
		        break;
	            j ++;
	        }
	        if(thepage->pwLookupChoice[i][j] == 0) {
		    for(j = 0; thepage->pwLookupChoice[i][j] != 0; j ++) {
/*
		        printf("%x ", thepage->pwLookupChoice[i][j]);
*/
		        to->pwLookupChoice[k][j] = thepage->pwLookupChoice[i][j];
		    }
		    to->pwLookupChoice[k][j] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == 0) {
/*
printf("thepagestart = %d, i = %d\n", thepage->nCandiStart, i);
*/
			to->nCandiStart = thepage->nCandiStart + i;
		    }
	            k ++;
		    if(k == 5)  break;
	        }
	    } 
	    if(thepage->nCandiStart + thepage->nChoiceNum == phrasenum) {
/*
printf("SET nLastPhrasePageNum = %d !!!!\n", k);
printf("thepage->nCandiStart = %d thepage->nChoiceNum = %d !!!!\n", thepage->nCandiStart, thepage->nChoiceNum);
*/
		if(k != 0) to->nLastPhrasePageNum = k;
		break;
	    }
	    else if(k == 5) break;

    	    if((k < 5) && ((thepage->nCandiStart + thepage->nChoiceNum) < phrasenum)) {
	        thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
	    }
        }
        to->nCandiEnd = thepage->nCandiStart + i;
        if(k == 0) to->nCandiStart = to->nCandiEnd;
    }

    if((k == 0) || (to->nCandiStart >= phrasenum)) {
        while((thepage->nCandiStart + thepage->nChoiceNum) < to->nCandiStart) {
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
        }
	while((k < 7) && ((thepage->nCandiStart + thepage->nChoiceNum) <= (phrasenum + singlenum))) {
	    for(i = 0; i < thepage->nChoiceNum; i ++) {
	        if((i + thepage->nCandiStart) < to->nCandiStart) continue;
		temp[0] = (thepage->pwLookupChoice[i][0] >> 8) & 0xff;
		temp[1] = thepage->pwLookupChoice[i][0] & 0xff;
		temp[2] = 0;
/*
		printf("%s ", temp);
	        if((tones[0] == 0) || (GetTone(thepage->pwLookupChoice[i][0]) == tones[0])) {
*/
		if((thepage->pwLookupChoice[i][1] == 0) && 
		   MatchTone(thepage->pwLookupChoice[i][0], tones[0])) {
		    to->pwLookupChoice[k][0] = thepage->pwLookupChoice[i][0];
		    to->pwLookupChoice[k][1] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == 0) to->nCandiStart = thepage->nCandiStart + i;
		    k ++;
		    if(k == 7) break;
	        }
		else if(thepage->pwLookupChoice[i][1] != 0) { /* Xi'An form */
		    to->pwLookupChoice[k][0] = thepage->pwLookupChoice[i][0];
		    to->pwLookupChoice[k][1] = thepage->pwLookupChoice[i][1];
		    to->pwLookupChoice[k][2] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == 0) to->nCandiStart = thepage->nCandiStart + i;
		    k ++;
		    if(k == 7) break;
		}
	    }
	    if(k == 7) break;
	    else if(thepage->nCandiStart + thepage->nChoiceNum == (phrasenum + singlenum)) break;

	    if((k <= 7) && ((thepage->nCandiStart + thepage->nChoiceNum) < (phrasenum + singlenum))) {
		thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
	    }
	}
	to->nCandiEnd = thepage->nCandiStart + i;
	if(k == 0) to->nCandiStart = to->nCandiEnd;
    }
    if((k != 0) || (startbak == 0)) to->nChoiceNum = k;
/*
printf("\nto->nChoiceNum = %d to->nCandiStart = %d to->nCandiEnd = %d\n", to->nChoiceNum, to->nCandiStart, to->nCandiEnd);
*/
}

VOID FilterCandiBackward(JINT nSesID, ImToXSun *to, int endbak) {
    int i, j, k = 0, startbak;
    int phrasenum, singlenum, itemnum, hznum;
    ImToXSun* thepage;
    UCHAR temp[5];
/*
printf("\nto->nCandiStart = %d to->nCandiEnd = %d\n", to->nCandiStart, to->nCandiEnd);
*/
    startbak = to->nCandiStart;
    phrasenum = to->nTotalPhraseNum;
    singlenum = to->nTotalSingleHzNum;

    if(to->nCandiEnd >= phrasenum) {
	k = 6;
	thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
	while(thepage->nCandiStart > to->nCandiEnd) {
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketleft, IMXK_bracketleft, 0);
	}
	while(k >= 0) {
/*
printf("xxx start = %d\n", thepage->nCandiStart);
*/
	    for(i = thepage->nChoiceNum - 1; i >= 0; i --) {
		if(thepage->nCandiStart + i > to->nCandiEnd) continue;
		temp[0] = (thepage->pwLookupChoice[i][0] >> 8) & 0xff;
		temp[1] = thepage->pwLookupChoice[i][0] & 0xff;
		temp[2] = 0;
/*
		printf("%s ", temp);
	        if((tones[0] == 0) || (GetTone(thepage->pwLookupChoice[i][0]) == tones[0])) {
*/
		if( (thepage->pwLookupChoice[i][1] == 0) &&
		    (MatchTone(thepage->pwLookupChoice[i][0], tones[0]))) {
		    to->pwLookupChoice[k][0] = thepage->pwLookupChoice[i][0];
		    to->pwLookupChoice[k][1] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == 6) { 
			to->nCandiEnd = thepage->nCandiStart + i;
/*
printf("last candidate %d\n", to->nCandiEnd);
*/
		    }
		    k --;
		    if(k < 0) break;
	        }
		else if(thepage->pwLookupChoice[i][1] != 0) { /* Xi'An form */
		    to->pwLookupChoice[k][0] = thepage->pwLookupChoice[i][0];
		    to->pwLookupChoice[k][1] = thepage->pwLookupChoice[i][1];
		    to->pwLookupChoice[k][2] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == 6)  to->nCandiEnd = thepage->nCandiStart + i;
		    k --;
		    if(k < 0) break;
		}
	    }
	    if(k < 0) break;
	    else if(thepage->nCandiStart <= phrasenum) break;
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketleft, IMXK_bracketleft, 0);
	    if(startbak == thepage->nCandiStart) return;
	}
	if(k != 6) { /* find candidates */
	    if(thepage->nCandiStart > phrasenum) to->nCandiStart = thepage->nCandiStart + i;
	    else to->nCandiStart = phrasenum;
	    to->nChoiceNum = 6 - k;
/*
printf("\nto->nChoiceNum = %d to->nCandiStart = %d to->nCandiEnd = %d\n", to->nChoiceNum, to->nCandiStart, to->nCandiEnd);
*/
	    return;
	}
	else {
	    to->nCandiEnd = endbak;
	    return;
	}
    }

	if((to->nCandiEnd == to->nTotalPhraseNum - 1) && 
	   (to->nLastPhrasePageNum > 0) && 
	   (to->nLastPhrasePageNum < 5)) itemnum = k = to->nLastPhrasePageNum - 1;
	else itemnum = k = 4;
/*
printf("LastPhrasePageNum = %d itemnum = %d\n", to->nLastPhrasePageNum, itemnum);

printf("thepage start = %d\n", thepage->nCandiStart);
*/
	thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
	while(thepage->nCandiStart > to->nCandiEnd) 
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketleft, IMXK_bracketleft, 0);
        while(k >= 0) {
/*
printf("in while thepage start = %d\n", thepage->nCandiStart);
*/
	    for(i = thepage->nChoiceNum - 1; i >= 0; i --) {
		if(thepage->nCandiStart + i > to->nCandiEnd) continue;
	        j = 0;
	        while((thepage->pwLookupChoice[i][j] != 0) && (j < TonesNum)) {
/*
	            if((tones[j] != 0) && (GetTone(thepage->pwLookupChoice[i][j]) != tones[j]))
*/
		    if(!MatchTone(thepage->pwLookupChoice[i][j], tones[j]))
		        break;
	            j ++;
	        }
	        if(thepage->pwLookupChoice[i][j] == 0) {
		    for(j = 0; thepage->pwLookupChoice[i][j] != 0; j ++) {
		        to->pwLookupChoice[k][j] = thepage->pwLookupChoice[i][j];
		    }
		    to->pwLookupChoice[k][j] = 0;
		    to->nCandiIndex[k] = i + thepage->nCandiStart;
		    if(k == itemnum) {
			to->nCandiEnd = thepage->nCandiStart + i;
/*
printf("the last candidate = %d\n", to->nCandiEnd);
*/
		    }
	            k --;
		    if(k < 0)  break;
	        }
	    } 
	    if(k < 0) break;
	    thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketleft, IMXK_bracketleft, 0);
        }
        if(thepage->nCandiStart > 0) to->nCandiStart = thepage->nCandiStart + i;
	else to->nCandiStart = 0;
	to->nChoiceNum = itemnum - k;
/*
printf("\nto->nChoiceNum = %d to->nCandiStart = %d to->nCandiEnd = %d\n", to->nChoiceNum, to->nCandiStart, to->nCandiEnd);
*/
}

ImToXSun* CommitCandidate(int nSesID, ImToXSun * to, int index) {
    int number;
    ImToXSun *thepage;

/*
printf("CommitCandidate index = %d\n", index);
*/
    thepage = BackToFirstPage(nSesID, to->nTotalPhraseNum);
    while(thepage->nCandiStart + thepage->nChoiceNum <= index) 
	thepage = (ImToXSun*) IM_trans(nSesID, IMXK_bracketright, IMXK_bracketright, 0);
    number = index - thepage->nCandiStart + 65;
/*
printf("CommitCandidate number = %d\n", number);
*/
    return (ImToXSun*) IM_trans(nSesID, number, number, 1);
}
