/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#include "le.h"
#include "encode.h"
#include "xaux_locale.h"

void proc_paletteaux_connect_event();
void proc_paletteaux_switch_mode_event();
void proc_paletteaux_change_position_event();
void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID);
void proc_paletteaux_hide_keyboardaux_event(iml_session_t *s);
void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str);
void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y);
void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status);
void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str);
void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus);
void proc_commonaux_lost_focus_event(iml_session_t *s);

void le_change_focus_notify(iml_session_t *s);
void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID);
void le_start_action_notify(iml_session_t *s, char *command_str);

/* ============================================================== */
/*            Process information from Auxiliary Window           */
/* ============================================================== */
void proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent)
{
	IMAuxDrawCallbackStruct *aux_data = auxevent->aux;
	int nIntegerCount, *pIntegerList;
	int nStringCount, nStringLen;
        int reqType;
	int locale_id, on, mode_id, qjbj, punct, x, y;
	int nKeyboardID, keycode, keychar, keystatus;
	char *command_str, *commit_str;

	nIntegerCount = aux_data->count_integer_values;
	pIntegerList = aux_data->integer_values;

	if (nIntegerCount <= 0) return;

	reqType = pIntegerList[0];

	DEBUG_printf("proc_aux_event: session:%x\n",aux_data, s);
	DEBUG_printf("reqType: %d\n", reqType);
	switch (reqType)
	{
		/* need not check whether the Palette is started */
		case PALETTEAUX_CONNECT:
			locale_id = pIntegerList[1];
			proc_paletteaux_connect_event(s, locale_id);
			break;

		case PALETTEAUX_SWITCH_IME:
			mode_id = pIntegerList[1];
			proc_paletteaux_switch_mode_event(s, mode_id);
			break;

		case PALETTEAUX_CHANGE_POSITION:
			x = pIntegerList[1];
			y = pIntegerList[2];
			proc_paletteaux_change_position_event(s, x, y);
			break;

		case PALETTEAUX_SHOW_KEYBOARDAUX:
			nKeyboardID = 0;
			proc_paletteaux_show_keyboardaux_event(s, nKeyboardID);
			break;

		case PALETTEAUX_START_ACTION:
			nStringCount = aux_data->count_string_values;
			if (nStringCount != 1) break;

			command_str = (char *)aux_data->string_values->text.utf_chars;
			proc_paletteaux_start_action_event(s, command_str);

			break;

		case KEYBOARDAUX_CHANGE_POSITION:
			x = pIntegerList[1];
			y = pIntegerList[2];
			proc_keyboardaux_change_position_event(s, x, y);
			break;

		case KEYBOARDAUX_CHANGE_KEY_STATUS:
			keystatus = pIntegerList[1];
			proc_keyboardaux_change_key_status_event(s, keystatus);
			break;

		case COMMONAUX_COMMIT_STRING:
			nStringCount = aux_data->count_string_values;
			if (nStringCount != 1) break;

			locale_id = pIntegerList[1];
			commit_str = (char *)aux_data->string_values->text.utf_chars;
			proc_commonaux_commit_string_event(s, locale_id, commit_str);

			break;

		case COMMONAUX_COMMIT_KEY:
			keycode = pIntegerList[1];
			keychar = pIntegerList[2];
			keystatus = pIntegerList[3];
			proc_commonaux_commit_key_event(s, keycode, keychar, keystatus);
			break;

		case COMMONAUX_LOST_FOCUS:
			proc_commonaux_lost_focus_event(s);
			break;

	}
}

void proc_paletteaux_connect_event(iml_session_t *s, int locale_id)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	
	DEBUG_printf("PALETTEAUX_CONNECT Request Received\n");
	desktop_data->paletteaux_ready = True;
}

void proc_paletteaux_switch_mode_event(iml_session_t *s, int cur_mode_id)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("PALETTEAUX_SWITCH_IME:  mode_id:%d\n", cur_mode_id);
	session_data->paletteaux_status.mode_id = cur_mode_id;
	le_status_draw(s);
}

void proc_paletteaux_change_position_event(iml_session_t *s, int x, int y)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("PALETTEAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
	session_data->paletteaux_status.x = x;
	session_data->paletteaux_status.y = y;
}

void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int keyboard_id = session_data->keyboardaux_status.keyboard_id;
	char *classname = XAUX_KEYBOARD_CLASS_NAME;

	if (desktop_data->keyboardaux_started == False) {
		if (desktop_data->root_session) {
			DEBUG_printf("First start KeyboardAux\n");
			iml_aux_start(desktop_data->root_session, classname);
			desktop_data->keyboardaux_started = True;
		}
	}

	if (keyboard_id == 0) {
		keyboard_id = -1;
	} else {
		keyboard_id = 0;
	}

	session_data->keyboardaux_status.keyboard_id = keyboard_id;
	le_show_keyboardaux_notify(s, keyboard_id);
}

void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	char *classname = XAUX_ACTION_CLASS_NAME;
	
	if (desktop_data->actionaux_started == False) {
		if (desktop_data->root_session) {
			DEBUG_printf("First start ActionAux\n");
			iml_aux_start(desktop_data->root_session, classname);
			desktop_data->actionaux_started = True;
		}
	}

	DEBUG_printf("PALETTEAUX_START_ACTION Request Received: \n");
	DEBUG_printf("command_str:%s, len:%d\n", command_str, strlen(command_str));

	le_start_action_notify(s, command_str);
}

void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("KEYBOARDAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
	session_data->keyboardaux_status.x = x;
	session_data->keyboardaux_status.y = y;
}

void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("KEYBOARDAUX_CHANGE_KEY_STATUS:  key_status: 0x%x\n", key_status);
	session_data->keyboardaux_status.key_status = key_status;
}

void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str)
{
	DEBUG_printf("COMMONAUX_COMMIT_STRING Request Received: \n");
	DEBUG_printf("locale_id:%d, command_str:%s, len:%d\n", 
		locale_id, commit_str, strlen(commit_str));

	encode_commit(s, locale_id, (unsigned char *)commit_str);
}

void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus)
{
	static IMKeyEventStruct akey;
	static IMKeyListEvent keyev;

	DEBUG_printf("COMMONAUX_COMMIT_KEY Request Received: \n");
	DEBUG_printf("keycode:0x%x, keychar:0x%x, keystatus:0x%x\n", 
		keycode, keychar, keystatus);

	akey.keyCode = keycode;
	akey.keyChar = keychar;
	akey.modifier = keystatus;
	keyev.type = IM_EventKeyList;
	keyev.keylist = (IMKeyList) &akey;
	proc_key_event(s, (IMKeyListEvent *) &keyev);
}

void proc_commonaux_lost_focus_event(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int on_save = session_data->paletteaux_status.on;

	DEBUG_printf("COMMONAUX_LOST_FOCUS Request Received\n");
	session_data->paletteaux_status.on = False;
	le_change_focus_notify(s);
	session_data->paletteaux_status.on = on_save;
}

/* ============================================================== */
/*              Send information to Auxiliary Window              */
/* ============================================================== */
void le_start_aux_notify(iml_session_t *s, char *classname)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
	iml_aux_start(desktop_data->root_session, classname);
}

void send_info_to_aux(iml_session_t *s, char *classname,
		 int count_integers,  int *integers,
		 int count_strings,   int *len_strings,
		 char **strings)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

	if (desktop_data->root_session == 0) return;

	iml_aux_draw(	desktop_data->root_session, classname, 
			count_integers,  integers,
			count_strings,   len_strings,
			strings);
}

void le_switch_mode_notify(iml_session_t *s, int mode_id)
{
	char *classname = XAUX_PALETTE_CLASS_NAME;
	int nIntegerCount,  pIntegerList[2];

	DEBUG_printf("le_switch_ime_notify: ======\n");

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_IME_NOTIFY;
	pIntegerList[1] = mode_id;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_paletteaux_focus_notify(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_PALETTE_CLASS_NAME;
	int nIntegerCount,  pIntegerList[5];

	DEBUG_printf("le_change_paletteaux_focus_notify: ======\n");

	nIntegerCount = 5;
	pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
	pIntegerList[1] = session_data->paletteaux_status.x;
	pIntegerList[2] = session_data->paletteaux_status.y;
	pIntegerList[3] = session_data->paletteaux_status.on;
	pIntegerList[4] = session_data->paletteaux_status.mode_id;

	DEBUG_printf(" x:%d, y:%d, on:%d, mode_id:%d\n",
		pIntegerList[1],
		pIntegerList[2],
		pIntegerList[3],
		pIntegerList[4]);
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_keyboardaux_focus_notify(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int nIntegerCount,  pIntegerList[7];

	DEBUG_printf("le_change_keyboardaux_focus_notify: ======\n");

	nIntegerCount = 6;
	pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
	pIntegerList[1] = session_data->keyboardaux_status.x;
	pIntegerList[2] = session_data->keyboardaux_status.y;
	pIntegerList[3] = session_data->keyboardaux_status.keyboard_id;
	pIntegerList[4] = session_data->keyboardaux_status.key_status;
	pIntegerList[5] = session_data->paletteaux_status.on;
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_focus_notify(iml_session_t *s)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

	if (desktop_data->paletteaux_started == True) 
		le_change_paletteaux_focus_notify(s);

	if (desktop_data->keyboardaux_started == True)
		le_change_keyboardaux_focus_notify(s);
}

void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID)
{
	char *classname = XAUX_KEYBOARD_CLASS_NAME;
	int nIntegerCount,  pIntegerList[2];

	DEBUG_printf("le_show_keyboardaux_notify: ======\n");

	nIntegerCount = 2;
	pIntegerList[0] = KEYBOARDAUX_SHOW_NOTIFY;
	pIntegerList[1] = nKeyboardID;

	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_start_action_notify(iml_session_t *s, char *command_str)
{
	char *classname = XAUX_ACTION_CLASS_NAME;
	int nIntegerCount,  pIntegerList[1];
	int nStringsCount,  pLenStrings[1];
	char *pStrings[1];

	nIntegerCount = 1;
	pIntegerList[0] = ACTIONAUX_START_ACTION_NOTIFY;

	nStringsCount = 1;
	pLenStrings[0] = strlen(command_str) + 1;
	pStrings[0] = (char *)command_str;

	DEBUG_printf("le_start_action_notify: %s, len:%d\n", command_str, pLenStrings[0]);
	send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 
			nStringsCount,  pLenStrings,
			pStrings);
}

