/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _THAI_PROTOCOL_H_
#define _THAI_PROTOCOL_H_

/***************************************************************************/
/*         Protocol used by Auxiliary window and Language Engine           */
/***************************************************************************/
/* Conversion Status */
#define CONVERSION_OFF 			0
#define CONVERSION_ON 			1

/* Types of Input Method Switching */
#define IME_ROUND_SWITCH  		0
#define IME_SELECT_SWITCH		1

/* Protocol Number between Auxiliary Window and Language Engine */
enum _protocol_id_list {

	/* For PaletteAux */
	PALETTEAUX_CONNECT = 0,
	PALETTEAUX_SWITCH_CONVERSION,
	PALETTEAUX_SWITCH_ISC_MODE,
	PALETTEAUX_CHANGE_POSITION,
	PALETTEAUX_SHOW_OPTIONAUX,
	PALETTEAUX_SHOW_KEYBOARDAUX,
	PALETTEAUX_SHOW_LOOKUPAUX,
	PALETTEAUX_START_ACTION,

	PALETTEAUX_UPDATE_IMEINFO_NOTIFY,
	PALETTEAUX_SWITCH_CONVERSION_NOTIFY,
	PALETTEAUX_SWITCH_ISC_MODE_NOTIFY,

	/* For Common used protocol */
	COMMONAUX_COMMIT_KEY = 20,
	COMMONAUX_COMMIT_STRING,
	COMMONAUX_LOST_FOCUS,
	COMMONAUX_SET_DEFAULT_VALUE,
	COMMONAUX_GET_DEFAULT_VALUE,

	COMMONAUX_CHANGE_FOCUS_NOTIFY,
	COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY,
	COMMONAUX_SET_IME_NEW_NOTIFY,
	COMMONAUX_SET_IME_INFO_NOTIFY,
	COMMONAUX_SET_IME_END_NOTIFY,

	COMMONAUX_MODE_NAME_NOTIFY,
	COMMONAUX_KEYBOARD_NAME_NOTIFY,
	COMMONAUX_KEYBOARD_LAYOUT_NOTIFY,

	/* For OptionAux */
	OPTIONAUX_CONNECT = 40,
	OPTIONAUX_CHANGE_STATUS,

	OPTIONAUX_SHOW_NOTIFY,
	OPTIONAUX_HIDE_NOTIFY,

	/* For KeyboardAux */
	KEYBOARDAUX_CONNECT = 60,
	KEYBOARDAUX_CHANGE_POSITION,
	KEYBOARDAUX_CHANGE_KEY_STATUS,

	KEYBOARDAUX_SHOW_NOTIFY,
	KEYBOARDAUX_HIDE_NOTIFY,
	KEYBOARDAUX_PRESS_KEY_NOTIFY,

	/* For ActionAux */
	ACTIONAUX_CONNECT = 80,
	ACTIONAUX_START_ACTION_NOTIFY,

};

#endif   /* _THAI_PROTOCOL_H_  */

