/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */
#include <stdio.h>

#include "encode.h"
#include "hzinput.h"

int  nmim_SetOptions(IMECore, char *);
int  nmim_SetValues(IMECore, IMEArgList, int);
int  nmim_Init(IMECore);
int  nmim_Open(IMECore, IMEBuffer);
int  nmim_Filter(IMECore, IMEKey, IMEArgList, IMEBuffer);
void nmim_Close(IMECore);

#ifdef	WIN32
#define EXPORT extern __declspec(dllexport)
EXPORT
#endif

/* IF Method */
IMEMethodsRec ime_methods = {
      nmim_SetOptions,
      nmim_SetValues,
      nmim_Init,
      nmim_Open,
      nmim_Filter,
      nmim_Close,
      NULL,
      NULL,
      NULL
};

#define  GB2312_NEIMA_NAME 	"GB"
#define  GBK_NEIMA_NAME		"GBK"
#define  GB18030_NEIMA_NAME	"GB18030"
#define  BIG5_NEIMA_NAME	"BIG5X"
#define  EUC_NEIMA_NAME 	"EUC"
#define  BIG5HK_NEIMA_NAME	"BIG5HKX"
#define  UNICODE_NEIMA_NAME	"UNICODE"

typedef struct _NeiMa_Encode_Name {
	int 	encode;
	char 	*name;
} NeiMa_Encode_Name;

NeiMa_Encode_Name nm_encode_name[] = {
	{ ENCODE_GB2312, 	GB2312_NEIMA_NAME },
	{ ENCODE_GBK,   	GBK_NEIMA_NAME    },
	{ ENCODE_GB18030,   	GB18030_NEIMA_NAME},
	{ ENCODE_BIG5, 		BIG5_NEIMA_NAME   },
	{ ENCODE_EUC_TW,  	EUC_NEIMA_NAME    },
	{ ENCODE_BIG5HK,  	BIG5HK_NEIMA_NAME },
	{ ENCODE_UTF8, 		UNICODE_NEIMA_NAME},
	{ 0,			NULL              }
};
 
char *get_neima_name_by_encode(int encode)
{
	NeiMa_Encode_Name *str_val = nm_encode_name;
        while (str_val->name) {
                if (str_val->encode == encode)
                        return ((char *)str_val->name);
                str_val++;
        }

	/* Default Name */
        return (GB2312_NEIMA_NAME);
}

int nmim_SetOptions(IMECore core, char *options)
{
	
}

int nmim_SetValues(IMECore core, IMEArgList arglist, int option_value)
{
	DEBUG_printf("nmim_SetValues, option_value:%d\n", option_value);

	if (arglist == NULL) return(-1);

	arglist->args_num = 0;
	return(0);
}

/* return the Chinese name and encode status and status of codetable IME */
int nmim_Init(IMECore core)
{
	char *neima_name;
	int  neima_encode = core->baseinfo.locale_id;

	DEBUG_printf("nmim_Init ====\n");

	/* Return Information that needed by Input Method Manager */
	/* Such as Encode, Cname, Status */

	core->baseinfo.status = ENGINE_INITIATED;
	
	core->baseinfo.encode_id = neima_encode;
	neima_name = (char *)get_neima_name_by_encode(neima_encode);
	core->baseinfo.cname = (char *)strdup(neima_name);

	return(0);
}

/* Load the codetable file int memory */
int nmim_Open(IMECore core, IMEBuffer ime_buffer)
{
	DEBUG_printf("nmim_Open ==== \n");

	ime_buffer->encode = 0;
	ime_buffer->return_status = 0;
	ime_buffer->preedit_len = 0;
	ime_buffer->commit_len  = 0;
	ime_buffer->lookup_num  = 0;
	ime_buffer->inputkey_len  = 0;
	ime_buffer->cur_lookup_pos = 0;

	return(0);
}

/* close IME, and free codetable pointers */
void nmim_Close(IMECore core)
{
	DEBUG_printf("nmim_Close ==== \n");
	if (core->baseinfo.cname)
		free((char *)core->baseinfo.cname);
}

/* process key input event */
/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int  nmim_Filter(core, key_event, ime_args, ime_buffer)
IMECore core;
IMEKey  key_event;
IMEArgList ime_args;
IMEBuffer ime_buffer;
{
	int 	ret;
	int 	encode_id = core->baseinfo.encode_id;

	DEBUG_printf("nmim_Filter ==== \n");
	ime_buffer->encode = encode_id;
	ret = neima_filter(encode_id, key_event, ime_buffer);
	return(ret);
}

