/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#include "le.h"
#include "encode.h"
#include "xaux_locale.h"

void proc_paletteaux_connect_event();
void proc_paletteaux_switch_conversion_event();
void proc_paletteaux_switch_engine_event();
void proc_paletteaux_switch_qjbj_event();
void proc_paletteaux_switch_punct_event();
void proc_paletteaux_change_position_event();
void proc_paletteaux_show_selectaux_event(iml_session_t *s);
void proc_selectaux_update_imeinfo_event(iml_session_t *s);
void proc_paletteaux_show_optionaux_event(iml_session_t *s);
void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID);
void proc_paletteaux_hide_keyboardaux_event(iml_session_t *s);
void proc_paletteaux_show_lookupaux_event(iml_session_t *s);
void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str);
void proc_paletteaux_set_options_event(iml_session_t *s, IMAuxDrawCallbackStruct *aux_data);
void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y);
void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status);
void proc_lookupaux_change_position_event(iml_session_t *s, int x, int y);
void proc_lookupaux_change_status_event(iml_session_t *s, int on);
void proc_selectaux_change_status_event(iml_session_t *s, int on);
void proc_optionaux_change_status_event(iml_session_t *s, int on);
void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str);
void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus);
void proc_commonaux_lost_focus_event(iml_session_t *s);

void le_show_selectaux_notify(iml_session_t *s);
void le_show_optionaux_notify(iml_session_t *s);
void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID, int engine_id);
void le_show_lookupaux_notify(iml_session_t *s);
void le_start_action_notify(iml_session_t *s, char *command_str);
void le_imeinfo_notify(iml_session_t *s, char *classname, int aux_locale_id);
void le_update_paletteaux_imeinfo(iml_session_t *s);
void le_update_optionaux_argsinfo(iml_session_t *s);
void le_update_keymapinfo_notify(iml_session_t *s, int engine_id);
void le_change_compositeaux_focus_notify(iml_session_t *s);
void le_change_focus_notify(iml_session_t *s);
void le_hide_compositeaux_notify(iml_session_t *s);

extern int         	gEngine_Num;
extern IMEEngineRec 	*gEngine_Info[MAX_ENGINE_NUM];

/* ============================================================== */
/*            Process information from Auxiliary Window           */
/* ============================================================== */
void proc_aux_event(iml_session_t *s, IMAuxEvent *auxevent)
{
        IMAuxDrawCallbackStruct *aux_data = auxevent->aux;
        int nIntegerCount, *pIntegerList;
        int nStringCount, nStringLen;
        int reqType;
        int locale_id, on, engine_id, qjbj, punct, x, y;
        int nKeyboardID, keycode, keychar, keystatus;
        char *command_str, *commit_str;

        nIntegerCount = aux_data->count_integer_values;
        pIntegerList = aux_data->integer_values;

        if (nIntegerCount <= 0) return;

        reqType = pIntegerList[0];

        DEBUG_printf("proc_aux_event: session:%x\n",aux_data, s);
        DEBUG_printf("reqType: %d\n", reqType);
        switch (reqType)
        {
                /* need not check whether the Palette is started */
                case PALETTEAUX_CONNECT:
                        locale_id = pIntegerList[1];
                        proc_paletteaux_connect_event(s, locale_id);
                        break;

                case PALETTEAUX_SWITCH_CONVERSION:
                        on = pIntegerList[1];
                        proc_paletteaux_switch_conversion_event(s, on);
                        break;

                case PALETTEAUX_SWITCH_IME:
                        engine_id = pIntegerList[1];
                        proc_paletteaux_switch_engine_event(s, engine_id);
                        break;

                case PALETTEAUX_SWITCH_QJBJ:
                        qjbj = pIntegerList[1];
                        proc_paletteaux_switch_qjbj_event(s, qjbj);
                        break;

                case PALETTEAUX_SWITCH_PUNCT:
                        punct = pIntegerList[1];
                        proc_paletteaux_switch_punct_event(s, punct);
                        break;

                case PALETTEAUX_CHANGE_POSITION:
                        x = pIntegerList[1];
                        y = pIntegerList[2];
                        proc_paletteaux_change_position_event(s, x, y);
                        break;

                case PALETTEAUX_SHOW_SELECTAUX:
                        proc_paletteaux_show_selectaux_event(s);
                        break;

                case PALETTEAUX_SHOW_OPTIONAUX:
                        proc_paletteaux_show_optionaux_event(s);
                        break;

                case PALETTEAUX_SHOW_KEYBOARDAUX:
                        nKeyboardID = pIntegerList[1];
                        proc_paletteaux_show_keyboardaux_event(s, nKeyboardID);
                        break;

                case PALETTEAUX_SHOW_LOOKUPAUX:
                        proc_paletteaux_show_lookupaux_event(s);
                        break;

                case PALETTEAUX_START_ACTION:
                        nStringCount = aux_data->count_string_values;
                        if (nStringCount != 1) break;

                        command_str = (char *)aux_data->string_values->text.utf_chars;
                        proc_paletteaux_start_action_event(s, command_str);

                        break;

                case KEYBOARDAUX_CHANGE_POSITION:
                        x = pIntegerList[1];
                        y = pIntegerList[2];
                        proc_keyboardaux_change_position_event(s, x, y);
                        break;

                case KEYBOARDAUX_CHANGE_KEY_STATUS:
                        keystatus = pIntegerList[1];
                        proc_keyboardaux_change_key_status_event(s, keystatus);
                        break;

                case LOOKUPAUX_CHANGE_POSITION:
                        x = pIntegerList[1];
                        y = pIntegerList[2];
                        proc_keyboardaux_change_position_event(s, x, y);
                        break;

                case LOOKUPAUX_CHANGE_STATUS:
                        on = pIntegerList[1];
                        proc_lookupaux_change_status_event(s, on);
                        break;

                case SELECTAUX_CHANGE_STATUS:
                        on = pIntegerList[1];
                        proc_selectaux_change_status_event(s, on);
                        break;

                case SELECTAUX_UPDATE_IMEINFO:
                        proc_selectaux_update_imeinfo_event(s);
                        break;

                case OPTIONAUX_CHANGE_STATUS:
                        on = pIntegerList[1];
                        proc_optionaux_change_status_event(s, on);
                        break;

                case COMMONAUX_COMMIT_STRING:
                        nStringCount = aux_data->count_string_values;
                        if (nStringCount != 1) break;

                        locale_id = pIntegerList[1];
                        commit_str = (char *)aux_data->string_values->text.utf_chars;
                        proc_commonaux_commit_string_event(s, locale_id, commit_str);

                        break;

                case COMMONAUX_COMMIT_KEY:
                        keycode = pIntegerList[1];
                        keychar = pIntegerList[2];
                        keystatus = pIntegerList[3];
                        proc_commonaux_commit_key_event(s, keycode, keychar, keystatus);

                        break;

                case COMMONAUX_UPDATE_OPTIONSINFO:
                        proc_paletteaux_set_options_event(s, aux_data);
                        break;

                case COMMONAUX_LOST_FOCUS:
                        proc_commonaux_lost_focus_event(s);
                        break;

        }
}

void proc_paletteaux_connect_event(iml_session_t *s, int aux_locale_id)
{
	int i;

        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

        DEBUG_printf("PALETTEAUX_CONNECT Request Received\n");
        desktop_data->paletteaux_ready = True;
        desktop_data->aux_locale_id = aux_locale_id;

	desktop_data->num_engine = 0;
        for (i=0; i<gEngine_Num; i++) {
		int engine_locale_id;
                if (aux_locale_id != -1) {
                        engine_locale_id = gEngine_Info[i]->core.baseinfo.locale_id;
                        if (engine_locale_id != aux_locale_id && engine_locale_id != ENCODES_NUM)
                                continue;
                }
		desktop_data->engine_info[desktop_data->num_engine] = gEngine_Info[i];
		desktop_data->num_engine ++;
        }

}

void proc_paletteaux_switch_conversion_event(iml_session_t *s, int on)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        int engine_id = session_data->paletteaux_status.engine_id;

        DEBUG_printf("PALETTEAUX_SWITCH_CONVERSION:  on:%d\n", on);
        if (on)
                iml_conversion_on(s);
        else
                iml_conversion_off(s);

        session_data->paletteaux_status.on = on;
        le_clear_ime_buffer(s, session_data->ime_buffer);

        if (on == CONVERSION_OFF) {
                session_data->paletteaux_status.engine_id = 0;
                le_status_draw(s);
        }
}

void proc_paletteaux_switch_engine_event(iml_session_t *s, int cur_engine_id)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("PALETTEAUX_SWITCH_IME:  engine_id:%d\n", cur_engine_id);
        le_clear_ime_buffer(s, session_data->ime_buffer);
        le_switch_engine(s, cur_engine_id);
        le_change_focus_notify(s);
}

void proc_paletteaux_switch_qjbj_event(iml_session_t *s, int qjbj)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("PALETTEAUX_SWITCH_QJBJ:  qjbj:%d\n", qjbj);
        session_data->paletteaux_status.qjbj = qjbj;
        le_clear_ime_buffer(s, session_data->ime_buffer);
}

void proc_paletteaux_switch_punct_event(iml_session_t *s, int punct)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("PALETTEAUX_SWITCH_PUNCT:  punct: %d\n", punct);
        session_data->paletteaux_status.punct = punct;
        le_clear_ime_buffer(s, session_data->ime_buffer);
}

void proc_paletteaux_change_position_event(iml_session_t *s, int x, int y)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("PALETTEAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
        session_data->paletteaux_status.x = x;
        session_data->paletteaux_status.y = y;
}

void proc_paletteaux_show_selectaux_event(iml_session_t *s)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        int aux_locale_id = desktop_data->aux_locale_id;
        char *classname = XAUX_SELECT_CLASS_NAME;

        if (desktop_data->selectaux_started == False) {
                DEBUG_printf("First start SelectAux\n");
                iml_aux_start(s, classname);
                le_imeinfo_notify(s, classname, aux_locale_id);
                desktop_data->selectaux_started = True;
        }

        session_data->selectaux_status.on = True;
        le_show_selectaux_notify(s);
}

void proc_paletteaux_show_optionaux_event(iml_session_t *s)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_OPTION_CLASS_NAME;

        if (desktop_data->optionaux_started == False) {
                DEBUG_printf("First start OptionAux\n");
                iml_aux_start(s, classname);
                le_update_optionaux_argsinfo(s);
                desktop_data->optionaux_started = True;
        }

        session_data->optionaux_status.on = True;
        le_show_optionaux_notify(s);
}

void proc_paletteaux_show_lookupaux_event(iml_session_t *s)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_LOOKUP_CLASS_NAME;

        if (desktop_data->lookupaux_started == False) {
                DEBUG_printf("First start LookupAux\n");
                iml_aux_start(s, classname);
                desktop_data->lookupaux_started = True;
        }

        session_data->lookupaux_status.on = True;
        le_show_lookupaux_notify(s);
}

void proc_paletteaux_show_keyboardaux_event(iml_session_t *s, int nKeyboardID)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        int engine_id = session_data->paletteaux_status.engine_id;
        char *classname = XAUX_KEYBOARD_CLASS_NAME;

        if (desktop_data->keyboardaux_started == False) {
                DEBUG_printf("First start KeyboardAux\n");
                iml_aux_start(s, classname);
                desktop_data->keyboardaux_started = True;
        }

        session_data->keyboardaux_status.keyboard_id = nKeyboardID;
        le_update_keymapinfo_notify(s, engine_id);
        le_show_keyboardaux_notify(s, nKeyboardID, engine_id);
}

void proc_paletteaux_start_action_event(iml_session_t *s, char *command_str)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        char *classname = XAUX_ACTION_CLASS_NAME;

        if (desktop_data->actionaux_started == False) {
                DEBUG_printf("First start ActionAux\n");
                iml_aux_start(s, classname);
                desktop_data->actionaux_started = True;
        }

        DEBUG_printf("PALETTEAUX_START_ACTION Request Received: \n");
        DEBUG_printf("command_str:%s, len:%d\n", command_str, strlen(command_str));

        le_start_action_notify(s, command_str);
}

void proc_paletteaux_set_options_event(iml_session_t *s, IMAuxDrawCallbackStruct *aux_data)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        IMText *lt;
        char *ime_ename;
        int i, j, option_value;
        int nIntegerCount, *pIntegerList;
        int nStringCount, nStringLen;
        int engine_id, engine_locale_id, aux_locale_id;

        nIntegerCount = aux_data->count_integer_values;
        pIntegerList = aux_data->integer_values;
        nStringCount = aux_data->count_string_values;

        DEBUG_printf("PALETTEAUX_SET_OPTIONS Request Received: \n");
        DEBUG_printf("Options num:%d \n", nStringCount);

        aux_locale_id = desktop_data->aux_locale_id;
        for (i=0; i<nStringCount; i++) {
                lt = aux_data->string_values + i;
                ime_ename = (char *)(lt->text.utf_chars);
                option_value = pIntegerList[i+1];
                DEBUG_printf("set option: %s\t%d\n", ime_ename, option_value);

                engine_id = -1;
                for (j=0; j<desktop_data->num_engine; j++) {
                        if (strcmp(ime_ename, desktop_data->engine_info[j]->core.baseinfo.ename))
                                continue;
                        engine_id = j;
                        break;
                }

                if (engine_id == -1) continue;

                DEBUG_printf("set options: ime_name:%s, engine_id:%d\n", ime_ename, engine_id);
                if (desktop_data->ime_args[engine_id] == NULL)
                        desktop_data->ime_args[engine_id] =
                                (IMEArgList)calloc(1, sizeof(IMEArgListRec));

                if (desktop_data->ime_args[engine_id] == NULL)
                        continue;

                /* set the options of ime */
                desktop_data->engine_info[engine_id]->core.envinfo.output_encode_id = aux_locale_id;
                desktop_data->engine_info[engine_id]->so_methods->IME_SetValues(
                        &(desktop_data->engine_info[engine_id]->core),
                        desktop_data->ime_args[engine_id],
                        option_value);
        }

}

void proc_keyboardaux_change_position_event(iml_session_t *s, int x, int y)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("KEYBOARDAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
        session_data->keyboardaux_status.x = x;
        session_data->keyboardaux_status.y = y;
}

void proc_keyboardaux_change_key_status_event(iml_session_t *s, int key_status)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("KEYBOARDAUX_CHANGE_KEY_STATUS:  key_status: 0x%x\n", key_status);
        session_data->keyboardaux_status.key_status = key_status;
}

void proc_lookupaux_change_position_event(iml_session_t *s, int x, int y)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("LOOKUPAUX_CHANGE_POSITION:  x: 0x%x, y:0x%x\n", x, y);
}

void proc_lookupaux_change_status_event(iml_session_t *s, int on)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("LOOKUPAUX_CHANGE_STATUS:  on: %d\n", on);
        session_data->lookupaux_status.on = on;
}

void proc_selectaux_change_status_event(iml_session_t *s, int on)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("SELECTAUX_CHANGE_STATUS:  on: %d\n", on);
        session_data->selectaux_status.on = on;
}

void proc_selectaux_update_imeinfo_event(iml_session_t *s)
{
        le_update_paletteaux_imeinfo(s);
}

void proc_optionaux_change_status_event(iml_session_t *s, int on)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

        DEBUG_printf("OPTIONAUX_CHANGE_STATUS:  on: %d\n", on);
        session_data->optionaux_status.on = on;
}

void proc_commonaux_commit_string_event(iml_session_t *s, int locale_id, char *commit_str)
{
        DEBUG_printf("COMMONAUX_COMMIT_STRING Request Received: \n");
        DEBUG_printf("locale_id:%d, command_str:%s, len:%d\n",
                locale_id, commit_str, strlen(commit_str));

        encode_commit(s, locale_id, (unsigned char *)commit_str);
}

void proc_commonaux_commit_key_event(iml_session_t *s, int keycode, int keychar, int keystatus)
{
        static IMKeyEventStruct akey;
        static IMKeyListEvent keyev;

        DEBUG_printf("COMMONAUX_COMMIT_KEY Request Received: \n");
        DEBUG_printf("keycode:0x%x, keychar:0x%x, keystatus:0x%x\n",
                keycode, keychar, keystatus);

        akey.keyCode = keycode;
        akey.keyChar = keychar;
        akey.modifier = keystatus;
        keyev.type = IM_EventKeyList;
        keyev.keylist = (IMKeyList) &akey;
        proc_key_event(s, (IMKeyListEvent *) &keyev);
}

void proc_commonaux_lost_focus_event(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        int on_save = session_data->paletteaux_status.on;

        DEBUG_printf("COMMONAUX_LOST_FOCUS Request Received\n");
        session_data->paletteaux_status.on = False;
        le_change_focus_notify(s);
        session_data->paletteaux_status.on = on_save;
}

/* ============================================================== */
/*              Send information to Auxiliary Window              */
/* ============================================================== */
void le_start_aux_notify(iml_session_t *s, char *classname)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        iml_aux_start(s, classname);
}

void send_info_to_aux(iml_session_t *s, char *classname,
                 int count_integers,  int *integers,
                 int count_strings,   int *len_strings,
                 char **strings)
{
        iml_aux_draw(	s, classname,
                        count_integers,  integers,
                        count_strings,   len_strings,
                        strings);
}

void le_imeinfo_notify(iml_session_t *s, char *classname, int aux_locale_id)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        int nIntegerCount,  pIntegerList[5];
        int nStringsCount,  pLenStrings[2];
        char *pStrings[2], *ename, *cname;
        int i, engine_locale_id;

        DEBUG_printf("le_imeinfo_notify: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = COMMONAUX_SET_IME_NEW_NOTIFY;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);

        for (i=0; i<desktop_data->num_engine; i++) {
                /* send the IME base information to auxiliary window */
                nIntegerCount = 5;
                pIntegerList[0] = COMMONAUX_SET_IME_INFO_NOTIFY;
                pIntegerList[1] = desktop_data->engine_info[i]->core.baseinfo.engine_id;
                pIntegerList[2] = desktop_data->engine_info[i]->core.baseinfo.locale_id;
                pIntegerList[3] = desktop_data->engine_info[i]->core.baseinfo.encode_id;
                pIntegerList[4] = desktop_data->engine_info[i]->core.baseinfo.status;

                nStringsCount = 2;
                ename = desktop_data->engine_info[i]->core.baseinfo.ename;
                if (ename == NULL) ename = "IME";
                pLenStrings[0] = strlen(ename) + 1;
                pStrings[0] = (char *)ename;

                cname = desktop_data->engine_info[i]->core.baseinfo.cname;
                if (cname == NULL) cname = "IME";
                pLenStrings[1] = strlen(cname) + 1;
                pStrings[1] = (char *)cname;

                DEBUG_printf("le_imeinfo_notify: \n");
                DEBUG_printf("\tengine_id: %d\n", pIntegerList[1]);
                DEBUG_printf("\tlocale_id: %d\n", pIntegerList[2]);
                DEBUG_printf("\tencode_id: %d\n", pIntegerList[3]);
                DEBUG_printf("\tstatus: %d\n", pIntegerList[4]);
                DEBUG_printf("\tename: %s\n", ename);
                DEBUG_printf("\tcname: %s\n", cname);

                send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                        nStringsCount,  pLenStrings,
                        pStrings);
        }

        nIntegerCount = 1;
        pIntegerList[0] = COMMONAUX_SET_IME_END_NOTIFY;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_update_paletteaux_imeinfo(iml_session_t *s)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];

        DEBUG_printf("le_update_paletteaux_imeinfo: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = PALETTEAUX_UPDATE_IMEINFO_NOTIFY;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_update_optionaux_argsinfo(iml_session_t *s)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        char *classname = XAUX_OPTION_CLASS_NAME;

        int nIntegerCount,  pIntegerList[2 * MAX_ARGS_NUM + 2];
        int nStringsCount,  pLenStrings[MAX_ARGS_NUM + 2];
        char *pStrings[MAX_ARGS_NUM + 2];
        int engine_locale_id, aux_locale_id;
        int i, j, total_args_num, args_num, arg_value, arg_type;
        char *ename, *cname, *arg_name;
        char *tmp_name, ime_cname[256], tmp_arg_name[256];
        int encode_id, ilen, olen, ret;

        DEBUG_printf("le_update_optionaux_argsinfo: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);

        aux_locale_id = desktop_data->aux_locale_id;
        for (i=0; i<desktop_data->num_engine; i++) {
                engine_locale_id = desktop_data->engine_info[i]->core.baseinfo.locale_id;

                ename = (char *)desktop_data->engine_info[i]->core.baseinfo.ename;
                if (!ename || !*ename)
                        continue;

                cname = (char *)desktop_data->engine_info[i]->core.baseinfo.cname;
                if (!cname || !*cname)
                        continue;

                if (desktop_data->ime_args[i] == NULL) {
                        desktop_data->ime_args[i] = (IMEArgList)calloc(1, sizeof(IMEArgListRec));
                        if (desktop_data->ime_args[i] == NULL)
                                continue;

                        /* set the options of ime */
                        desktop_data->engine_info[i]->core.envinfo.output_encode_id = aux_locale_id;
                        desktop_data->engine_info[i]->so_methods->IME_SetValues(&(desktop_data->engine_info[i]->core),  desktop_data->ime_args[i], -1);
                }

                total_args_num = desktop_data->ime_args[i]->args_num;
                if (total_args_num == 0)
                        continue;

                if (total_args_num >= MAX_ARGS_NUM)
                        total_args_num = MAX_ARGS_NUM - 1;

                strcpy(ime_cname, cname);

                encode_id = desktop_data->engine_info[i]->core.baseinfo.encode_id;
                DEBUG_printf("ime encode_id is: %d\n", encode_id);
                if (encode_id == ENCODE_UTF8) {
                        ilen = strlen(cname);
                        tmp_name = ime_cname;
                        olen = 256;
                        memset(ime_cname, 0, olen);
                        ret = Convert_UTF8_To_Native(aux_locale_id, cname, ilen, &tmp_name, &olen);
                        if (ret == -1)
                                strcpy(ime_cname, ename);
                }

                DEBUG_printf("Set options for IME :%s, args_num: %d\n", ime_cname, total_args_num);
                /* set the option information of this IME to OptionAux */
                pIntegerList[0] = OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY;
                pLenStrings[0] = strlen(ename) + 1;
                pStrings[0] = (char *)ename;
                pLenStrings[1] = strlen(ime_cname) + 1;
                pStrings[1] = (char *)ime_cname;

                args_num = 0;
                for (j=0; j<total_args_num; j++) {
                        arg_name = (char *)desktop_data->ime_args[i]->args[j].name;

                        if (!arg_name || !*arg_name)
                                continue;

                        ilen = strlen(arg_name);
                        tmp_name = tmp_arg_name;
                        olen = 256;
                        memset(tmp_arg_name, 0, olen);
                        ret = Convert_UTF8_To_Native(aux_locale_id, arg_name, ilen, &tmp_name, &olen);
                        if (ret == -1)
                                strcpy(tmp_arg_name, arg_name);

                        arg_value = desktop_data->ime_args[i]->args[j].value;
                        pIntegerList[2 * args_num + 2] = arg_value;
                        arg_type = desktop_data->ime_args[i]->args[j].type;
                        pIntegerList[2 * args_num + 3] = arg_type;
                        pLenStrings[args_num + 2] = strlen(tmp_arg_name) + 1;
                        pStrings[args_num + 2] = (char *)strdup(tmp_arg_name);

                        DEBUG_printf("j: %d, arg_num: %d, arg_name:%s\tvalue:%d\targ_type:%d\n", j, args_num, tmp_arg_name, arg_value, arg_type);
                        args_num++;
                }

                if (args_num == 0)
                        continue;

                nIntegerCount = 2 * args_num + 2;
                pIntegerList[1] = args_num;
                nStringsCount = args_num + 2;

                send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                        nStringsCount,  pLenStrings,
                        pStrings);

                for (j=0; j<args_num; j++) {
                        if (pStrings[j + 2]) {
                                DEBUG_printf(" Free char :%s\n", pStrings[j + 2]);
                                free((char *)pStrings[j + 2]);
                        }
                }
        }
}

void le_update_paletteaux_keymapinfo(iml_session_t *s, int engine_id)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[2];

        DEBUG_printf("le_update_paletteaux_keymapinfo: ======\n");

        nIntegerCount = 2;
        pIntegerList[0] = COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY;
        pIntegerList[1] = engine_id;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_update_keyboardaux_keymapinfo(iml_session_t *s, int engine_id, int bNeedKeyMap)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        char *classname = XAUX_KEYBOARD_CLASS_NAME;

        int nIntegerCount,  pIntegerList[2];
        int nStringsCount,  pLenStrings[1];
        char *pStrings[1];

        static char keymap_buf[MAX_KEYMAP_KEY_NUM][5];
        int encode_id, aux_locale_id;
        int i, ilen, olen, ret;
        char key_str[64], *str, *tmp_str;

        DEBUG_printf("le_update_keyboardaux_keymapinfo: ======\n");

        nIntegerCount = 2;
        pIntegerList[0] = COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY;
        pIntegerList[1] = engine_id;

        if (bNeedKeyMap) {
                memset(keymap_buf[0], 0, sizeof(keymap_buf));

                encode_id = desktop_data->engine_info[engine_id]->core.baseinfo.encode_id;
                aux_locale_id = desktop_data->aux_locale_id;
                for(i=0; i<MAX_KEYMAP_KEY_NUM; i++) {
                        str = (char *)desktop_data->engine_info[engine_id]->core.keymapinfo.keymap[i];
                        if (str && *str) {
                                if (encode_id == ENCODE_UTF8) {
                                        ilen = strlen(str);
                                        tmp_str = key_str;
                                        olen = 64;
                                        memset(key_str, 0, 64);
                                        ret = Convert_UTF8_To_Native(aux_locale_id, str, ilen, &tmp_str, &olen);
                                        if (ret == 0)
                                                strncpy(keymap_buf[i], key_str, 4);
                                } else {
                                        strncpy(keymap_buf[i], str, 4);
                                }
                                DEBUG_printf("keymap_buf[%d]: %s, str:%s\n", i, keymap_buf[i], str);
                        }
                }

                nStringsCount = 1;
                pLenStrings[0] = sizeof(keymap_buf);
                pStrings[0] = (char *)(keymap_buf[0]);

                send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                                nStringsCount,  pLenStrings,
                                pStrings);
        } else {
                send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                                0, NULL, NULL);
        }

}

void le_update_keymapinfo_notify(iml_session_t *s, int engine_id)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        int bSet, bSentKeymapToAux;

        if (engine_id < 0 || engine_id >= desktop_data->num_engine) return;

        bSet = desktop_data->engine_info[engine_id]->core.keymapinfo.bSet;

        if (bSet && desktop_data->paletteaux_started == True)
                le_update_paletteaux_keymapinfo(s, engine_id);

        if (desktop_data->keyboardaux_started == True) {
                bSentKeymapToAux = desktop_data->bSentKeymapToAux[engine_id];
                if (bSet && !bSentKeymapToAux) {
                        /* if have keymap and not sent to KeyboardAux */
                        /* send keymap to KeyboardAux */
                        le_update_keyboardaux_keymapinfo(s, engine_id, 1);
                        desktop_data->bSentKeymapToAux[engine_id] = True;
                } else {
                        /* if no keymap or have sent to KeyboardAux */
                        /* update the information of KeyboardAux */
                        le_update_keyboardaux_keymapinfo(s, engine_id, 0);
                }

        }
}

void le_update_keyboardaux_keypress_notify(iml_session_t *s, int keycode, int keychar, int keystatus)
{
        char *classname = XAUX_KEYBOARD_CLASS_NAME;
        int nIntegerCount,  pIntegerList[4];

        DEBUG_printf("le_update_keyboardaux_keypress_notify: ======\n");

        nIntegerCount = 4;
        pIntegerList[0] = KEYBOARDAUX_PRESS_KEY_NOTIFY;
        pIntegerList[1] = keycode;
        pIntegerList[2] = keychar;
        pIntegerList[3] = keystatus;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_send_keyevent_to_keyboardaux(iml_session_t *s, IMKeyListEvent *ev)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        IMKeyEventStruct *key_event = (IMKeyEventStruct *) ev->keylist;
        int keycode, keystatus, keychar;

        if (desktop_data->keyboardaux_started == False)
                return;

        if (session_data->keyboardaux_status.keyboard_id == -1)
                return;

        keycode = key_event->keyCode;
        keychar = key_event->keyChar;
        keystatus = key_event->modifier;

        DEBUG_printf("le_update_keyboardaux_keypress_notify: keycode:0x%x, keychar:0x%x, keystatus:0x%x\n",
                keycode, keychar, keystatus);
        le_update_keyboardaux_keypress_notify(s, keycode, keychar, keystatus);
}

void le_switch_conversion_notify(iml_session_t *s, int on)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[2];

        DEBUG_printf("le_switch_conversion_notify: ======\n");

        nIntegerCount = 2;
        pIntegerList[0] = PALETTEAUX_SWITCH_CONVERSION_NOTIFY;
        pIntegerList[1] = on;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_switch_ime_notify(iml_session_t *s, int switch_type, int ime_id)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[3];

        DEBUG_printf("le_switch_ime_notify: ======\n");

        nIntegerCount = 3;
        pIntegerList[0] = PALETTEAUX_SWITCH_IME_NOTIFY;
        pIntegerList[1] = switch_type;
        pIntegerList[2] = ime_id;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_switch_qjbj_notify(iml_session_t *s, int qjbj)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[2];

        DEBUG_printf("le_switch_qjbj_notify: ======\n");

        nIntegerCount = 2;
        pIntegerList[0] = PALETTEAUX_SWITCH_QJBJ_NOTIFY;
        pIntegerList[1] = qjbj;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_switch_punct_notify(iml_session_t *s, int punct)
{
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[2];

        DEBUG_printf("le_switch_punct_notify: ======\n");

        nIntegerCount = 2;
        pIntegerList[0] = PALETTEAUX_SWITCH_PUNCT_NOTIFY;
        pIntegerList[1] = punct;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_paletteaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_PALETTE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[7];

        DEBUG_printf("le_change_paletteaux_focus_notify: ======\n");

        nIntegerCount = 7;
        pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
        pIntegerList[1] = session_data->paletteaux_status.x;
        pIntegerList[2] = session_data->paletteaux_status.y;
        pIntegerList[3] = session_data->paletteaux_status.on;
        pIntegerList[4] = session_data->paletteaux_status.qjbj;
        pIntegerList[5] = session_data->paletteaux_status.punct;
        pIntegerList[6] = session_data->paletteaux_status.engine_id;

        DEBUG_printf(" x:%d, y:%d, on:%d, qjbj:%d, punct:%d, engine_id:%d\n",
                pIntegerList[1],
                pIntegerList[2],
                pIntegerList[3],
                pIntegerList[4],
                pIntegerList[5],
                pIntegerList[6]);
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_keyboardaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_KEYBOARD_CLASS_NAME;
        int nIntegerCount,  pIntegerList[7];

        DEBUG_printf("le_change_keyboardaux_focus_notify: ======\n");

        nIntegerCount = 7;
        pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
        pIntegerList[1] = session_data->keyboardaux_status.x;
        pIntegerList[2] = session_data->keyboardaux_status.y;
        pIntegerList[3] = session_data->keyboardaux_status.keyboard_id;
        pIntegerList[4] = session_data->keyboardaux_status.key_status;
        pIntegerList[5] = session_data->paletteaux_status.on;
        pIntegerList[6] = session_data->paletteaux_status.engine_id;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_lookupaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_LOOKUP_CLASS_NAME;
        int nIntegerCount,  pIntegerList[3];

        DEBUG_printf("le_change_lookupaux_focus_notify: ======\n");

        nIntegerCount = 3;
        pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
        pIntegerList[1] = session_data->lookupaux_status.on;
        pIntegerList[2] = session_data->paletteaux_status.on;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_selectaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_SELECT_CLASS_NAME;
        int nIntegerCount,  pIntegerList[3];

        DEBUG_printf("le_change_selectaux_focus_notify: ======\n");

        nIntegerCount = 3;
        pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
        pIntegerList[1] = session_data->selectaux_status.on;
        pIntegerList[2] = session_data->paletteaux_status.on;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_optionaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_OPTION_CLASS_NAME;
        int nIntegerCount,  pIntegerList[3];

        DEBUG_printf("le_change_optionaux_focus_notify: ======\n");

        nIntegerCount = 3;
        pIntegerList[0] = COMMONAUX_CHANGE_FOCUS_NOTIFY;
        pIntegerList[1] = session_data->optionaux_status.on;
        pIntegerList[2] = session_data->paletteaux_status.on;
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_change_focus_notify(iml_session_t *s)
{
        MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);

        if (desktop_data->paletteaux_started == True)
                le_change_paletteaux_focus_notify(s);

        if (desktop_data->keyboardaux_started == True)
                le_change_keyboardaux_focus_notify(s);

        if (desktop_data->lookupaux_started == True)
                le_change_lookupaux_focus_notify(s);

        if (desktop_data->selectaux_started == True)
                le_change_selectaux_focus_notify(s);

        if (desktop_data->optionaux_started == True)
                le_change_optionaux_focus_notify(s);

        if (desktop_data->compositeaux_started == True)
                le_change_compositeaux_focus_notify(s);
}

void le_show_selectaux_notify(iml_session_t *s)
{
        char *classname = XAUX_SELECT_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];

        DEBUG_printf("le_show_selectaux_notify: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = SELECTAUX_SHOW_NOTIFY;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_show_optionaux_notify(iml_session_t *s)
{
        char *classname = XAUX_OPTION_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];

        DEBUG_printf("le_show_optionaux_notify: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = OPTIONAUX_SHOW_NOTIFY;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_show_keyboardaux_notify(iml_session_t *s, int nKeyboardID, int engine_id)
{
        char *classname = XAUX_KEYBOARD_CLASS_NAME;
        int nIntegerCount,  pIntegerList[3];

        DEBUG_printf("le_show_keyboardaux_notify: ======\n");

        nIntegerCount = 3;
        pIntegerList[0] = KEYBOARDAUX_SHOW_NOTIFY;
        pIntegerList[1] = nKeyboardID;
        pIntegerList[2] = engine_id;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_show_lookupaux_notify(iml_session_t *s)
{
        char *classname = XAUX_LOOKUP_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];

        DEBUG_printf("le_show_lookupaux_notify: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = LOOKUPAUX_SHOW_NOTIFY;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}

void le_start_action_notify(iml_session_t *s, char *command_str)
{
        char *classname = XAUX_ACTION_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];
        int nStringsCount,  pLenStrings[1];
        char *pStrings[1];

        nIntegerCount = 1;
        pIntegerList[0] = ACTIONAUX_START_ACTION_NOTIFY;

        nStringsCount = 1;
        pLenStrings[0] = strlen(command_str) + 1;
        pStrings[0] = (char *)command_str;

        DEBUG_printf("le_start_action_notify: %s, len:%d\n", command_str, pLenStrings[0]);
        send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                        nStringsCount,  pLenStrings,
                        pStrings);
}

//int_list: protocal, caret, strlen, deco_len, deco_array
void le_draw_compositeaux_preedit_notify(iml_session_t *s, int encode_id,
                                 char* pretext, int caret, int deco_len, IMCharDecoration* predeco)
{
    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
    static char *classname = XAUX_COMPOSITE_CLASS_NAME;
    int i, nIntegerCount,  pIntegerList[3 + 1 + MAX_PREEDIT_CHAR_NUM];
    int nStringsCount,  pLenStrings[1];
    char *pStrings[1];

    int ilen, olen, ret;
    char utf_str[1024], *tmp_str;

    memset(utf_str, 0, sizeof(utf_str));

    nIntegerCount = 3 + 1 + deco_len;
    pIntegerList[0] = COMPOSITEAUX_DRAW_PREEDIT_NOTIFY;
    pIntegerList[1] = caret;

    ilen = (pretext == NULL)?0:(strlen(pretext));
    if (ilen > 0) {
        tmp_str = utf_str;
        olen = sizeof(utf_str)-1;
        Convert_Native_To_UTF8(encode_id, pretext, ilen, &tmp_str, &olen);
        ilen = sizeof(utf_str)- 1 - olen;
    }

    nStringsCount = 1;
    pStrings[0] = utf_str;
    pIntegerList[2] = pLenStrings[0] = strlen(utf_str) + 1;

    pIntegerList[3] = deco_len;
    for (i = 0; i < deco_len; ++i) {
        if (predeco == NULL)
            pIntegerList[3+1+i] = 0;
        else
            pIntegerList[3+1+i] = *(int *)(predeco+i);
    }

    send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                    nStringsCount,  pLenStrings,
                    pStrings);
}

// nStringCount == nCand
// int_list: Protocal, markType, nCand of strlen, nCand of deco_len, deco_array
void le_draw_compositeaux_lookup_notify(iml_session_t *s, int encode_id,
                                 int nCand, int markType, unsigned char**candlist,
                                 int *deco_len, IMCharDecoration**canddecolist)
{
    static char *classname = XAUX_COMPOSITE_CLASS_NAME;

    MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)(s->desktop->specific_data);
    int nIntegerCount,  nStringsCount, i, ilen, olen, offset=0;
    char *tmp_str;
    char *pStrings[MAX_CANDIDATES_NUM], utf_str[1024];
    int pIntegerList[2 + 2*MAX_CANDIDATES_NUM + MAX_CANDIDATE_CHAR_NUM], pLenStrings[MAX_CANDIDATES_NUM];

    memset(utf_str, 0, sizeof(utf_str));

    pIntegerList[0] = COMPOSITEAUX_DRAW_LOOKUP_NOTIFY;
    pIntegerList[1] = markType;

    if (nCand > MAX_CANDIDATES_NUM)  nCand = MAX_CANDIDATES_NUM;
    nStringsCount = nCand;

    for (i=offset=0; i < nCand; ++i) {
        pStrings[i] = utf_str + offset;
        if (candlist[i] == NULL) {
            ilen = 0;
        } else {
            ilen = strlen(candlist[i]);
            tmp_str = pStrings[i];
            olen = sizeof(utf_str) - offset - 8;
            Convert_Native_To_UTF8(encode_id, candlist[i], ilen, &tmp_str, &olen);
            ilen = strlen(pStrings[i]);
        }

        pStrings[i][0+ilen] = 0;
        pStrings[i][1+ilen] = 0;
        pStrings[i][2+ilen] = 0;
        pStrings[i][3+ilen] = 0;
        pStrings[i][4+ilen] = 0;
        pStrings[i][5+ilen] = 0;
        pStrings[i][6+ilen] = 0;
        pStrings[i][7+ilen] = 0;
        pIntegerList[i+2] = pLenStrings[i] = ilen + 1;
        offset += (ilen + 8);
    }

    nIntegerCount = 2 * nCand + 2;

    for (i = 0; i < nCand; ++i) {
        pIntegerList[2+nCand+i] = (deco_len == NULL)?0:deco_len[i];
        nIntegerCount += pIntegerList[2+nCand+i];
    }

    for (i = 0, offset = 2*nCand+2; i < nCand; ++i) {
        for (ilen=0; ilen < pIntegerList[2+nCand+i]; ++ilen) {
            if (canddecolist == NULL || canddecolist[i] == NULL)
                pIntegerList[offset++] = 0;
            else
                pIntegerList[offset++] = *(int *)(&canddecolist[i][ilen]);
        }
    }
    send_info_to_aux(s, classname, nIntegerCount, pIntegerList,
                    nStringsCount,  pLenStrings,
                    pStrings);
}

void le_change_compositeaux_focus_notify(iml_session_t *s)
{
        MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
        char *classname = XAUX_COMPOSITE_CLASS_NAME;

        DEBUG_printf("le_change_compositeaux_focus_notify: ======\n");

        int encode_id = session_data->ime_buffer->encode;
        unsigned char *preedit_buf = session_data->ime_buffer->preedit_buf;
        int caret = session_data->ime_buffer->preedit_caretpos;
        int nCand = session_data->ime_buffer->lookup_num;
        unsigned char **candlist = session_data->ime_buffer->lookup_buf;
        int lookup_label_type = session_data->ime_buffer->lookup_label_type;

        if (!session_data->paletteaux_status.on) {
		le_hide_compositeaux_notify(s);
		return;
	}

        le_draw_compositeaux_preedit_notify(s, encode_id, preedit_buf, caret,
                    session_data->ime_buffer->preedit_deco_len, session_data->ime_buffer->preedit_deco);

        le_draw_compositeaux_lookup_notify(s, encode_id, nCand, lookup_label_type, candlist,
                    session_data->ime_buffer->lookup_deco_len, session_data->ime_buffer->lookup_deco);
}

void le_hide_compositeaux_notify(iml_session_t *s)
{
        char *classname = XAUX_COMPOSITE_CLASS_NAME;
        int nIntegerCount,  pIntegerList[1];

        DEBUG_printf("le_hide_compositeaux_notify: ======\n");

        nIntegerCount = 1;
        pIntegerList[0] = COMPOSITEAUX_HIDE_NOTIFY;

        send_info_to_aux(s, classname, nIntegerCount, pIntegerList, 0, NULL, NULL);
}
