#ifndef __CONSTRAINT_SCALING_H__
#define __CONSTRAINT_SCALING_H__
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>

typedef struct _ConstrainedPixbuf ConstrainedPixbuf;

typedef enum {
  CONSTANT_ROWS = 1 << 0,
  CONSTANT_COLS = 1 << 1,
  MISSING = 1 << 2
} RenderHints;

struct _ConstrainedPixbuf
{
  char		 *text;
  char		 *font;

  PangoLayout *layout;
  
  GdkPixbuf  *pixbuf;
  GdkPixbuf  *scaled;

  int	     center_x;
  int	     center_y;
  int	     resulting_width;
  gint       border_left_scaled;
  gint       border_right_scaled;
  
  guint	     component_mask;
  gint       border_left;
  gint       border_right;
  gint       border_bottom;
  gint       border_top;
  guint      hints[3][3];
};

typedef enum
{
  COMPONENT_NORTH_WEST = 1 << 0,
  COMPONENT_NORTH      = 1 << 1,
  COMPONENT_NORTH_EAST = 1 << 2,
  COMPONENT_WEST       = 1 << 3,
  COMPONENT_CENTER     = 1 << 4,
  COMPONENT_EAST       = 1 << 5,
  COMPONENT_SOUTH_EAST = 1 << 6,
  COMPONENT_SOUTH      = 1 << 7,
  COMPONENT_SOUTH_WEST = 1 << 8,
  COMPONENT_ALL           = 1 << 9
} ConstrainedPixbufComponent;

gboolean
constrained_pixbuf_init (ConstrainedPixbuf *cp,
			 GdkPixbuf	   *src);

void
constrained_pixbuf_free (ConstrainedPixbuf *cp);
	

void
constrained_pixbuf_render (ConstrainedPixbuf *cp,
			   gint		   height);

void
constrained_pixbuf_compute_layout (GtkWidget *widget,
				   ConstrainedPixbuf *cp,
				   int height, int width);

#endif /*__CONSTRAINT_SCALING_H__*/
