#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common/error.h"
#include "common/debug.h"
#include "common/common.h"

/* check_offset:
 *   Check if a chunk of data (determined by offset and size)
 *   is within the bounds of the WinLibrary file.
 *   Usually not called directly.
 */
bool
check_offset(char *memory, int total_size, char *name, void *offset, int size)
{
	int need_size = (int) ((char *) offset - memory + size);

	debug("check_offset: size=%x vs %x offset=%x size=%x\n",
		need_size, total_size, (char *) offset - memory, size);

	if (need_size < 0 || need_size > total_size) {
		warn("%s: premature end", name);
		return false;
	}

	return true;
}
