<?php
// File           dt_enter.php / ibWebAdmin
// Purpose        html sequence for the enter-data-panel in data.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/10/04 19:37:59 lb>
//
// $Id: dt_enter.php,v 1.8 2003/02/04 19:50:39 lbrueckner Exp $


if ($s_connected && (!isset($s_enter_name) || $s_enter_name == '')) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="dt_enter_form">
<?php hidden_session_field(); ?>
<table cellpadding="3" cellspacing="0">
<tr>
   <td colspan="2"><b><?php echo $dt_strings['SelTable']; ?></b><br>
      <select name="dt_enter_name">
        <?php build_table_options('', array('noviews', 'insert')); ?>
      </select>
   </td>
   <td valign="bottom">
      <input type="submit" name="dt_enter_select" value="<?php echo $button_strings['Select']; ?>">
   </td>
</tr>
</table>
</form>
<?php

} elseif ($s_connected) {
    $js_stack .= js_giveFocus('dt_enter_form', 'dt_insert_field_0');

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="dt_enter_form" <?php if (has_blob($s_enter_name)) echo 'enctype="multipart/form-data"'; ?>>
<?php hidden_session_field(); ?>
<table border cellpadding="3" cellspacing="0">
  <tr>
    <th colspan="2" align="left"><b><?php echo $dt_strings['Table'].': '.$s_enter_name; ?></b></th>
  </tr>
<?php
    $i = 0;
    foreach($s_fields as $idx => $field) {
        if ($field['table'] == $s_enter_name) {
            $maxlen = (isset($field['size'])) ? $field['size'] : 20;
            if (!isset($field['size'])) {
                $size = $maxlen;
            } else {
                $size = ($field['size'] + 1  > DATA_MAXWIDTH) ? DATA_MAXWIDTH : $field['size'] + 1;
            }

            if (isset($field['default'])) {
                $value = (is_string($field['dsource'])) 
                       ? $field['dsource'] 
                       : ($s_fields[$idx]['dsource'] = get_field_default($s_enter_name, $field['name']));
            } 
            else {
                $value = (isset($s_enter_values[$i])) ? $s_enter_values[$i] : '';
            }
            echo "  <tr>\n    <td><b>".$field['name']."</b></td>\n";

            if (isset($field['comp'])) {
                echo '    <td>'.(is_string($field['csource']) ? $field['csource'] : ($s_fields[$idx]['csource'] = get_field_computed_source($s_enter_name, $field['name'])));
            }
            elseif ($field['type'] == 'BLOB') {
                echo "    <td>\n      <input type=\"file\" size=\"50\" name=\"dt_insert_field_$i\">\n";
            }
            else {
                echo "    <td>\n      <input type=\"text\" size=\"$size\" maxlength=\"$maxlen\" name=\"dt_insert_field_$i\" value=\"$value\">\n";
            }
            echo "    </td>\n  </tr>\n";
            $i++;
        }
    }
?>
</table>
<input type="submit" name="dt_enter_ready" value="<?php echo $button_strings['Ready']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="dt_enter_reset" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="dt_enter_insert" value="<?php echo $button_strings['Insert']; ?>">
</form>
<?php

}

?>
