// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_DEFINITIONS
#define HK_DEFINITIONS
#include "hk_string.h"
#include <list>
#include <stdlib.h>
#include <stdio.h>

using namespace std;

#define  HK_DEBUG
#define HK_VERSION "073"
/**
 *@version $Revision: 1.53 $
 */
enum filetype{ft_table=1,ft_query=2,ft_form=3,ft_report=4,ft_view=6};
enum listtype{lt_table=1,lt_query=2,lt_form=3,lt_report=4,lt_index=5,lt_view=6};

enum datasourcetype {dt_table=1,dt_query=2,dt_view=3};
enum objecttype{ot_database=0,ot_table=1,ot_query=2,ot_form=3,ot_report=4,ot_view=6};

/**
 * used as entry to the raw data
 */

typedef class struct_raw_data
{
    public:
        struct_raw_data(){length=0;data=NULL;}
        unsigned long   length;
        const char* data;

} ;

typedef class struct_connectionfields
{
    public:
        struct_connectionfields(){cancel=false;save=false;allowdatabaseselect=true;};
        hk_string host;
        hk_string user;
        hk_string password;
        hk_string sql_delimiter;
        hk_string port;
	hk_string database;
	bool allowdatabaseselect;
        bool cancel;
        bool save;
	bool emulateboolean;
} ;


class struct_commands;

typedef class struct_commandlinefields
{
    public:
        struct_commandlinefields()
	    {
	       runtime_only=false;
	       p_guicommands=NULL;
	    };
	hk_string driver;
	hk_string database;
	hk_string form;
        
	hk_string host;
        hk_string user;
        hk_string password;
        hk_string port;
	bool runtime_only;
	struct_commands* p_guicommands;
} ;


int hk_random(int min,int max);

class hk_column;
/**
 *returns true if the columntype (not the data) is numeric, either integer or real.
 */
bool is_numerictype(hk_column*);
/**
 *returns true if the columntype (not the data) integer.
 */
bool is_integertype(hk_column*);
/**
 *returns true if the columntype (not the data) floating point type.
 */
bool is_realtype(hk_column*);
double inch2cm(double);
double cm2inch(double);
//the following functions and datatypes are all needed for hk_report
class hk_report;
class hk_reportdata;
class hk_reportsection;

typedef hk_string   recodefunctiontype(const hk_string&,hk_report*);
typedef hk_string   data_replacefunctiontype(hk_reportdata*,const hk_string&);
typedef bool report_configurefunction(hk_report*,int);
typedef bool reporttypefunction(hk_report*,bool);
typedef unsigned long reportsectioncounttype(hk_reportsection*);
typedef void reportsectionautomaticcreatedatatype(hk_reportsection*);
typedef unsigned long reportdatacounttype(hk_reportdata*);
typedef void    data_configurefunctiontype(hk_reportdata*);

typedef void voidfunction(void);

union number
{
    long integer;
    double real;
};

union longnumber
{
    long int integer;
    long double real;
};


typedef class
{
 public:
 hk_string dependingfield;
 hk_string masterfield;
} dependingclass;


typedef class referentialclass
{
public:
referentialclass();
bool operator=(const referentialclass&);


hk_string p_name;
hk_string p_masterdatasource;
list<dependingclass> p_fields;
bool p_deletecascade;
bool p_updatecascade;
} ;

#endif



