// choosediff.c	- as choose.c but uses highest (ackcount  - nakcount)
// ------------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see choose.h for spec.
// Different implementations will try different policies.
// The class is instantiatied ONCE.

#include "node.h"
#include "choose.h"
#include <stream.h>

extern node nodes[];
extern int cube_size;
extern const int bitmask[];	// bitmask[i] is 2**i

chooseclass choose;		// ONLY INSTANCE

struct mylink {
	int ackcount;
	int nakcount;
};
struct mynode {
	struct mylink mylinks[ MAX_CUBE_ORDER ];
};
struct mynode mynodes[ MAX_CUBE_SIZE ];
/*************************************************/
chooseclass::chooseclass()
{
	for( nodenum n = 0; n < MAX_CUBE_SIZE; n++ ) {
		for( linknum l = 0; l < MAX_CUBE_ORDER; l++ ) {
			mynodes[n].mylinks[l].ackcount = 0;
			mynodes[n].mylinks[l].nakcount = 0;
		}
	}
}
/*******************************************/
void chooseclass::start()
{
}
/*******************************************/
void chooseclass::sanitycheck()
{
	cout << "Choose algorithm: highest (ack-nak)count.\n";
}
/*******************************************/
void chooseclass::noteack( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].mylinks[lout].ackcount++;
}
/*******************************************/
void chooseclass::notenak( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].mylinks[lout].nakcount++;
}
/*****************************************/
//
// rightmost returns the bit position (0..15) of the rightmost set bit.
// Returns -1 if no bit set.

linknum rightmost( int mask )
{
	if( (mask <0) || (mask > cube_size)){
		cout << "ERROR: rightmost invalid argument " << mask NL;
		return 1;
	}
	if( mask == 0 ) return -1;
	int i;
	for( i=0;; i++ ) {
		if( mask & 1 ) break;
		mask >>= 1;
	}
	return i;
}
/*****************************************/
// chooselink returns a link# that is free at that node,
// and that is in both the linkset and the okset.
// Returns -1 if no such.
// The search prefers the highest ackcount.

linknum chooseclass::outlink( nodenum here, int linkset, int okset )
{
	struct node *phere = &nodes[ here ];
	struct mynode *pmyhere = &mynodes[ here ];
	int bestlack = -999999999;
	int bestl = -1;
	linknum l;
	linkset &= okset;				// bitwise and
	for(;;) {
		l = rightmost( linkset );		// index of bit
		if( l < 0 ) break;
		if( phere->links[l].busy == false ) {
			// found a candidate link
			int lack = pmyhere-> mylinks[l].ackcount -
				   pmyhere-> mylinks[l].nakcount;
			if( bestlack < lack ) {
				// new best
				bestlack = lack;
				bestl = l;
			}
		}
		linkset ^= bitmask[l];			// turn off bit l
	}
	return bestl;
}
/*******************************************/
//	int goodlinkset, badlinkset;
//	linknum lastlink;
//	char bestlink[ MAX_CUBE_SIZE ];
