/* This collection of calc functions was originally designed for a 
 * school project. Thus,it contains many things we dont actually use
 * within Gnome Toaster. You can find the original file within the distrib
 * archive of the Klens project located on my personal Homepage,
 * http://dos4gw.home.pages.de 
 * The "tangent" function of the original file has been removed as we do
 * not have a definition of vectors within Gnome Toaster. */

#ifndef CALC_H
#define CALC_H

typedef void (*calc_handler)(char *arg1,char *arg2,char *output);

typedef struct 
{
	char name[20];
	calc_handler handler;
} calc_expr;	

int calc_calculate(char *input,char *output);
double calc_function(char *input,int reps,...);
double calc_derive(char *input,char *var,double pos);
calc_expr *calc_expression_create(char *name,calc_handler handler);
calc_expr *calc_expression_get_byname(char *name);
void calc_expression_register_prepend(calc_expr*);
void calc_expression_register_append(calc_expr*);
/* register an expression just after the expression "name" */
void calc_expression_register_after(char *name,calc_expr*);
/* register an expression before the expression "name" */
void calc_expression_register_before(char *name,calc_expr*);
void calc_expression_unregister(calc_expr*);
void calc_expression_unregister_byname(char *name);
void calc_init();  /* initialize calc.c, install internal functions */

#endif // CALC_H
