// logview.cc
//
//    logarithmic scale for tunes
//
//    Copyright (C) 1999  Florian Berger
//    Copyright (C) 1999  Florian Berger
//    Email: florian.berger@jk.uni-linz.ac.at
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include <gtk--/drawingarea.h>


extern double KAMMERTON, KAMMERTON_LOG;


class LogView : public Gtk::DrawingArea
{
//    Q_OBJECT

public:

    LogView();
    ~LogView();

    enum {us_scale,us_scale_alt,german_scale,german_scale_alt};

    int  lfreq_pos(double lfreq);
    int  pos_note(int pos);
    void drawarrow();
    void delarrow();
    void change_lfreq(double freq);
    void setScale(int scale);
    void draw_it();
    void set_nat_tuning(bool state);

protected:

    gint expose_event_impl(GdkEventExpose* p0);
//    void draw_default_impl();
    gint button_press_event_impl(GdkEventButton* p0);

private:

    bool      nat_tuning_on;
    int       x0,y0,h;
    int       grundton;     // for natural tuning
    double    lfreq0,lfreq1;
    double    lfreq;
    double    freqs[12];
    double    lfreqs[12];
    Gdk_Color i_col_bg;
    Gdk_Color i_col_draw;
    Gdk_Color i_col_shad;
    Gdk_Color i_col_bg2;
    Gdk_Color i_col_pointer;
    Gdk_Color i_col_ticks;
    Gdk_Color i_col_marks;
    Gdk_GC    i_GC;
};













