// -*- C++ -*-

/* window_testsheet.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_testsheet.h"

#include <iostream>
#include <gtk--/window.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/main.h>

#include "pixmaps.h" //bitmaps - file copied from GtkExtra.

#include <vector>

Window_TestSheet::Window_TestSheet()
: m_VBox(false, 1),
  m_HBox_ShowHide(false, 1),
  m_Button_HideRowTitles("Hide Row Titles"), 
  m_Button_HideColumnTitles("Hide Column Titles"), 
  m_Button_ShowRowTitles("Show Row Titles"),
  m_Button_ShowColumnTitles("Show Column Titles"),
  m_Toolbar(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS),
  m_pixmap_bg(paint),
  m_pixmapFont(font),
  m_pixmapJustifyLeft(left_just),
  m_pixmapJustifyRight(right_just),
  m_pixmapJustifyCenter(center_just),
  m_HBox_Status(false, 1),
  m_Label_Location(""),
  m_Sheet_LogSignals(1000, 26, "Example 1"),
  m_Sheet_Numeric_WithPopup(1000, 26, "Example 2"),
  m_Toolbar_ToggleCombo(5, 5)
{ 
  set_title("GtkExtra::Sheet Demo");
  set_usize(900, 600);

  m_VBox.set_border_width(0);
  add(m_VBox);

  m_HBox_ShowHide.pack_start(m_Button_HideRowTitles);
  m_HBox_ShowHide.pack_start(m_Button_HideColumnTitles);
  m_HBox_ShowHide.pack_start(m_Button_ShowRowTitles);
  m_HBox_ShowHide.pack_start(m_Button_ShowColumnTitles);

  m_Button_HideRowTitles.clicked.connect(slot(this, &Window_TestSheet::on_Button_HideRowTitles));
  m_Button_HideColumnTitles.clicked.connect(slot(this, &Window_TestSheet::on_Button_HideColumnTitles));
  m_Button_ShowRowTitles.clicked.connect(slot(this, &Window_TestSheet::on_Button_ShowRowTitles));
  m_Button_ShowColumnTitles.clicked.connect(slot(this, &Window_TestSheet::on_Button_ShowColumnTitles));
  
  m_VBox.pack_start(m_HBox_ShowHide, false);

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the FontCombo to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_FontCombo, "font", "font") );
  
  Gtk::Button* pButtonItalic = m_Toolbar_FontCombo.get_italic_button();
  pButtonItalic->set_usize(32,32);
  //delete pButtonItalic;
  pButtonItalic = NULL;

  Gtk::Button* pButtonBold = m_Toolbar_FontCombo.get_bold_button();
  pButtonBold->set_usize(32,32);
  //delete pButtonBold;
  pButtonBold = NULL;

  m_Toolbar_FontCombo.changed.connect(slot(this, &Window_TestSheet::on_Toolbar_FontCombo_Changed));

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the justification buttons to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_Button_Left, "justify left", "justify left") );
  m_Toolbar_Button_Left.released.connect(slot(this, &Window_TestSheet::on_Toolbar_Button_Left));

  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_Button_Center, "justify center", "justify center") );
  m_Toolbar_Button_Center.released.connect(slot(this, &Window_TestSheet::on_Toolbar_Button_Center));

  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_Button_Right, "justify right", "justify right") );
  m_Toolbar_Button_Right.released.connect(slot(this, &Window_TestSheet::on_Toolbar_Button_Right));

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the BorderCombo to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_BorderCombo, "border", "border") );
  Gtk::Button* pButtonBorderCombo = wrap(m_Toolbar_BorderCombo.get_button()); //Gtk-- wrapper will be deleted when GTK+ object is destroyed.
  pButtonBorderCombo->set_usize(32, 32);
  pButtonBorderCombo = 0;
  m_Toolbar_BorderCombo.changed.connect(slot(this, &Window_TestSheet::on_Toolbar_BorderCombo_Changed));

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the Text ColorCombo to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_ColorCombo_fg, "font color", "font color") );
  m_Toolbar_ColorCombo_fg.changed.connect(slot(this, &Window_TestSheet::on_Toolbar_ColorCombo_fg));

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the Background ColorCombo to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element( m_Toolbar_ColorCombo_bg, "background color", "background color") );
  m_Toolbar_ColorCombo_bg.changed.connect(slot(this, &Window_TestSheet::on_Toolbar_ColorCombo_bg));

  m_Toolbar.tools().push_back(Gtk::Toolbar_Helpers::Space());

  //Add the test toggle combo to the toolbar:
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::Element(m_Toolbar_ToggleCombo, "test", "test") );

  Gtk::Button* pButtonToggleCombo = wrap(m_Toolbar_ToggleCombo.get_button()); //Gtk-- wrapper will be deleted when GTK+ object is destroyed.
  pButtonToggleCombo->set_usize(32, 32);
  pButtonToggleCombo = 0;

  m_VBox.pack_start(m_Toolbar, false);

  m_HBox_Status.set_border_width(0);
  m_VBox.pack_start(m_HBox_Status, false);

  GtkRequisition request; 
  m_Label_Location.size_request(&request); 
  m_Label_Location.set_usize(160, request.height);

  m_HBox_Status.pack_start(m_Label_Location, false);

  m_HBox_Status.pack_start(m_Entry);
  m_Entry.show();

  m_Notebook.set_tab_pos(GTK_POS_BOTTOM);
  m_VBox.pack_start(m_Notebook);

  m_ppSheets[0] = &m_Sheet_LogSignals;
  m_ppSheets[1] = &m_Sheet_Numeric_WithPopup;
  m_ppSheets[2] = manage(new GtkExtra::Sheet(1000, 26, "Example 3"));
  
  for(int i=0; i<3; i++)
  {
    m_ppScrolledWindows[i] = manage(new Gtk::ScrolledWindow());

    m_ppScrolledWindows[i]->add(*(m_ppSheets[i]));
    //m_ppSheets[i]->show();

    m_ppScrolledWindows[i]->show();

    //Gtk::Label* pLabel = manage(new Gtk::Label(vecLabels[i]));
    //m_Notebook.append_page(*(m_ppScrolledWindows[i]), *pLabel);
    m_Notebook.add(*(m_ppScrolledWindows[i]));

    Gtk::Entry* pSheetEntry = static_cast<Gtk::Entry*>(m_ppSheets[i]->get_entry());
    if(pSheetEntry) pSheetEntry->changed.connect(slot(this, &Window_TestSheet::on_Sheet_Entry_Changed));
    
    m_ppSheets[i]->activate.connect(slot(this, &Window_TestSheet::on_Sheet_Activate));
  }

  m_Entry.changed.connect(slot(this, &Window_TestSheet::on_Entry_Changed));
  m_Entry.activate.connect(slot(this, &Window_TestSheet::on_Entry_Activate));

  build_example1(); 
  build_example2();
  build_example3();

  m_Toolbar_Button_Left.add(m_pixmapJustifyLeft);
  m_Toolbar_Button_Center.add(m_pixmapJustifyCenter);
  m_Toolbar_Button_Right.add(m_pixmapJustifyRight);

  Gtk::Button* pButtonColorCombo_bg = wrap(m_Toolbar_ColorCombo_bg.get_button()); //Gtk-- wrapper will be deleted when GTK+ object is destroyed.
  pButtonColorCombo_bg->add(m_pixmap_bg);
  pButtonColorCombo_bg = 0;

  Gtk::Button* pButtonColorCombo_fg = wrap(m_Toolbar_ColorCombo_fg.get_button()); //Gtk-- wrapper will be deleted when GTK+ object is destroyed.
  pButtonColorCombo_fg->add(m_pixmapFont);
  pButtonColorCombo_fg = 0;
  
  show_all();
}

Window_TestSheet::~Window_TestSheet()
{
}

void
Window_TestSheet::build_example1()
{ 
 GtkExtra::Sheet* pSheet = m_ppSheets[0];
 
 for(int i=0; i < pSheet->get_columns_count(); i++)
 {
   gchar pchName[] = {'A'+i, 0};
   pSheet->column_button_add_label(i, pchName); //TODO: Why is this necessary?
   pSheet->set_column_title(i, pchName);
 }

 pSheet->row_button_add_label(0, "This is\na multiline\nlabel");
 pSheet->row_button_justify(0, GTK_JUSTIFY_RIGHT);

 GtkSheetRange range;
 range.row0=1;
 range.rowi=2;
 range.col0=1;
 range.coli=3;

 pSheet->cause_clip_range(range);

 gchar font_name2[]="-bitstream-charter-bold-r-normal--28-280-72-72-p-0-iso8859-1";
 Gdk_Font font(font_name2);
 
 Gdk_Color color;
 color.parse("red");

 Gdk_Colormap colormapSheet = pSheet->get_colormap();
 colormapSheet.alloc(color);

 pSheet->range_set_foreground(range, color);

 pSheet->cause_set_cell(1,2, GTK_JUSTIFY_CENTER, "Welcome to");

 range.row0=2;

/*
 gchar font_name1[]="-bitstream-charter-bold-r-normal--36-360-72-72-p-0-iso8859-1";
 Gdk_Font font2(font_name1);
 if(!(font2.gdkobj()))
   g_warning ("Couldn't load %s", font_name1);
 else
   pSheet->range_set_font(range, font2);
 */

 color.parse("blue");
 colormapSheet.alloc(color);
 pSheet->range_set_foreground(range, color);

 pSheet->cause_set_cell(2,2, GTK_JUSTIFY_CENTER, "GtkSheet");

 range.row0=3;
 range.rowi=3;
 range.col0=0;
 range.coli=4;
 color.parse("dark gray");
 colormapSheet.alloc(color);
 pSheet->range_set_background(range, color);
 
 color.parse("green");
 colormapSheet.alloc(color);
 pSheet->range_set_foreground(range, color);

 pSheet->cause_set_cell(3,2,GTK_JUSTIFY_CENTER, "a Matrix widget for Gtk+");

 pSheet->cause_set_cell(4,1,GTK_JUSTIFY_LEFT, "GtkSheet is a matrix in which you can allocate cells of text.");
 pSheet->cause_set_cell(5,1,GTK_JUSTIFY_LEFT, "Cell contents can be edited interactively with a specially designed entry");
 pSheet->cause_set_cell(6,1,GTK_JUSTIFY_LEFT, "You can change colors, borders, and many other attributes");
 pSheet->cause_set_cell(7,1, GTK_JUSTIFY_LEFT, "Drag & drop or resize the selection by clicking the corner or border");
 pSheet->cause_set_cell(8, 1, GTK_JUSTIFY_LEFT, "Store the selection on the clipboard pressing Ctrl-C");
 pSheet->cause_set_cell(9, 1, GTK_JUSTIFY_LEFT, "(The selection handler has not been implemented yet)");
 pSheet->cause_set_cell(10, 1, GTK_JUSTIFY_LEFT, "You can add buttons, charts, pixmaps, and other widgets");

 pSheet->key_press_event.connect(slot(this, &Window_TestSheet::on_Sheet_key_press_event_Clipboard));

 //Add the bullet pixmaps to the left of the text: 
 for(int i=0; i<5; i++)
 {
   m_ppPixmapBullets[i] = manage(new Gtk::Pixmap(bullet_xpm));
   m_ppPixmapBullets[i]->show();

   pSheet->attach(m_ppPixmapBullets[i], 4+i, 0, .5, .5);
 }

 m_ppPixmapBullets[5] = manage(new Gtk::Pixmap(bullet_xpm));
 m_ppPixmapBullets[5]->show();
 pSheet->attach(m_ppPixmapBullets[5], 10, 0, .5, .5);

 //Add a smiley pixmap to a column header button:
 Gtk::Pixmap* pPixmapSmile = manage(new Gtk::Pixmap(smile_xpm));
 pPixmapSmile->show();
 pSheet->button_attach(*pPixmapSmile, -1, 5, .5, .5);

 //Add the 'Show me a plot' button:
 m_pButton_Show = manage(new Gtk::Button("Show me a plot"));
 m_pButton_Show->set_usize(100,60);
 
 pSheet->attach(m_pButton_Show, 12, 2, .5, .5);
 m_pButton_Show->show();

 m_pButton_Show->clicked.connect(slot(this, &Window_TestSheet::on_Button_Show));
}

void
Window_TestSheet::build_example2()
{
  GtkExtra::Sheet* pSheet = m_ppSheets[1];

	pSheet->set_auto_scroll(false);

  GtkSheetRange range;
	range.row0 = 0;
	range.rowi = 2;
	range.col0 = 0;
	range.coli = pSheet->get_columns_count()-1;  //0-indexed.
 
	pSheet->range_set_editable(range, false);

	Gdk_Color color;
	color.parse("light gray");

	Gdk_Colormap colormapSheet = pSheet->get_colormap();
  colormapSheet.alloc(color);
	pSheet->range_set_background(range, color);
	
	color.parse("blue");
	colormapSheet.alloc(color);
	pSheet->range_set_foreground(range, color);
	
	range.row0=1;
	color.parse("red");
	colormapSheet.alloc(color);
	pSheet->range_set_foreground(range, color);
	
	range.row0=2;
	color.parse("black");
	colormapSheet.alloc(color);
	pSheet->range_set_foreground(range, color);

	pSheet->row_set_sensitivity(0, false);
	pSheet->row_set_sensitivity(1, false);
	pSheet->row_set_sensitivity(2, false);
	pSheet->cause_set_cell(0,2, GTK_JUSTIFY_CENTER, "Click the right mouse button to display a popup");
	pSheet->cause_set_cell(1,2, GTK_JUSTIFY_CENTER, "You can connect a parser to the 'set cell' signal");
	pSheet->cause_set_cell(2,2, GTK_JUSTIFY_CENTER, "(Try typing numbers)");
	pSheet->set_active_cell(3, 0);
}

void
Window_TestSheet::build_example3()
{
  GtkExtra::Sheet* pSheet = m_ppSheets[2];

  GtkSheetRange range;
	range.row0=0;
	range.rowi=10;
	range.col0=0;
	range.coli=6;

  Gdk_Color color;
	
	color.parse("orange");
	Gdk_Colormap colormapSheet = pSheet->get_colormap();
	colormapSheet.alloc(color);
	pSheet->range_set_background(range, color);
	
	color.parse("violet");
	colormapSheet.alloc(color);
	pSheet->range_set_foreground(range, color);
	
	range.row0=1;
	color.parse("blue");
	colormapSheet.alloc(color);
	pSheet->range_set_background(range, color);
	
	range.coli=0;
	color.parse("dark green");
	colormapSheet.alloc(color);
	pSheet->range_set_background(range, color);

	range.row0=0; 
	color.parse("dark blue");
	colormapSheet.alloc(color);
	pSheet->range_set_border_color(range, color);
	pSheet->range_set_border(range, GTK_SHEET_RIGHT_BORDER, 4, 1);
	range.coli=0;
	range.col0=0;
	range.rowi=0;
	color.parse("red");
	colormapSheet.alloc(color);
	pSheet->range_set_background(range, color);
	pSheet->range_set_border(range, GTK_SHEET_RIGHT_BORDER|
	                                          GTK_SHEET_BOTTOM_BORDER, 4, 0);
	range.rowi=0;
	range.col0=1;
	range.coli=6;
	color.parse("dark blue");
	colormapSheet.alloc(color);
	pSheet->range_set_border_color(range, color);
	pSheet->range_set_border(range, GTK_SHEET_BOTTOM_BORDER, 4, 1);

  pSheet->set_auto_resize();

	pSheet->change_entry(gtk_combo_get_type());
	//pSheet->change_entry(Gtk::Combo::get_type());
	
	pSheet->traverse.connect(slot(this, &Window_TestSheet::on_Sheet3_traverse));
}

gint Window_TestSheet::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

void 
Window_TestSheet::on_Button_HideRowTitles() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  if(pSheetCurrent) pSheetCurrent->hide_row_titles();
}

void 
Window_TestSheet::on_Button_HideColumnTitles() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  if(pSheetCurrent) pSheetCurrent->hide_column_titles();
}

void 
Window_TestSheet::on_Button_ShowRowTitles() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  if(pSheetCurrent) pSheetCurrent->show_row_titles();
}

void 
Window_TestSheet::on_Button_ShowColumnTitles() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  if(pSheetCurrent) pSheetCurrent->show_column_titles();
}

GtkExtra::Sheet*
Window_TestSheet::Get_CurrentSheet()
{
  gint cur_page = m_Notebook.get_current_page_num();
  GtkExtra::Sheet* pSheetCurrent = m_ppSheets[cur_page];
  return pSheetCurrent;
}

void 
Window_TestSheet::on_Toolbar_Button_Left() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  m_Toolbar_Button_Left.set_active(GTK_STATE_ACTIVE);
  m_Toolbar_Button_Right.set_active(GTK_STATE_NORMAL);
  m_Toolbar_Button_Center.set_active(GTK_STATE_NORMAL);

  if(pSheetCurrent)
  { 
    pSheetCurrent->range_set_justification(pSheetCurrent->get_selected_range(), GTK_JUSTIFY_LEFT);
  }
}

void 
Window_TestSheet::on_Toolbar_Button_Right() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  m_Toolbar_Button_Left.set_active(GTK_STATE_NORMAL);
  m_Toolbar_Button_Right.set_active(GTK_STATE_ACTIVE);
  m_Toolbar_Button_Center.set_active(GTK_STATE_NORMAL);

  if(pSheetCurrent)
  { 
    pSheetCurrent->range_set_justification(pSheetCurrent->get_selected_range(), GTK_JUSTIFY_RIGHT);
  }
}

void 
Window_TestSheet::on_Toolbar_Button_Center() 
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  m_Toolbar_Button_Left.set_active(GTK_STATE_NORMAL);
  m_Toolbar_Button_Right.set_active(GTK_STATE_NORMAL);
  m_Toolbar_Button_Center.set_active(GTK_STATE_ACTIVE);

  if(pSheetCurrent)
  { 
    pSheetCurrent->range_set_justification(pSheetCurrent->get_selected_range(), GTK_JUSTIFY_CENTER);
  }
}

void 
Window_TestSheet::on_Toolbar_BorderCombo_Changed(gint border)
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
   
  GtkSheetRange range = pSheetCurrent->get_selected_range();

  pSheetCurrent->range_set_border(range, 0, 0, 0);

  gint border_mask = 0;
  gint border_width = 3;
  bool bSetBorder = true;
  switch(border)
  {
    case 1:
    {
      border_mask = GTK_SHEET_TOP_BORDER;
      range.rowi = range.row0;
      break;
    }
    case 2:
    {
      gint border_mask = GTK_SHEET_BOTTOM_BORDER;
      range.row0 = range.rowi;
      break;
    }
    case 3:
    {
      border_mask = GTK_SHEET_RIGHT_BORDER; 
      range.col0 = range.coli;
      break;
    }
    case 4:
    {
      border_mask = GTK_SHEET_LEFT_BORDER;
      range.coli = range.col0;
      break;
    }
    case 5:
    {
      if(range.col0 == range.coli)
      {
	      border_mask = GTK_SHEET_LEFT_BORDER | GTK_SHEET_RIGHT_BORDER;
        break;
      }
	  
      border_mask = GTK_SHEET_LEFT_BORDER;
      gint auxcol = range.coli;
      range.coli = range.col0;
      pSheetCurrent->range_set_border(range, border_mask, border_width, 0);
       
      border_mask = GTK_SHEET_RIGHT_BORDER;
      range.col0 = range.coli = auxcol; 
      break;
    }
    case 6:
    {
      if(range.row0 == range.rowi)
      {
	      border_mask = GTK_SHEET_TOP_BORDER | GTK_SHEET_BOTTOM_BORDER;
        break;
      }
	     
      border_mask = GTK_SHEET_TOP_BORDER;
      gint auxrow = range.rowi;
      range.rowi = range.row0;
      pSheetCurrent->range_set_border(range, border_mask, border_width, 0);
       
      border_mask = GTK_SHEET_BOTTOM_BORDER;
      range.row0 = range.rowi = auxrow; 
      break;
    }
    case 7:
    {
      border_mask = GTK_SHEET_RIGHT_BORDER | GTK_SHEET_LEFT_BORDER;
      break;
    }
    case 8:
    {
      border_mask = GTK_SHEET_BOTTOM_BORDER | GTK_SHEET_TOP_BORDER;
      break;
    }
    case 9:
    {
      pSheetCurrent->range_set_border(range, 15, border_width, 0);
      for(int i=range.row0; i<=range.rowi; i++)
      {
        for(int j=range.col0; j<=range.coli; j++)
        {
          border_mask = 15;

          GtkSheetRange auxrange;
          auxrange.row0 = i;
          auxrange.rowi = i;
          auxrange.col0 = j;
          auxrange.coli = j;
          if(i == range.rowi) border_mask ^= GTK_SHEET_BOTTOM_BORDER;
          if(i == range.row0) border_mask ^= GTK_SHEET_TOP_BORDER;
          if(j == range.coli) border_mask ^= GTK_SHEET_RIGHT_BORDER;
          if(j == range.col0) border_mask ^= GTK_SHEET_LEFT_BORDER;

          range = auxrange;
          if(border_mask != 15) pSheetCurrent->range_set_border(auxrange, border_mask, border_width, 0);
        }
      }
      bSetBorder = false; //Already done.

      break;
    }
    case 10:
    {
      for(int i=range.row0; i<=range.rowi; i++)
      {
        for(int j=range.col0; j<=range.coli; j++)
        {
          border_mask = 0;

          GtkSheetRange auxrange;
          auxrange.row0 = i;
          auxrange.rowi = i;
          auxrange.col0 = j;
          auxrange.coli = j;
          if(i == range.rowi) border_mask |= GTK_SHEET_BOTTOM_BORDER;
          if(i == range.row0) border_mask |= GTK_SHEET_TOP_BORDER;
          if(j == range.coli) border_mask |= GTK_SHEET_RIGHT_BORDER;
          if(j == range.col0) border_mask |= GTK_SHEET_LEFT_BORDER;

          if(border_mask != 0) pSheetCurrent->range_set_border(auxrange, border_mask, border_width, 0);
        }
      }
      bSetBorder = false; //Already done.
      
      break;
    }
    case 11:
    {
      border_mask = 15;
      break;
    }
    default:
    {
      bSetBorder = false;
    }
  }

  if(bSetBorder) pSheetCurrent->range_set_border(range, border_mask, border_width, 0);
}

void 
Window_TestSheet::on_Toolbar_ColorCombo_fg(gint i, gchar *color_name)
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
    Gdk_Color color;
    color.parse(std::string(color_name));

    Gdk_Colormap colormap = pSheetCurrent->get_colormap();
    colormap.alloc(color);
  
    pSheetCurrent->range_set_foreground(pSheetCurrent->get_selected_range(), color);

    //Places colored rectangle under the icon in the combo box:
    Gdk_Window gdkWindow = Gdk_Window( GTK_WIDGET(gtkobj())->window );
    Gdk_GC gcTemp(gdkWindow);
    gcTemp.set_foreground(color);

    Gdk_Pixmap gdkPixmap(m_pixmapFont.gtkobj()->pixmap);
    gdkPixmap.draw_rectangle(gcTemp, TRUE, 5, 20, 16, 4);
    m_pixmapFont.queue_draw();
  }
}

void 
Window_TestSheet::on_Toolbar_ColorCombo_bg(gint i, gchar *color_name)
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
    Gdk_Color color;
    color.parse(std::string(color_name));

    Gdk_Colormap colormap = pSheetCurrent->get_colormap();
    colormap.alloc(color);
  
    pSheetCurrent->range_set_background(pSheetCurrent->get_selected_range(), color);

    //Places colored rectangle under the icon in the combo box:
    Gdk_Window gdkWindow = Gdk_Window( GTK_WIDGET(gtkobj())->window );
    Gdk_GC gcTemp(gdkWindow);
    gcTemp.set_foreground(color);

    Gdk_Pixmap gdkPixmap(m_pixmap_bg.gtkobj()->pixmap);
    gdkPixmap.draw_rectangle(gcTemp, TRUE, 4, 20, 18, 4);
    m_pixmap_bg.draw(0);
  }
}

void 
Window_TestSheet::on_Sheet_Entry_Changed()
{
  //Copy text from the cell (in the sheet) to the Entry (at the top).
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
	  Gtk::Entry* pEntrySheet = static_cast<Gtk::Entry*>(pSheetCurrent->get_entry());
	  if(pEntrySheet)
	  {
	    std::string strText = pEntrySheet->get_text();

	    std::string strBefore = m_Entry.get_text();
	    if(strBefore != strText)
	    {
	      m_Entry.set_text(strText);
	    }
	  }
	}
}

gint 
Window_TestSheet::on_Sheet_Activate(gint row, gint column)
{
  //Show cell location in the Label at the top left.
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
	  Gtk::Entry* pEntrySheet = static_cast<Gtk::Entry*>(pSheetCurrent->get_entry());
	  
	  if(pEntrySheet)
	  {   
	    
	    GtkSheetColumn sheetColumn;
	    bool bTest = pSheetCurrent->get_column(column, sheetColumn);
	    
	    std::string strName;
	    if(bTest && sheetColumn.name) strName = sheetColumn.name;

	    gchar pchCell[100];
	    if(strName.size())
	    {
	      sprintf(pchCell, "  %s:%d  ", strName.c_str(), row);
	    }
	    else
	    {
	      sprintf(pchCell, " ROW: %d COLUMN: %d ", row, column);
	    }

		  m_Label_Location.set(std::string(pchCell));

		  //m_Entry.set_max_length(pEntrySheet->get_max_length()); //No such function. GtkExtra example accesses a member variable which is not wrapped in Gtk--.

		  std::string strText = pEntrySheet->get_text(); 
		  m_Entry.set_text(strText);
		 
		  GtkSheetCell cellActive = pSheetCurrent->get_active_cell();
		  GtkSheetCellAttr attributes;
		  pSheetCurrent->get_attributes(cellActive.row, cellActive.col, attributes);

		  m_Entry.set_editable(attributes.is_editable);

		  switch (attributes.justification)
		  {
		    case GTK_JUSTIFY_LEFT:
		      on_Toolbar_Button_Left();
			    break;
		    case GTK_JUSTIFY_CENTER:
		      on_Toolbar_Button_Center();
			    break;
		    case GTK_JUSTIFY_RIGHT:
		      on_Toolbar_Button_Right();
			    break;
		    default:
		      on_Toolbar_Button_Left();
			    break;
		  }
		}
  }

  return TRUE;
}

void
Window_TestSheet::on_Entry_Changed()
{
  //Copy text from the Entry (at the top) to the cell (in the sheet).
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
	  std::string strText = m_Entry.get_text();
	 
	  Gtk::Entry* pEntrySheet = static_cast<Gtk::Entry*>(pSheetCurrent->get_entry());
    if(pEntrySheet)
    {
	    std::string strBefore = pEntrySheet->get_text();
	    if(strText != strBefore) pEntrySheet->set_text(strText);
	  }
  } 
}

void 
Window_TestSheet::on_Entry_Activate()
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
    gint row = 0;
    gint col = 0;
    pSheetCurrent->get_active_cell(row, col);

    Gtk::Widget* pEntryWidget = (pSheetCurrent->get_entry());
    if(pEntryWidget)
    {
      if(pEntryWidget->get_type() == GtkExtra::ItemEntry::get_type())
      {
        GtkExtra::ItemEntry* pItemEntry = static_cast<GtkExtra::ItemEntry*>(pEntryWidget);
		   
		    std::string strText = pItemEntry->get_text();
		    std::string strBefore = pSheetCurrent->get_cell_text(row, col);
		    if(strText != strBefore)
		    {
		      //GtkJustification justification = GTK_JUSTIFY_LEFT;
		      //if(GTK_IS_IENTRY(sheet_entry)) justification = GTK_IENTRY(sheet_entry)->justification;
		      GtkJustification justification = pItemEntry->get_justification(); //Preserves existing justification.
		      
		      pSheetCurrent->cause_set_cell(row, col, justification, strText);
		    }
		  }
    }
  }
}

void 
Window_TestSheet::on_Button_Show() 
{
  Gtk::Curve* pCurve = new Gtk::Curve();
  pCurve->set_range(0, 200, 0, 200);
  pCurve->show();
  m_ppSheets[0]->attach(pCurve, 2, 7, 0., 0.);
}

gint
Window_TestSheet::on_Sheet_key_press_event_Clipboard(GdkEventKey *key)
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
	  if(key->state & GDK_CONTROL_MASK || 
	     key->keyval == GDK_Control_L ||
	     key->keyval == GDK_Control_R)
	  {
	    if((key->keyval == 'c' || key->keyval == 'C') && pSheetCurrent->get_state() != GTK_STATE_NORMAL)
	    {
	      if(pSheetCurrent->get_in_clip())
	        pSheetCurrent->unclip_range();
	      
	      pSheetCurrent->cause_clip_range(pSheetCurrent->get_selected_range());
	    }
	    
	    if(key->keyval == 'x' || key->keyval == 'X')
	      pSheetCurrent->unclip_range();    
	  }
	}

	return TRUE;
}

void
Window_TestSheet::on_Toolbar_FontCombo_Changed()
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();
  if(pSheetCurrent)
  {
    pSheetCurrent->range_set_font( pSheetCurrent->get_selected_range(), m_Toolbar_FontCombo.get_font() );
	}
}

gboolean
Window_TestSheet::on_Sheet3_traverse(gint row, gint col, gint *new_row, gint *new_col)
{
  GtkExtra::Sheet* pSheetCurrent = Get_CurrentSheet();

  if(pSheetCurrent)
  {
    GtkType typeWidget =  0;
    
	  if(*new_col == 0 && col != 0) typeWidget = gtk_combo_get_type();

	  if(*new_col == 1 && col != 1) typeWidget = GTK_TYPE_ENTRY;

	  if(*new_col == 2 && col != 2) typeWidget = GTK_TYPE_SPIN_BUTTON;

	  if(*new_col >= 3 && col < 3) typeWidget =  GTK_TYPE_ITEM_ENTRY;

    if(typeWidget)
    {
	     pSheetCurrent->change_entry(typeWidget);
	  }
  }
 

	return true;
}
