#ifndef THEME_H
#define THEME_H

#include <gtk/gtk.h>
#include <gmodule.h>

/* Default stuff */

#define DEFAULT_SLIDER_WIDTH      11
#define DEFAULT_MIN_SLIDER_SIZE   9


enum {
  TOKEN_BACKGROUND = G_TOKEN_LAST + 1,
  TOKEN_GRADIENT,
  TOKEN_QUADRATIC_GRADIENT,
  TOKEN_DIAGONAL_GRADIENT,
  TOKEN_EDGE_GRADIENT,
  TOKEN_CORNER_GRADIENT,
  TOKEN_CLEAN,
  TOKEN_NORTH_EAST,
  TOKEN_NORTH_WEST,
  TOKEN_SOUTH_EAST,
  TOKEN_SOUTH_WEST,
  TOKEN_HORIZONTAL,
  TOKEN_VERTICAL,
  TOKEN_AUTOMATIC,
  TOKEN_DECORATION,
  TOKEN_SLASH,
  TOKEN_BACK_SLASH,
  TOKEN_DOUBLE_SLASH,
  TOKEN_DOT,
  TOKEN_NAME,
  TOKEN_DETAIL,
  TOKEN_EDGE_SIZE,
  TOKEN_CORNER_SIZE,
  TOKEN_NONE
};

typedef enum {
  NO_BACKGROUND,
  GRADIENT,
  QUADRATIC_GRADIENT,
  EDGE_GRADIENT,
  CORNER_GRADIENT,
  DIAGONAL_GRADIENT,
  CLEAN,
  PIXMAP
} background_style;

typedef enum {
  NO_DECORATION,
  SLASH,
  BACK_SLASH,
  DOUBLE_SLASH,
  DOT,
  NONE
} decoration_style;

typedef enum {
  NO_DIAGONAL_ASPECT,
  NORTH_EAST,
  NORTH_WEST,
  SOUTH_EAST,
  SOUTH_WEST
} diagonal_aspect_style;

typedef enum {
  NO_ASPECT,
  VERTICAL,
  HORIZONTAL,
  AUTOMATIC
} aspect_style;


typedef struct {
  guint refcount;
  GHashTable *detail_list;
} ThemeData;

typedef struct {
  guint refcount;
  char *detail_name;

  background_style background;
  decoration_style decoration;
  diagonal_aspect_style diagonal_aspect;
  aspect_style aspect;
  guint edge_size;
  guint corner_size;
} Detail;


#endif /* THEME_H */
