/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_CONNECTION_H)
#define __INC_PG_CONNECTION_H


#include "driver.h"

#include <mysql/mysql.h>

#include "gql++/connection.h"

namespace GQL
{

class ResultSet;

namespace MySQL
{

class MyDatabaseMetaData;

class MyConnection : public Connection
{
  public:
    MyConnection(const std::string& host,
                 const std::string& port,
                 const std::map<std::string, std::string>& props,
                 const std::string& db,
                 const std::string& url,
                 MyDriver *driver);
    virtual ~MyConnection();

    // Methods inherited from Connection
    virtual Statement *create_statement();
    virtual PreparedStatement *prepare_statement(const std::string& sql);
    virtual CallableStatement *prepare_call(const std::string& sql);

    virtual void commit();
    virtual bool get_auto_commit() const { return(auto_commit_); }
    virtual void set_auto_commit(bool auto_commit = true);
    virtual void rollback();
    virtual std::string get_catalog() const;
    
    virtual std::string native_sql(const std::string& sql) const;
    
    virtual DatabaseMetaData *get_meta_data();

    virtual void set_read_only(bool read_only = true) {
      read_only_ = read_only;
    }
    virtual bool is_read_only() const {
      return(read_only_);
    }

    // Additional methods
    MYSQL_RES *exec_sql(const std::string& sql);
    MYSQL *mysql_connection() { return(conn_); }
  private:
    MyDriver *driver_;
    MYSQL *conn_;
    std::string url_;
    std::string database_;
    std::string port_;
    std::string host_;
    bool read_only_;
    bool auto_commit_;
    MyDatabaseMetaData *metadata_;
};


}
}

#endif
