/* $Id: userbox.h,v 1.5 2000/10/03 03:35:21 bergo Exp $ */

#ifndef USERBOX_H
#define USERBOX_H

#include "polling.h"

void pop_user_box(GtkWidget *gw,gpointer data);
void close_user_box(GtkWidget *w, gpointer data);
void destroy_user_box(GtkWidget *w,gpointer data);

gboolean ubox_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean ubox_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean ubox_bpress_event(GtkWidget *widget,GdkEventButton *be,
			    gpointer data);
gboolean ubox_motion_event(GtkWidget *widget,GdkEventMotion *gem,
			   gpointer data);

gint refresh_ubox(gpointer data);

gint ubox_cpu_cmp(const gpointer a,const gpointer b);
gint ubox_mem_cmp(const gpointer a,const gpointer b);
gint ubox_cpu_cmp_gr(const gpointer a,const gpointer b);
gint ubox_mem_cmp_gr(const gpointer a,const gpointer b);

long gps_memvalue(char *s);
void ubox_reset_lists();
void ubox_reset_links();

void query_group(char *dest,char *user,int maxc);

float ubox_cpu_fraction(float value);
float ubox_mem_fraction(long value);

///
class UserBoxCpuTuple {
 public:
  char username[GPS_MAXOWNER];
  char groupname[64];
  float cpuusage;
};

///
class UserBoxMemTuple {
 public:
  char username[GPS_MAXOWNER];
  char groupname[64];
  long membytes;
};

///
class UserLink {
 public:
  char username[GPS_MAXOWNER];
  int x,y,w,h;

  int hit(int a,int b);
};

#endif
