/*
**  POP3View.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "POP3View.h"

#include "Constants.h"
#include "LabelWidget.h"


//
//
//
@implementation POP3View

- (void) dealloc
{
  NSDebugLog(@"POP3View: -dealloc");

  RELEASE(pop3LeaveOnServer);
  RELEASE(pop3DaysField);
  RELEASE(pop3UseAPOP);

  [super dealloc];
}


//
//
//
- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}


//
//
//
- (void) layoutView
 {
  LabelWidget *label;

  self = [super init];
  
  [self setFrame: NSMakeRect(0,0,400,360)];
  [self setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  pop3LeaveOnServer = [[NSButton alloc] initWithFrame: NSMakeRect(10,290,210,ButtonHeight)];
  [pop3LeaveOnServer setButtonType: NSSwitchButton];
  [pop3LeaveOnServer setBordered: NO];
  [pop3LeaveOnServer setTitle: _(@"Leave messages on server for")];
  [pop3LeaveOnServer setAutoresizingMask: NSViewMinYMargin];
  [self addSubview: pop3LeaveOnServer];

  pop3DaysField = [[NSTextField alloc] initWithFrame: NSMakeRect(225,293,40,TextFieldHeight)];
  [pop3DaysField setAutoresizingMask: NSViewMinYMargin];
  [self addSubview: pop3DaysField];
  
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(275,293,50,TextFieldHeight)
		       label: _(@"days")];
  [label setAutoresizingMask: NSViewMinYMargin];
  [self addSubview: label];
  

  pop3UseAPOP = [[NSButton alloc] initWithFrame: NSMakeRect(10,260,380,ButtonHeight)];
  [pop3UseAPOP setButtonType: NSSwitchButton];
  [pop3UseAPOP setBordered: NO];
  [pop3UseAPOP setTitle: _(@"Use Authenticated Post Office Protocol (APOP) if possible")];
  [pop3UseAPOP setAutoresizingMask: NSViewMinYMargin];
  [self addSubview: pop3UseAPOP];


  //
  // We set the next key views
  //
  [pop3LeaveOnServer setNextKeyView: pop3DaysField];
  [pop3DaysField setNextKeyView: pop3UseAPOP];
  [pop3UseAPOP setNextKeyView: pop3LeaveOnServer];
}

@end
