# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# $Id: html.py 6707 2004-11-22 12:27:30Z btami $
#
# DESCRIPTION:
# Transforms adapter for direct
#
# NOTES:
#

class DirectFormatter:

  def __init__(self, destination, stylesheet, options={}):
    self.dest = destination
    self.options = options

    self._reporttitle = u''
    self._sectiontitle = u''
    self.stylesheet = stylesheet

    try:
      self.encoding = options['encoding']
    except:
      self.encoding = gConfig('textEncoding')

  def writeout(self, text):
    self.dest.write(text.encode(self.encoding,'replace'))

  def BeginReport(self):
    try:
      css = open(self.stylesheet,'r')
      style = ''.join(css.readlines())
    except:
      print "Error processing css file: %s" % self.stylesheet
      css = None
      style = STYLE

    if css:
      css.close()

    self.writeout('<html>\n')
    self.writeout('  <head>\n')
    self.writeout('    <meta http-equiv="Content-Type" content="text/html; charset=%s"/>\n' % self.encoding)
    self.writeout('    <style>\n%s    </style>\n' % style)
    self.writeout('  </head>\n')
    self.writeout('  <body>\n')

  def EndReport(self):
    self.writeout('  </body>\n')
    self.writeout('</html>')

  def BeginReportTitle(self):
    pass

  def EndReportTitle(self, reporttitle):
    self._reporttitle = reporttitle
    self.writeout('  <h1>%s</h1>\n<hr>\n' % self._reporttitle)

  def BeginSection(self):
    pass

  def EndSection(self):
    pass

  def BeginSectionTitle(self):
    pass

  def EndSectionTitle(self, sectiontitle):
    self._sectiontitle = sectiontitle
    self.writeout('  <h2>%s</h2>\n' % self._sectiontitle)

  def BeginTable(self):
    self._odd = 1
    self.writeout('    <table>\n')

  def EndTable(self):
    self.writeout('    </table>\n')

  def BeginTableHead(self):
    self._colalign = []
    self.writeout('      <tr>\n')

  def EndTableHead(self):
    self.writeout('      </tr>\n')

  def BeginColHead(self):
    self.writeout('        <th ')

  def EndColHead(self, colhead, width, alignment=None):
    self._colalign.append(alignment)
    self.writeout('align="%s">%s</th>\n' % (alignment,
                                              colhead))

  def BeginRow(self, rowtype=None):
    self._rowtype = rowtype
    if self._rowtype == 'subtotal':
      self.writeout('      <tr class="subtotal">\n')
    else:
      if self._odd:
        self.writeout('      <tr class="odditem">\n')
      else:
        self.writeout('      <tr class="item">\n')

  def EndRow(self, rowtype=None):
    self._odd = not self._odd
    self.writeout('      </tr>\n')

  def BeginCol(self):
    if self._rowtype == 'subtotal':
      self.writeout('        <td class="subtotal" ')
    else:
      self.writeout('        <td class="item" ')

  def EndCol(self, col, index):
    self.writeout('align="%s">%s</td>\n' % (self._colalign[index],col))


STYLE = """body {
  font-face: sans-serif;
}
table {
  width: 80%;
  margin-left: 10%;
  margin-right: 10%;
  border-spacing: 0;
  border-collapse: collapse;
}
tr.odditem {
  padding: 0.5em;
  background : lightgrey;
  color : black;
}
tr.subtotal {
  font-weight : bold;
}
td {
  padding: 0.5em;
}
td.item {
  padding: 0.5em;
}
td.subtotal {
  padding: 0.5em;
  border-style: solid;
  border-width: medium;
  border-color: black;
  border-left: 0;
  border-right: 0;
}
th {
  padding: 0.5em;
  border-style: solid;
  border-width: thin;
  border-color: black;
  background : black;
  color : white;
}
h1 {
  text-align: center;
}
h2 {
  margin-left: 5%;
  margin-right: 5%;
  text-align: left;
}
hr {
  margin-left: 5%;
  margin-right: 5%;
}
"""


