//  Gnomoradio - roboradio/xspf.cc
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "xspf.h"

#include <iostream>

using namespace Roboradio;
using namespace Glib;
using namespace std;

static void set_info_if_necessary (SongRef &s, const ustring &key,
				   const ustring &value)
{
	if (s->get_info(key) == "")
		s->set_info(key, value);
}

bool Roboradio::XSPF::import_list (xmlpp::Document &document)
{
	SongListMutable *list = new SongListMutable("XSPF Import");

	xmlpp::Node *root = document.get_root_node();
	if (!root || root->get_name() != "playlist")
		return false;
	xmlpp::Element *root_el = dynamic_cast<xmlpp::Element*>(root);
	if (!root_el)
		return false;
	xmlpp::Attribute *spec_version = root_el->get_attribute("version");
	if (!spec_version || spec_version->get_value() != "0")
		return false;

	xmlpp::Node::NodeList headings = root->get_children();
	for (xmlpp::Node::NodeList::iterator heading = headings.begin();
	     heading != headings.end(); ++heading) {

		if ((*heading)->get_name() == "title") {
			xmlpp::Element *el = dynamic_cast<xmlpp::Element*>(*heading);
			if (!el)
				continue;
			xmlpp::TextNode *tn = el->get_child_text();
			if (tn)
				list->set_name(tn->get_content());
		} else if ((*heading)->get_name() == "trackList") {
			xmlpp::Node::NodeList tracks = (*heading)->get_children();
			for (xmlpp::Node::NodeList::iterator track = tracks.begin();
			     track != tracks.end(); ++track) {
				ustring location, annotation, info, image;

				xmlpp::Node::NodeList track_info = (*track)->get_children();
				for (xmlpp::Node::NodeList::iterator ti = track_info.begin();
				     ti != track_info.end(); ++ti) {
					xmlpp::Element *el = dynamic_cast<xmlpp::Element*>(*ti);
					if (!el)
						continue;
					xmlpp::TextNode *txt = el->get_child_text();
					if (!txt)
						continue;
					ustring t = txt->get_content();
					if (el->get_name() == "location")
						location = t;
					else if (el->get_name() == "annotation")
						annotation = t;
					else if (el->get_name() == "info")
						info = t;
					else if (el->get_name() == "image")
						image = t;
				}

				if (location == "")
					continue;

				SongRef s(location, false);
				if (&*s == 0)
					continue;

				// fixme: set these infos only if they are missing

				set_info_if_necessary(s, "title", annotation);
				set_info_if_necessary(s, "retail", info); // isn't always retail, but whatever
				set_info_if_necessary(s, "coverart", image);

				list->push_back(s);
			}
		}
	}

	return true;
}

void Roboradio::XSPF::export_list (ref_ptr<SongList> &list,
				   xmlpp::Document &document)
{
}

void Roboradio::XSPF::import_list (const Glib::ustring &url)
{
	if (url.size() == 0)
		return;

	if (url[0] == '/') {
		xmlpp::DomParser tree(url);
		import_list(*tree.get_document());
	} else if (url.substr(0, 7) == "http://") {

	}
}

void Roboradio::XSPF::export_list (const Glib::ustring &filename)
{

}
