// -*- c++ -*-

//  Gnomoradio - roboradio/audio/audio.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_AUDIO_AUDIO_H
#define __ROBORADIO_AUDIO_AUDIO_H

#include <sigc++/sigc++.h>
#include <glibmm.h>
#include <map>

namespace Roboradio
{
	namespace Audio
	{
		class Audio : public sigc::trackable
		{
		public:
			static Audio *create (const Glib::ustring &filename);
			
			virtual ~Audio ();
			
			virtual void play () = 0;
			virtual void stop () = 0;
			virtual void pause () = 0;
			virtual void unpause () = 0;
			
			virtual void seek (unsigned int pos) = 0;
			virtual int get_position () = 0;
			
			virtual std::map<Glib::ustring,Glib::ustring> get_info (unsigned int &length) = 0;
			
			sigc::signal<void,unsigned int> signal_position_changed;
			sigc::signal<void> signal_done;
		};
	}
}

#endif
