// -*- c++ -*-

//  Gnomoradio - gnomoradio/conf.h
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __CONF_H
#define __CONF_H

#include <string>

#ifdef USE_GCONF
#include <gconfmm.h>
#endif

namespace Gnomoradio
{
	class Conf
	{
	public:
		static void init ();
		static int get_int (const std::string &key);
		static void set (const std::string &key, int value);

	private:
		static void initialize ();

#ifdef USE_GCONF
		static Glib::RefPtr<Gnome::Conf::Client> conf;
#endif
	};
};

#endif
