/***************************************************************************
 *            main.c
 *
 *  Mon May 10 20:28:59 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome-ppp.h"


int main (int argc, char *argv[])
{
	gnome_ppp.app = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			argc, argv, GNOME_PARAM_APP_DATADIR,
			PACKAGE_DATA_DIR, NULL);
	
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	
	/* wvdial process */
	wvdial.cmd[0] = NULL;
	wvdial.out_pipe = 0;
	wvdial.err_pipe = 0;
	wvdial.in_pipe = 0;
	wvdial.pid = 0;
	wvdial.error = NULL;
	wvdial.out_tag = 0;
	wvdial.err_tag = 0;
	wvdial.out = NULL;
	wvdial.err = NULL;
	/* wvdialconf process */
	wvdialconf.cmd[0] = NULL;
	wvdialconf.out_pipe = 0;
	wvdialconf.err_pipe = 0;
	wvdialconf.in_pipe = 0;
	wvdialconf.pid = 0;
	wvdialconf.error = NULL;
	wvdialconf.out_tag = 0;
	wvdialconf.err_tag = 0;
	wvdialconf.out = NULL;
	wvdialconf.err = NULL;
	/* glade xml */
	gnome_ppp.xml = NULL;		
	/* gnome ppp window */
	gnome_ppp.gnome_ppp.window = NULL;
	gnome_ppp.gnome_ppp.username = NULL;
	gnome_ppp.gnome_ppp.password = NULL;
	gnome_ppp.gnome_ppp.store_pwd = NULL;
	gnome_ppp.gnome_ppp.phone = NULL;
	/* setup window */
	/* modem */
	gnome_ppp.setup.window = NULL;
	gnome_ppp.setup.device = NULL;
	gnome_ppp.setup.speed = NULL;
	gnome_ppp.setup.type = NULL;
	gnome_ppp.setup.tone = NULL;
	gnome_ppp.setup.pulse = NULL;
	gnome_ppp.setup.volume = NULL;
	gnome_ppp.setup.phone_nums = NULL;
	gnome_ppp.setup.init_strs = NULL;
	gnome_ppp.setup.dial_prefix = NULL;
	gnome_ppp.setup.spin_dial_attempts = NULL;
	gnome_ppp.setup.label_dial_attempts = NULL;
	gnome_ppp.setup.dial_tone = NULL;
	/* networking */
	gnome_ppp.setup.static_ip = NULL;
	gnome_ppp.setup.dynamic_ip = NULL;
	gnome_ppp.setup.label_ip = NULL;
	gnome_ppp.setup.entry_ip = NULL;
	gnome_ppp.setup.domain = NULL;
	gnome_ppp.setup.auto_dns = NULL;
	gnome_ppp.setup.manual_dns = NULL;
	gnome_ppp.setup.list_dns = NULL;
	/* options */
	gnome_ppp.setup.minimize = NULL;
	gnome_ppp.setup.dock = NULL;
	gnome_ppp.setup.auto_reconnect = NULL;
	gnome_ppp.setup.abort_on_busy = NULL;
	gnome_ppp.setup.abort_on_no_dialtone = NULL;
	gnome_ppp.setup.check_carrier = NULL;
	gnome_ppp.setup.check_def_route = NULL;
	gnome_ppp.setup.stupid_mode = NULL;
	gnome_ppp.setup.custom_reply = NULL;
	gnome_ppp.setup.label_reply = NULL;
	gnome_ppp.setup.entry_reply = NULL;
	gnome_ppp.setup.spin_idle = NULL;
	gnome_ppp.setup.label_idle = NULL;
	/* connecting window */
	gnome_ppp.connecting.window = NULL;
	gnome_ppp.connecting.msgs = NULL;
	/* log window */
	gnome_ppp.log.window = NULL;
	gnome_ppp.log.text_log = NULL;
	/* connected window */
	gnome_ppp.connected.window = NULL;
	gnome_ppp.connected.time = NULL;
	/* details window */
	gnome_ppp.details.window = NULL;
	gnome_ppp.details.interface = NULL;
	gnome_ppp.details.status = NULL;
	gnome_ppp.details.speed_in = NULL;
	gnome_ppp.details.speed_out = NULL;
	gnome_ppp.details.ip = NULL;
	gnome_ppp.details.destination = NULL;
	gnome_ppp.details.sent = NULL;
	gnome_ppp.details.received = NULL;
	gnome_ppp.details.sent_packets = NULL;
	gnome_ppp.details.received_packets = NULL;
	/* detect window */
	gnome_ppp.detect = NULL;
	/* notification */
	gnome_ppp.notification.tray = NULL;
	gnome_ppp.notification.box = NULL;
	gnome_ppp.notification.pixmap = NULL;
	gnome_ppp.notification.menu = NULL;
	/* about window */
	gnome_ppp.about = NULL;
	/* phone list window */
	gnome_ppp.phone.window = NULL;
	gnome_ppp.phone.phone_nums = NULL;
	/* init strins list window */
	gnome_ppp.init_strs.window = NULL;
	gnome_ppp.init_strs.init_strs = NULL;
	/* variables */
	gnome_ppp.connected.seconds = 0;
	gnome_ppp.connected.update = FALSE;
	gnome_ppp.connected.old_bytes_in = 0;
	gnome_ppp.connected.old_bytes_out = 0;
	gnome_ppp.connected.show = TRUE;
	gnome_ppp.dock = FALSE;
	/* icon factory */
	gnome_ppp.icon_factory = NULL;
		
	gchar *xml;
	/* load glade xml */
	xml = g_build_filename (PACKAGE_DATA_DIR, "glade", "gnome-ppp.glade", NULL);
	/* init glade */
	gnome_ppp.xml = glade_xml_new (xml, NULL, NULL);
	g_free (xml);
	/* app icon path variable */
	gchar *icon;
	icon = g_build_filename(PACKAGE_APPICON_DIR, "gnome-ppp.png", NULL);
	
	/* autoconnect callbacks */
	glade_xml_signal_autoconnect (gnome_ppp.xml);
	/* gnome ppp window */
	gnome_ppp.gnome_ppp.window = glade_xml_get_widget (gnome_ppp.xml, "gnome_ppp");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.gnome_ppp.window), icon, NULL);
	gnome_ppp.gnome_ppp.username = glade_xml_get_widget (gnome_ppp.xml, "username");
	gnome_ppp.gnome_ppp.password = glade_xml_get_widget (gnome_ppp.xml, "password");
	gnome_ppp.gnome_ppp.store_pwd = glade_xml_get_widget (gnome_ppp.xml, "store_pwd");
	gnome_ppp.gnome_ppp.phone = glade_xml_get_widget (gnome_ppp.xml, "phone");
	/* when enter is pressed in phone combo, activate default button (`connect`) */
	gtk_entry_set_activates_default (GTK_ENTRY (GTK_BIN (gnome_ppp.gnome_ppp.phone)->child), TRUE);
	/* setup window */
	/* modem tab */
	gnome_ppp.setup.window = glade_xml_get_widget (gnome_ppp.xml, "setup");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.setup.window), icon, NULL);
	gnome_ppp.setup.device = glade_xml_get_widget (gnome_ppp.xml, "device");
	gnome_ppp.setup.type = glade_xml_get_widget (gnome_ppp.xml, "type");
	gnome_ppp.setup.speed = glade_xml_get_widget (gnome_ppp.xml, "speed");
	gnome_ppp.setup.tone = glade_xml_get_widget (gnome_ppp.xml, "tone");
	gnome_ppp.setup.pulse = glade_xml_get_widget (gnome_ppp.xml, "pulse");
	gnome_ppp.setup.volume = glade_xml_get_widget (gnome_ppp.xml, "volume");
	gnome_ppp.setup.phone_nums = glade_xml_get_widget (gnome_ppp.xml, "phone_nums");
	gnome_ppp.setup.init_strs = glade_xml_get_widget (gnome_ppp.xml, "init_strs");
	gnome_ppp.setup.dial_prefix = glade_xml_get_widget (gnome_ppp.xml, "dial_prefix");
	gnome_ppp.setup.spin_dial_attempts = glade_xml_get_widget (gnome_ppp.xml, "spin_dial_attempts");
	gnome_ppp.setup.label_dial_attempts = glade_xml_get_widget (gnome_ppp.xml, "label_dial_attempts");
	gnome_ppp.setup.dial_tone = glade_xml_get_widget (gnome_ppp.xml, "dial_tone");
	/* networking tab */
	gnome_ppp.setup.static_ip = glade_xml_get_widget (gnome_ppp.xml, "static_ip");
	gnome_ppp.setup.dynamic_ip = glade_xml_get_widget (gnome_ppp.xml, "dynamic_ip");
	gnome_ppp.setup.label_ip = glade_xml_get_widget (gnome_ppp.xml, "label_ip");
	gnome_ppp.setup.entry_ip = glade_xml_get_widget (gnome_ppp.xml, "entry_ip");
	gnome_ppp.setup.domain = glade_xml_get_widget (gnome_ppp.xml, "domain");
	gnome_ppp.setup.auto_dns = glade_xml_get_widget (gnome_ppp.xml, "auto_dns");
	gnome_ppp.setup.manual_dns = glade_xml_get_widget (gnome_ppp.xml, "manual_dns");
	gnome_ppp.setup.list_dns = glade_xml_get_widget (gnome_ppp.xml, "list_dns");
	/* options tab */
	gnome_ppp.setup.minimize = glade_xml_get_widget (gnome_ppp.xml, "minimize");
	gnome_ppp.setup.dock = glade_xml_get_widget (gnome_ppp.xml, "dock");
	gnome_ppp.setup.auto_reconnect = glade_xml_get_widget (gnome_ppp.xml, "auto_reconnect");
	gnome_ppp.setup.abort_on_busy = glade_xml_get_widget (gnome_ppp.xml, "abort_on_busy");
	gnome_ppp.setup.abort_on_no_dialtone = glade_xml_get_widget (gnome_ppp.xml, "abort_on_no_dialtone");
	gnome_ppp.setup.check_carrier = glade_xml_get_widget (gnome_ppp.xml, "check_carrier");
	gnome_ppp.setup.check_def_route = glade_xml_get_widget (gnome_ppp.xml, "check_def_route");
	gnome_ppp.setup.stupid_mode = glade_xml_get_widget (gnome_ppp.xml, "stupid_mode");
	gnome_ppp.setup.custom_reply = glade_xml_get_widget (gnome_ppp.xml, "custom_reply");
	gnome_ppp.setup.label_reply = glade_xml_get_widget (gnome_ppp.xml, "label_reply");
	gnome_ppp.setup.entry_reply = glade_xml_get_widget (gnome_ppp.xml, "entry_reply");
	gnome_ppp.setup.spin_idle = glade_xml_get_widget (gnome_ppp.xml, "spin_idle");
	gnome_ppp.setup.label_idle = glade_xml_get_widget (gnome_ppp.xml, "label_idle");
	/* connecting window */
	gnome_ppp.connecting.window = glade_xml_get_widget (gnome_ppp.xml, "connecting");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.connecting.window), icon, NULL);
	gnome_ppp.connecting.msgs = glade_xml_get_widget (gnome_ppp.xml, "msgs");
	/* log window */
	gnome_ppp.log.window = glade_xml_get_widget (gnome_ppp.xml, "log");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.log.window), icon, NULL);
	gnome_ppp.log.text_log = glade_xml_get_widget (gnome_ppp.xml, "text_log");
	/* connected window */
	gnome_ppp.connected.window = glade_xml_get_widget (gnome_ppp.xml, "connected");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.connected.window), icon, NULL);
	gnome_ppp.connected.time = glade_xml_get_widget (gnome_ppp.xml, "time");
	/* details window */
	gnome_ppp.details.window = glade_xml_get_widget (gnome_ppp.xml, "details");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.details.window), icon, NULL);
	gnome_ppp.details.interface = glade_xml_get_widget (gnome_ppp.xml, "interface");
	gnome_ppp.details.status = glade_xml_get_widget (gnome_ppp.xml, "status");
	gnome_ppp.details.speed_in = glade_xml_get_widget (gnome_ppp.xml, "speed_in");
	gnome_ppp.details.speed_out = glade_xml_get_widget (gnome_ppp.xml, "speed_out");
	gnome_ppp.details.ip = glade_xml_get_widget (gnome_ppp.xml, "ip");
	gnome_ppp.details.destination = glade_xml_get_widget (gnome_ppp.xml, "destination");
	gnome_ppp.details.sent = glade_xml_get_widget (gnome_ppp.xml, "sent");
	gnome_ppp.details.received = glade_xml_get_widget (gnome_ppp.xml, "received");
	gnome_ppp.details.sent_packets = glade_xml_get_widget (gnome_ppp.xml, "sent_packets");
	gnome_ppp.details.received_packets = glade_xml_get_widget (gnome_ppp.xml, "received_packets");
	/* phone list window */
	gnome_ppp.phone.window = glade_xml_get_widget (gnome_ppp.xml, "phones");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.phone.window), icon, NULL);
	gnome_ppp.phone.phone_nums = glade_xml_get_widget (gnome_ppp.xml, "phone_nums");
	/* init strins list window */
	gnome_ppp.init_strs.window = glade_xml_get_widget (gnome_ppp.xml, "init_strings");
	gtk_window_set_icon_from_file (GTK_WINDOW (gnome_ppp.phone.window), icon, NULL);
	gnome_ppp.init_strs.init_strs = glade_xml_get_widget (gnome_ppp.xml, "init_strs");
			
	/* free app icon path variable */
	g_free (icon);
	
	/* read ~/.wvdial.conf */
	read_conf ();
	
	/* show main window */
	gtk_widget_show (gnome_ppp.gnome_ppp.window);
	
	gtk_main ();
	
	return 0;
}
