/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dlgrecord.c,v 1.7 2001/03/25 20:10:49 dengen Exp $
 *
 */

#include <gtk/gtk.h>
#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include "gnoise.h"
#include "gtklevels.h"
#include "oss.h"

static void on_dlgrecord_browse_ok(GtkWidget *w, GtkFileSelection *fs);
static GtkWidget	*fs = NULL;
static GtkWidget	*win_record = NULL;
static record_info_t	rec_info;

gboolean dlgrecord(char *filename)
{
    char             widget_name[80];
    GtkToggleButton *tb;

    if (win_record != NULL)
	return FALSE;

    memset(&rec_info, 0, sizeof(rec_info));
    win_record = create_RecordDialog();

    /* set recording defaults */
    sprintf(widget_name, "_%dRButton", (int)prefs.record.sample_rate);
    tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, widget_name));
    gtk_toggle_button_set_active(tb, TRUE);

    sprintf(widget_name, "_%dBitRButton", (int)prefs.record.sample_bits);
    tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, widget_name));
    gtk_toggle_button_set_active(tb, TRUE);

    if (prefs.record.channels == 1)
	tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, "MonoRButton"));
    else
	tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, "StereoRButton"));
    gtk_toggle_button_set_active(tb, TRUE);

    gtk_widget_show(win_record);
    gtk_main();
    if (rec_info.file[0] != '\0')
    {
	strcpy(filename, rec_info.file);
	return TRUE;
    }
    return FALSE;
}

static gboolean on_dlgrecord_browse_destroy(GtkWidget *w)
{
    fs = NULL;
    gtk_main_quit();
    return FALSE;
}

void on_dlgrecord_browse(GtkButton *button, gpointer user_data)
{
    if (!fs)
    {
	fs = gtk_file_selection_new("Record WAV file");
	gtk_window_set_modal(GTK_WINDOW(fs), TRUE);
	gtk_signal_connect(GTK_OBJECT(fs), "destroy", GTK_SIGNAL_FUNC(on_dlgrecord_browse_destroy), &fs);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->ok_button), "clicked", GTK_SIGNAL_FUNC(on_dlgrecord_browse_ok), fs);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(fs));
    }

    if (!GTK_WIDGET_VISIBLE(fs))
	gtk_widget_show(fs);
    gtk_main();
}

static void on_dlgrecord_browse_ok(GtkWidget *w, GtkFileSelection *fs)
{
    GtkEntry			*file;

    file = GTK_ENTRY(lookup_widget(win_record, "Filename"));
    gtk_entry_set_text(file, gtk_file_selection_get_filename(fs));
    gtk_widget_destroy(GTK_WIDGET(fs));
}

void on_dlgrecord_record(GtkButton *button, gpointer user_data)
{
    gint			i;
    gint			bit[] = {8, 16};
    gint			rate[] = {8000, 11025, 22050, 44100};
    gchar			widget_name[80];
    GtkToggleButton		*tb;
    GtkEntry			*file;

    if (recording)
    {
	log("RECORD", "Already recording!\n");
	return;
    }

    /* determine sample rate */
    for(i=0; i < sizeof(rate)/sizeof(rate[0]); i++)
    {
	sprintf(widget_name, "_%dRButton", rate[i]);
	tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, widget_name));
	if (tb && tb->active)
	    break;
    }
    rec_info.si.sample_rate = rate[i];

    /* determine bits */
    for(i=0; i < sizeof(bit)/sizeof(bit[0]); i++)
    {
	sprintf(widget_name, "_%dBitRButton", bit[i]);
	tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, widget_name));
	if (tb && tb->active)
	    break;
    }
    rec_info.si.sample_bits = bit[i];

    /* determine channels */
    tb = GTK_TOGGLE_BUTTON(lookup_widget(win_record, "MonoRButton"));
    if (tb && tb->active)
	rec_info.si.channels = 1;
    else
	rec_info.si.channels = 2;

    file = GTK_ENTRY(lookup_widget(win_record, "Filename"));
    strcpy(rec_info.file, gtk_entry_get_text(file));

    log("RECORD", "%s %d Hz, %d bits %d channels\n", g_basename(rec_info.file),
	rec_info.si.sample_rate, rec_info.si.sample_bits,
	rec_info.si.channels);
    status("Recording %s %dHz %dbits to %s",
	    rec_info.si.channels == 1 ? "Mono" : "Stereo",
	    rec_info.si.sample_rate, rec_info.si.sample_bits,
	    g_basename(rec_info.file));

    /* start the recording thread */
    pthread_create(&record_thread, NULL, oss_record, (void *)&rec_info);
}

void dlgrecord_stop_recording(void)
{
    recording_stop = TRUE;
    lpeak = 0;
    rpeak = 0;
}

void on_dlgrecord_stop(GtkButton *button, gpointer user_data)
{
    dlgrecord_stop_recording();
    dlgrecord_update_levels();
}

gboolean on_dlgrecord_destroy(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    dlgrecord_stop_recording();
    win_record = NULL;
    gtk_main_quit();
    return FALSE;
}

void on_dlgrecord_close(GtkButton *button, gpointer user_data)
{
    if (win_record)
    {
	dlgrecord_stop_recording();
	gtk_widget_destroy(win_record);
	gtk_main_quit();
    }
    win_record = NULL;
}

void dlgrecord_update_levels(void)
{
    GtkLevels *Levels;

    if (win_record)
    {
	Levels = GTK_LEVELS(lookup_widget(win_record, "Levels"));
	gtk_levels_set_levels(Levels, lpeak, rpeak);

	if (lclip)
	{
	    gtk_levels_set_clip(Levels, 0);
	    lclip = FALSE;
	}
	if (rclip)
	{
	    gtk_levels_set_clip(Levels, 1);
	    rclip = FALSE;
	}
    }
}
