/******************************************************************************\
 gnofin/gtk-auto-combo.c   $Revision: 1.2 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * GtkAutoCombo: Extends GtkCombo to include auto completion
 *
 * Author:
 *   Darin Fisher (dfisher@jagger.me.berkeley.edu)
 */

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <string.h>
#include <gtk/gtkobject.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>
#include <gtk/gtklist.h>
#include <gtk/gtkcombo.h>
#include <gdk/gdkkeysyms.h>
#include "gtk-auto-combo.h"

static GtkComboClass *parent_class;

static void
gtk_auto_combo_class_init (GtkObjectClass *object_class)
{
  parent_class = gtk_type_class (gtk_combo_get_type ());
}

static gint
on_key_press_event (GtkEntry *entry, GdkEventKey *event, GtkAutoCombo *auto_combo)
{
  GtkList *list;
  gchar *text;
  GList *it;
  gint length;

  trace ("");

  switch (event->keyval)
  {
  case GDK_BackSpace:
  case GDK_Delete:
    return TRUE; /* dont complete */
  case GDK_Up:
  case GDK_Down:
  case GDK_Left:
  case GDK_Right:
    if (!(event->state & GDK_SHIFT_MASK))
      gtk_entry_select_region (entry, 0, 0);
    return TRUE; /* dont complete */
  case GDK_Tab:
  case GDK_ISO_Left_Tab:
    gtk_entry_select_region (entry, 0, 0);
    return FALSE;
  }

  list = GTK_LIST (auto_combo->combo.list);
  if (!list || !list->children)
    return TRUE;

  if (event->length == 0)
    return TRUE;

  /* try to complete string */
  text = gtk_entry_get_text (entry);
  length = strlen (text);

  if (length > 0)
  {
    for (it=list->children; it; it=it->next)
    {
      GtkListItem *item = (GtkListItem *) it->data;
      GtkWidget *label;
      gchar *string;
      gint n;

      label = GTK_BIN (item)->child;
      if (!label || !GTK_IS_LABEL (label))
	continue;
      gtk_label_get (GTK_LABEL (label), &string);

      n = strlen (string);
      if (n < length)
	continue;
      /* case sensitive comparison */
      if (strncmp (text, string, length) == 0)
      {
	trace ("match found: %s\n", string);
	if (n > length)
	{
	  /* found first alphabetical match */
	  gtk_entry_set_text (entry, string);

	  /* select last (n-length) chars */
	  gtk_entry_select_region (entry, length, -1);
	}
	return TRUE;
      }
    }
  }
  return TRUE;
}

static void
gtk_auto_combo_init (GtkAutoCombo *auto_combo)
{
  GtkCombo *combo = GTK_COMBO (&auto_combo->combo);

  gtk_combo_set_case_sensitive (combo, TRUE);

  /*
   * Connect to entry signals
   */
  gtk_signal_connect_after (
		GTK_OBJECT (combo->entry), "key_press_event",
		GTK_SIGNAL_FUNC (on_key_press_event), auto_combo);
}

GtkType
gtk_auto_combo_get_type (void)
{
  static GtkType type = 0;

  if (!type)
  {
    GtkTypeInfo info = {
      "GtkAutoCombo",
      sizeof (GtkAutoCombo),
      sizeof (GtkAutoComboClass),
      (GtkClassInitFunc) gtk_auto_combo_class_init,
      (GtkObjectInitFunc) gtk_auto_combo_init,
      NULL, /* reserved 1 */
      NULL, /* reserved 2 */
      (GtkClassInitFunc) NULL
    };
    type = gtk_type_unique (gtk_combo_get_type (), &info);
  }
  return type;
}

GtkWidget *
gtk_auto_combo_new (void)
{
  return GTK_WIDGET (gtk_type_new (gtk_auto_combo_get_type ()));
}

// vim: ts=8 sw=2
