/******************************************************************************\
 gnofin/record-stringizer.c   $Revision: 1.6 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <string.h>
#include "data-if.h"
#include "record-stringizer.h"
#include "date.h"
#include "money.h"


gchar *stringize_record_field (gchar *buf, guint len,
			       guint field, const RecordInfo *rec)
{
  const gchar *s;

  trace ("");
  g_return_val_if_fail (rec, NULL);
  g_return_val_if_fail (rec->type, NULL);

  switch (field)
  {
  case RECORD_FIELD_DATE:
    buf = date_stringize (buf, len, &rec->date);
    break;
  case RECORD_FIELD_TYPE:
    s = if_record_type_get_name (rec->type);
    if (buf)
      strncpy (buf, s, len);
    else
      buf = g_strdup (s);
    break;
  case RECORD_FIELD_NUMBER:
    if (if_record_type_is_numbered (rec->type))
    {
      if (buf)
	g_snprintf (buf, len, "%d", rec->number);
      else
	buf = g_strdup_printf ("%d", rec->number);
    }
    else
    {
      if (buf)
        strncpy (buf, "", len);
      else
	buf = g_strdup ("");
    }
    break;
  case RECORD_FIELD_LINKED_ACC_NAME:
    if (if_record_type_is_linked (rec->type))
    {
      if (buf)
	strncpy (buf, rec->linked_acc_name, len);
      else
	buf = g_strdup (rec->linked_acc_name);
    }
    else
    {
      if (buf)
        strncpy (buf, "", len);
      else
	buf = g_strdup ("");
    }
    break;
  case RECORD_FIELD_CATEGORY:
    if (buf)
      strncpy (buf, rec->category, len);
    else
      buf = g_strdup (rec->category);
    break;
  case RECORD_FIELD_PAYEE:
    if (buf)
      strncpy (buf, rec->payee, len);
    else
      buf = g_strdup (rec->payee);
    break;
  case RECORD_FIELD_MEMO:
    if (buf)
      strncpy (buf, rec->memo, len);
    else
      buf = g_strdup (rec->memo);
    break;
  case RECORD_FIELD_EXCHANGE_RATE:
    if (buf)
      g_snprintf (buf, len, "%f", rec->exchange_rate);
    else
      buf = g_strdup_printf ("%f", rec->exchange_rate);
    break;
  case RECORD_FIELD_AMOUNT:
    buf = money_stringize (buf, len, rec->amount);
    break;
  case RECORD_FIELD_OVERALL_BAL:
    buf = money_stringize (buf, len, rec->overall_bal);
    break;
  case RECORD_FIELD_CLEARED_BAL:
    buf = money_stringize (buf, len, rec->cleared_bal);
    break;
  case RECORD_FIELD_CLEARED:
    if (buf)
      strncpy (buf, rec->cleared ? _("c") : "", len);
    else
      buf = g_strdup_printf (rec->cleared ? _("c") : "");
    break;
  default:
    g_warning ("unknown field!");
  }
  return buf;
}
