/******************************************************************************\
 gnofin/dialog-account-info.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <gtk/gtksignal.h>
#include <gtk/gtktable.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkentry.h>
#include <gtk/gtklabel.h>
#include <gtk/gtktext.h>
#include <gtk/gtkframe.h>
#include <gtk/gtkcheckbutton.h>
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-stock.h>
#include "dialogs.h"
#include "data-if.h"


typedef struct
{
  GtkWidget   *ok_button;
  AccountInfo *cur_acc;
  AccountInfo *new_acc;
  guint        mask;
  guint        mod_count;

} DialogInfo;


static inline void
update_ok (DialogInfo *info)
{
  gtk_widget_set_sensitive (info->ok_button, info->mod_count);

  if (info->mod_count)
    gtk_widget_grab_default (GTK_WIDGET (info->ok_button));
}

static void
on_name_changed (GtkEntry *entry, DialogInfo *info)
{
  gchar *text;

  trace ("");

  text = gtk_entry_get_text (entry);

  if (info->mask & ACCOUNT_FIELD_NAME)
  {
    g_free (info->new_acc->name);
    info->mask &= ~ACCOUNT_FIELD_NAME;
    info->mod_count--;
  }
  if ((!info->cur_acc->name) || (strcmp (info->cur_acc->name, text) != 0))
  {
    info->new_acc->name = g_strdup (text);
    info->mask |= ACCOUNT_FIELD_NAME;
    info->mod_count++;
  }
  update_ok (info);
}

static void
on_notes_changed (GtkEditable *editable, DialogInfo *info)
{
  gchar *text;

  trace ("");

  text = gtk_editable_get_chars (editable, 0, -1);

  if (info->mask & ACCOUNT_FIELD_NOTES)
  {
    g_free (info->new_acc->notes);
    info->mask &= ~ACCOUNT_FIELD_NOTES;
    info->mod_count--;
  }
  if ((!info->cur_acc->notes) || (strcmp (info->cur_acc->notes, text) != 0))
  {
    info->new_acc->notes = g_strdup (text);
    info->mask |= ACCOUNT_FIELD_NOTES;
    info->mod_count++;
  }
  update_ok (info);
}

static void
on_foreign_toggled (GtkToggleButton *button, DialogInfo *info)
{
  gboolean value;

  trace ("");

  value = gtk_toggle_button_get_active (button);

  if (info->mask & ACCOUNT_FIELD_FOREIGN)
  {
    info->mask &= ~ACCOUNT_FIELD_FOREIGN;
    info->mod_count--;
  }
  if (info->cur_acc->foreign != value)
  {
    info->mask |= ACCOUNT_FIELD_FOREIGN;
    info->new_acc->foreign = value;
    info->mod_count++;
  }
  update_ok (info);
}

guint
dialog_account_info (GtkWindow *parent, AccountInfo *acc)
{
  DialogInfo info = {0};
  AccountInfo new_acc = {0};
  GnomeDialog *dialog;
  GtkWidget *button;

  trace("");

  info.cur_acc = acc;
  info.new_acc = &new_acc;

  /* Dialog */
  {
    dialog = GNOME_DIALOG (gnome_dialog_new (_("Account Properties"),
					     GNOME_STOCK_BUTTON_OK,
					     GNOME_STOCK_BUTTON_CANCEL,
					     NULL));
    gnome_dialog_set_parent (dialog, parent);

    button = GTK_WIDGET (dialog->buttons->data);
    gtk_widget_set_sensitive (button, FALSE);

    info.ok_button = button;
  }
  
  /* Entry fields */
  {
    GtkWidget *entry;
    GtkWidget *label;
    GtkWidget *table;
    GtkWidget *hbox, *vbox;
    GtkWidget *text;
    GtkWidget *frame;

    frame = gtk_frame_new (_("Account Properties"));
    gtk_box_pack_start (GTK_BOX (dialog->vbox), frame, FALSE, FALSE, 10);

    hbox = gtk_hbox_new (FALSE, 10);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_container_add (GTK_CONTAINER (frame), hbox);

    table = gtk_table_new (3, 10, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);
    gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 10);

    label = gtk_label_new (_("Name:"));
    gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 3, 0, 1);

    label = gtk_label_new (_("Notes:"));
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
    gtk_table_attach_defaults (GTK_TABLE (table), vbox, 0, 3, 1, 2);

    entry = gtk_entry_new ();
    gtk_table_attach_defaults (GTK_TABLE (table), entry, 3, 10, 0, 1);
    gtk_signal_connect (GTK_OBJECT (entry), "changed",
    			GTK_SIGNAL_FUNC (on_name_changed), &info);
    gnome_dialog_editable_enters (dialog, GTK_EDITABLE (entry));

    if (acc->name)
      gtk_entry_set_text (GTK_ENTRY (entry), acc->name);

    text = gtk_text_new (NULL, NULL);
    gtk_widget_set_usize (text, 200, 100);
    gtk_text_set_editable (GTK_TEXT (text), TRUE);
    gtk_table_attach_defaults (GTK_TABLE (table), text, 3, 10, 1, 2);
    gtk_signal_connect (GTK_OBJECT (text), "changed",
    			GTK_SIGNAL_FUNC (on_notes_changed), &info);
    gnome_dialog_editable_enters (dialog, GTK_EDITABLE (text));

    if (acc->notes)
    {
      gint position = 0;
      gtk_editable_insert_text (GTK_EDITABLE (text), acc->notes, strlen (acc->notes), &position);
    }

    /* Create foreign currency selector
     */
    button = gtk_check_button_new_with_label (_("Account uses a foreign currency"));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), (acc->foreign == 1));
    gtk_table_attach_defaults (GTK_TABLE (table), button, 3, 10, 2, 3);
    gtk_signal_connect (GTK_OBJECT (button), "toggled",
    			GTK_SIGNAL_FUNC (on_foreign_toggled), &info);
    
    gtk_widget_show_all (frame);
  }

  if (gnome_dialog_run_and_close (dialog) == 0)
  {
    g_assert (info.mask);

    /* Clear the old account info and copy in the new */
    if_account_info_clear (acc, info.mask);
    if_account_info_copy (acc, info.new_acc, info.mask);

    return info.mask;
  }
  else
  {
    if (info.mask)
      if_account_info_clear (info.new_acc, info.mask); 
    return 0;
  }
}
