/******************************************************************************\
 gnofin/data-types.h   $Revision: 1.10 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef DATA_TYPES_H
#define DATA_TYPES_H

#include "money.h"

GNOFIN_API_BEGIN

typedef struct _Bankbook       Bankbook;
typedef struct _Account        Account;
typedef struct _Record         Record;
typedef struct _RecordType     RecordType;
typedef struct _AccountInfo    AccountInfo;
typedef struct _RecordInfo     RecordInfo;
typedef struct _RecordTypeInfo RecordTypeInfo;

enum
{
  ACCOUNT_FIELD_NAME        = (1<<0),
  ACCOUNT_FIELD_NOTES       = (1<<1),
  ACCOUNT_FIELD_OVERALL_BAL = (1<<2),
  ACCOUNT_FIELD_CLEARED_BAL = (1<<3),
  ACCOUNT_FIELD_SORT_FIELD  = (1<<4),
  ACCOUNT_FIELD_SORT_REV    = (1<<5),
  ACCOUNT_FIELD_FOREIGN     = (1<<6),
};
#define ACCOUNT_ALL_WRITABLE_FIELDS  (ACCOUNT_FIELD_NAME |\
				      ACCOUNT_FIELD_NOTES |\
				      ACCOUNT_FIELD_FOREIGN)

struct _AccountInfo
{
  gchar   *name;
  gchar   *notes;
  money_t  overall_bal;    /* readonly */
  money_t  cleared_bal;    /* readonly */
  guint    sort_field;     /* readonly */
  guint    sort_rev : 1;   /* readonly */
  guint    foreign  : 1;
};

enum
{
  RECORD_FIELD_TYPE            = (1<<0),
  RECORD_FIELD_DATE	       = (1<<1),
  RECORD_FIELD_NUMBER	       = (1<<2),
  RECORD_FIELD_LINKED_ACC_NAME = (1<<3),
  RECORD_FIELD_LINKED_REC      = (1<<4),
  RECORD_FIELD_PAYEE	       = (1<<5),
  RECORD_FIELD_MEMO	       = (1<<6),
  RECORD_FIELD_CLEARED	       = (1<<7),
  RECORD_FIELD_AMOUNT	       = (1<<8),
  RECORD_FIELD_OVERALL_BAL     = (1<<9),
  RECORD_FIELD_CLEARED_BAL     = (1<<10),
  RECORD_FIELD_EXCHANGE_RATE   = (1<<11),
  RECORD_FIELD_CATEGORY        = (1<<12),
  RECORD_FIELD_LINKED_ACC      = (1<<13),
  RECORD_FIELD_LINK_BROKEN     = (1<<14),
};
#define RECORD_ALL_WRITABLE_FIELDS  (RECORD_FIELD_TYPE |\
				     RECORD_FIELD_DATE |\
				     RECORD_FIELD_NUMBER |\
				     RECORD_FIELD_LINKED_ACC_NAME |\
				     RECORD_FIELD_CATEGORY |\
				     RECORD_FIELD_PAYEE |\
				     RECORD_FIELD_MEMO |\
				     RECORD_FIELD_CLEARED |\
				     RECORD_FIELD_AMOUNT |\
				     RECORD_FIELD_EXCHANGE_RATE)

struct _RecordInfo
{
  RecordType *type;
  GDate       date;
  guint       number;
  gchar      *linked_acc_name;
  Account    *linked_acc;  /* readonly */
  Record     *linked_rec;  /* readonly */
  gchar      *category;
  gchar      *payee;
  gchar      *memo;
  money_t     amount;
  money_t     overall_bal;    /* readonly */
  money_t     cleared_bal;    /* readonly */
  gfloat      exchange_rate;
  guint       cleared     : 1;
  guint       link_broken : 1;
};

enum
{
  RECORD_TYPE_FIELD_NAME        = (1<<0),
  RECORD_TYPE_FIELD_DESCRIPTION = (1<<1),
  RECORD_TYPE_FIELD_USAGE_COUNT = (1<<2),  /* readonly */
  RECORD_TYPE_FIELD_NUMBERED    = (1<<3),
  RECORD_TYPE_FIELD_LINKED	= (1<<4),
  RECORD_TYPE_FIELD_SIGN	= (1<<5)
};
#define RECORD_TYPE_ALL_WRITABLE_FIELDS  (RECORD_TYPE_FIELD_NAME |\
					  RECORD_TYPE_FIELD_DESCRIPTION |\
					  RECORD_TYPE_FIELD_NUMBERED |\
					  RECORD_TYPE_FIELD_LINKED |\
					  RECORD_TYPE_FIELD_SIGN)

enum 
{
  RECORD_TYPE_SIGN_ANY,
  RECORD_TYPE_SIGN_POS,
  RECORD_TYPE_SIGN_NEG
};

struct _RecordTypeInfo
{
  gchar *name;
  gchar *description;
  guint  numbered : 1;
  guint  linked   : 1;
  guint  sign     : 2;  /* one of RECORD_TYPE_SIGN_XXX */
  guint  usage_count;   /* readonly, indicates how many records use this type */
};

GNOFIN_API_END

#endif
