/******************************************************************************\
 gnofin/plugin-sample.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * Sample plugin demostration
 *
 * Author:
 *   Darin Fisher (dfisher@jagger.me.berkeley.edu)
 */
 
#ifdef HAVE_CONFIG_H 
# include <config.h>
#endif

#include "common.h"
#include "dialogs.h"
#include "plugin.h"
#include "file-filter.h"

static gboolean
can_unload (PluginData *pd)
{
  trace ("");
  return TRUE;
}

static void
free_plugin (PluginData *pd)
{
  trace ("");
}

static gboolean
sample_import (GtkWindow *parent, const gchar *filename, Bankbook *book)
{
  AccountInfo acc = {0};
  RecordTypeInfo typ = {0};

  trace ("");

  dialog_notice (parent, _("Press okay to generate a sample empty account."));

  acc.name = _("Sample Account");
  acc.notes = _("This is just a meaningless sample account");
  if_bankbook_insert_account (book, &acc);

  typ.name = _("DUM");
  typ.description = _("Dummy record type");
  typ.linked = 0;
  typ.numbered = 1;
  typ.sign = RECORD_TYPE_SIGN_ANY;
  if_bankbook_insert_record_type (book, &typ);

  return TRUE;
}

int
init_plugin (PluginData *pd)
{
  FileFilter *filt;
  guint maj, min;

  trace ("libsample");

  /* Verify gnofin API version */
  gnofin_api_version_get (&maj, &min);
  if ((maj != GNOFIN_API_VERSION_MAJOR) || (min  < GNOFIN_API_VERSION_MINOR))
    return PLUGIN_ERROR_INVALID_API;

  /* initialize PluginData structure */
  pd->can_unload = can_unload;
  pd->free_plugin = free_plugin;
  pd->description = _("Sample plugin demonstrating the addition of a file import filter.");
  pd->author = "Darin Fisher <dfisher@jagger.me.berkeley.edu>";

  /* register file importer */
  filt = g_new0 (FileFilter, 1);
  filt->label = _("Sample");
  filt->import = sample_import;
  file_filter_register (filt);

  /* remember our importer structure */
  pd->private_data = (gpointer) filt;

  return PLUGIN_OK;
}

