/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"

#include "menu.h"
#include "window.h"
#include "dopen.h"
#include "notebook.h"
#include "dproperties.h"
#include "dconnect.h"
#include "dpreferences.h"
#include "userlist.h"
#include "dmanager.h"
#include "dsend.h"
#include "run.h"
#include "help.h"
#include "dtriggers.h"

GtkWidget *menubar;
GtkWidget *world_menu;
GtkWidget *world_menu_item;
GtkWidget *disconnect_menu_item;
GtkWidget *userlist_menu_item;
#ifdef ZVT
GtkWidget *run_menu_item;
GtkWidget *run_menu_seperator;
#endif

void discon_menu_cb(GtkWidget *discon) {
	world *w;

	if (!(w = gm_notebook_current_world()))
		return;

	if(gm_world_is_connected(w)) {
		gm_world_try_disconnect(w);
	} else if (gm_world_is_connecting(w)) {
		gm_world_disconnect(w);
	} else {
		gm_world_connect(w);
	}
}

void cls_cb() {
	world *w = gm_notebook_current_world();
	if(w) {
		gm_world_clear_screen(w);
	}
}

GtkWidget *create_main() {
	GtkWidget *rootmenu;
	GtkWidget *menu;
	GtkWidget *tmp;
	GtkAccelGroup *accel_group = gm_window_get_accel_group();

	rootmenu = gtk_menu_item_new_with_label(_("Main"));
	gtk_widget_show(rootmenu);

	menu = gtk_menu_new();
	gtk_widget_show(menu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(rootmenu), menu);

	tmp = gtk_tearoff_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("New..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_properties_open_new), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Open..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_open_open), NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_o,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Quick Connect..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_connect_open), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("World manager..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_manager_open), NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_m,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

#ifdef ZVT
	run_menu_item = gtk_menu_item_new_with_label(_("Run"));
	if(settings->enable_run_menu) {
		gtk_widget_show(run_menu_item);
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(run_menu_item),
					  gm_run_create_menu());
	}
	gtk_container_add(GTK_CONTAINER(menu), run_menu_item);

	run_menu_seperator = gtk_menu_item_new();
	if(settings->enable_run_menu) gtk_widget_show(run_menu_seperator);
	gtk_container_add(GTK_CONTAINER(menu), run_menu_seperator);
#endif

	tmp = gtk_menu_item_new_with_label(_("Preferences..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_preferences_open), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

#ifdef __TRIGGERS__
	tmp = gtk_menu_item_new_with_label(_("Highlites & Triggers..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_triggers_open), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);
#endif

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Quit"));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_window_close), NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_q,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);	
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	return rootmenu;
}

GtkWidget *create_world() {
	GtkWidget *rootmenu;
	GtkWidget *menu;
	GtkWidget *tmp;
	GtkAccelGroup *accel_group = gm_window_get_accel_group();

	world_menu_item = rootmenu = gtk_menu_item_new_with_label("% ERROR !%");

	menu = gtk_menu_new();
	gtk_widget_show(menu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(rootmenu), menu);
	world_menu = menu;

	/* too much complications :(
	 *    tmp = gtk_tearoff_menu_item_new();
	 *    gtk_widget_show(tmp);
	 *    gtk_container_add(GTK_CONTAINER(menu), tmp);
	 */

	disconnect_menu_item = gtk_menu_item_new_with_label("% ERROR (discon) %");
	gtk_widget_show(disconnect_menu_item);
	gtk_signal_connect(GTK_OBJECT(disconnect_menu_item), "activate", 
			   GTK_SIGNAL_FUNC(discon_menu_cb), NULL);
	gtk_widget_add_accelerator(disconnect_menu_item,
				   "activate",
				   accel_group,
				   GDK_F3,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_container_add(GTK_CONTAINER(menu), disconnect_menu_item);

	tmp = gtk_menu_item_new_with_label(_("Close"));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_notebook_close_current_world), NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_F4,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Send..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_send_open_current_world),
			   NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_s,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Find..."));
	/*    gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
	      GTK_SIGNAL_FUNC(tmp_callback2), (void *) "Find");*/
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_f,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);
	gtk_widget_set_sensitive(tmp, FALSE);

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Clear Screen"));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(cls_cb), NULL);
	gtk_widget_add_accelerator(tmp,
				   "activate",
				   accel_group,
				   GDK_l,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	userlist_menu_item = gtk_menu_item_new_with_label(_("%Error (Usrlist)%"));
	gtk_signal_connect(GTK_OBJECT(userlist_menu_item), "activate", 
			   GTK_SIGNAL_FUNC(gm_userlist_toggle), NULL);
	gtk_widget_add_accelerator(userlist_menu_item,
				   "activate",
				   accel_group,
				   GDK_F5,
				   GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_widget_show(userlist_menu_item);
	gtk_container_add(GTK_CONTAINER(menu), userlist_menu_item);

	tmp = gtk_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("Properties..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_dialog_properties_open_current_world), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	return rootmenu;
}

GtkWidget *create_help() {
	GtkWidget *rootmenu;
	GtkWidget *menu;
	GtkWidget *tmp;

	rootmenu = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_item_right_justify(GTK_MENU_ITEM(rootmenu));
	gtk_widget_show(rootmenu);

	menu = gtk_menu_new();
	gtk_widget_show(menu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(rootmenu), menu);

	tmp = gtk_tearoff_menu_item_new();
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	tmp = gtk_menu_item_new_with_label(_("About gmoo..."));
	gtk_signal_connect(GTK_OBJECT(tmp), "activate", 
			   GTK_SIGNAL_FUNC(gm_help_about), NULL);
	gtk_widget_show(tmp);
	gtk_container_add(GTK_CONTAINER(menu), tmp);

	return rootmenu;
}


GtkWidget *gm_menu_create() {
	GtkWidget *menubar_handle;

	if(debug) printf("Creating menu\n");

	menubar_handle = gtk_handle_box_new();
	gtk_widget_show(menubar_handle);
	gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(menubar_handle), 	
					   GTK_POS_LEFT);
	gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(menubar_handle), GTK_POS_TOP);

	menubar = gtk_menu_bar_new();
	gtk_widget_show(menubar);
	gtk_container_add(GTK_CONTAINER(menubar_handle), menubar);

	gtk_container_add(GTK_CONTAINER(menubar), create_main());
	gtk_container_add(GTK_CONTAINER(menubar), create_world());
	gtk_container_add(GTK_CONTAINER(menubar), create_help());

	return menubar_handle;
}


void gm_menu_world_connected(world *w) {
	if(w == gm_notebook_current_world()) {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(disconnect_menu_item)->child), 
				   _("Disconnect"));
	}
}

void gm_menu_world_connecting(world *w) {
	if(w == gm_notebook_current_world()) {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(disconnect_menu_item)->child), 
				   _("Cancel connecting"));
	}
}

void gm_menu_world_disconnected(world *w) {
	if(w == gm_notebook_current_world()) {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(disconnect_menu_item)->child), 
				   _("Connect"));
	}
}

void gm_menu_userlist_on(world *w) {
	if(w == gm_notebook_current_world()) {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(userlist_menu_item)->child), 
				   _("Userlist off"));
	}
}

void gm_menu_userlist_off(world *w) {
	if(w == gm_notebook_current_world()) {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(userlist_menu_item)->child), 
				   _("Userlist on"));
	}
}

void gm_menu_switched_to(int type) {
	world *w;

	if(type == TK_WORLD) {
		w = gm_notebook_current_world();
		if(gm_world_is_connected(w))
			gm_menu_world_connected(w);
		else if(gm_world_is_connecting(w))
			gm_menu_world_connecting(w);
		else
			gm_menu_world_disconnected(w);

		if(GTK_WIDGET_VISIBLE(w->userlist_container))
			gm_menu_userlist_on(w);
		else
			gm_menu_userlist_off(w);
		gtk_label_set_text(GTK_LABEL(GTK_BIN(world_menu_item)->child),
				   w->p->name);
		gtk_menu_set_title(GTK_MENU(world_menu), w->p->name);
		gtk_widget_show(world_menu_item);
		gtk_widget_set_sensitive(userlist_menu_item, (w->userlist != NULL));
	} else {
		gtk_widget_hide(world_menu_item);
	}
}

#ifdef ZVT
void gm_menu_update_run_menu() {
	if(debug) printf("Updating run menu...\n");
	gtk_menu_item_remove_submenu(GTK_MENU_ITEM(run_menu_item));
	if(!settings->enable_run_menu) {
		gtk_widget_hide(run_menu_item);
		gtk_widget_hide(run_menu_seperator);
		if(debug) printf("\tit is turned off.\n");
		return;
	}

	gtk_widget_show(run_menu_item);
	gtk_widget_show(run_menu_seperator);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(run_menu_item),
				  gm_run_create_menu());
	if(debug) printf("\tdone.\n");
}
#endif
