/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  labelsignals.cc - Gtk::Label virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "label.hh"
#include "labelsignals.hh"
#include "menu.hh"
#include "private/labelclass.hh"

using namespace GFC;

/*  Gtk::LabelSignals
 */

Gtk::LabelSignals::LabelSignals(Label *label)
: WidgetSignals(label)
{
	Gtk::LabelClass::init(GTK_LABEL_GET_CLASS(label->gtk_label()));
}

Gtk::LabelSignals::~LabelSignals()
{
}

void
Gtk::LabelSignals::on_populate_popup(Menu& menu)
{
	GtkLabelClass *g_class = LabelClass::get_parent_class(instance_);
	if (g_class->populate_popup)
		g_class->populate_popup((GtkLabel*)instance_, menu.gtk_menu());
}

/*  Gtk::LabelClass
 */

void
Gtk::LabelClass::init(GtkLabelClass *g_class)
{
	g_class->populate_popup = &populate_popup_proxy;
}

GtkLabelClass*
Gtk::LabelClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_LABEL_GET_CLASS(instance));
	return static_cast<GtkLabelClass*>(ptr);
}

GType
Gtk::LabelClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_LABEL);
	}
	return type;
}

void*
Gtk::LabelClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::LabelClass::populate_popup_proxy(GtkLabel *label, GtkMenu *menu)
{
	void *ptr = g_object_get_qdata((GObject*)label, G::ObjectSignals::quark());
	if (ptr)
		static_cast<LabelSignals*>(ptr)->on_populate_popup(*G::Object::wrap<Gtk::Menu>(menu));
	else
	{
		GtkLabelClass *g_class = LabelClass::get_parent_class(label);
		if (g_class->populate_popup)
			g_class->populate_popup(label, menu);
	}
}

