/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  handleboxsignals.cc - Gtk::HandleBox virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "handlebox.hh"
#include "handleboxsignals.hh"
#include "private/handleboxclass.hh"

using namespace GFC;

/*  Gtk::HandleBoxSignals
 */

Gtk::HandleBoxSignals::HandleBoxSignals(HandleBox *handle_box)
: ContainerSignals(handle_box)
{
	Gtk::HandleBoxClass::init(GTK_HANDLE_BOX_GET_CLASS(handle_box->gtk_handle_box()));
}

Gtk::HandleBoxSignals::~HandleBoxSignals()
{
}

void
Gtk::HandleBoxSignals::on_child_attached(Widget& child)
{
	GtkHandleBoxClass *g_class = HandleBoxClass::get_parent_class(instance_);
	if (g_class->child_attached)
		g_class->child_attached((GtkHandleBox*)instance_, child.gtk_widget());
}

void
Gtk::HandleBoxSignals::on_child_detached(Widget& child)
{
	GtkHandleBoxClass *g_class = HandleBoxClass::get_parent_class(instance_);
	if (g_class->child_detached)
		g_class->child_detached((GtkHandleBox*)instance_, child.gtk_widget());
}

/*  Gtk::HandleBoxClass
 */

void
Gtk::HandleBoxClass::init(GtkHandleBoxClass *g_class)
{
	g_class->child_attached = &child_attached_proxy;
	g_class->child_detached = &child_detached_proxy;
}

GtkHandleBoxClass*
Gtk::HandleBoxClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_HANDLE_BOX_GET_CLASS(instance));
	return static_cast<GtkHandleBoxClass*>(ptr);
}

GType
Gtk::HandleBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HANDLE_BOX);
	}
	return type;
}

void*
Gtk::HandleBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::HandleBoxClass::child_attached_proxy(GtkHandleBox *handle_box, GtkWidget *child)
{
	void *ptr = g_object_get_qdata((GObject*)handle_box, G::ObjectSignals::quark());
	if (ptr)
		static_cast<HandleBoxSignals*>(ptr)->on_child_attached(*G::Object::wrap<Widget>(child));
	else
	{
		GtkHandleBoxClass *g_class = HandleBoxClass::get_parent_class(handle_box);
		if (g_class->child_attached)
			g_class->child_attached(handle_box, child);
	}
}

void
Gtk::HandleBoxClass::child_detached_proxy(GtkHandleBox *handle_box, GtkWidget *child)
{
	void *ptr = g_object_get_qdata((GObject*)handle_box, G::ObjectSignals::quark());
	if (ptr)
		static_cast<HandleBoxSignals*>(ptr)->on_child_detached(*G::Object::wrap<Widget>(child));
	else
	{
		GtkHandleBoxClass *g_class = HandleBoxClass::get_parent_class(handle_box);
		if (g_class->child_detached)
			g_class->child_detached(handle_box, child);
	}
}

