/*
	odscrolledbox.c
	
	1999-05-08:	Created test version.
	1999-05-11:	I think I could settle with this now.
				I have not found a way to set the page size correctly.
	2000-02-12:	Wrote yet another subclass, as a workaround to a bug in the base class, in this case
				GtkViewport. I also optimized it for button sheets by not clearing the background... =)
				I should not forget to send the bug report.

	This dirty hack was written by Johan Hanson <johan@tiq.com>.
	Pass bug reports and patches concerning this module to him.

	tabsize in this file is 4, in the header file it is 8.
*/

#include "odscrolledbox.h"
#include "colorutil.h"
#include <gtk/gtk.h>
#include <math.h>

#ifndef DEBUG
#define DEBUG 1
#endif
#if DEBUG
#include <stdio.h>
#endif

#ifndef BORDERLESS
#define	BORDERLESS 0
#endif

#define BOX(widget)			 (GTK_BOX(GTK_VIEWPORT((GTK_BIN(widget)->child))->child))
#define SCROLLBAR_SPACING(w) (GTK_SCROLLED_WINDOW_CLASS (GTK_OBJECT (w)->klass)->scrollbar_spacing)


static void od_scrolled_box_class_init	  (ODScrolledBoxClass *klass);
static void od_scrolled_box_init		  (ODScrolledBox *box);
static void od_scrolled_box_size_request  (GtkWidget *widget, GtkRequisition *requisition);
static gint od_scrolled_box_range_press	  (GtkRange  *range,  GdkEventButton *event, ODScrolledBox *box);
static gint od_scrolled_box_range_release (GtkRange  *range,  GdkEventButton *event, ODScrolledBox *box);

static GtkScrolledWindowClass *parent_class = NULL;

#if BORDERLESS
static void od_scrolled_box_draw_shadow	  (GtkStyle      *style,
										   GdkWindow     *window,
										   GtkStateType   state_type,
										   GtkShadowType  shadow_type,
										   GdkRectangle  *area,
										   GtkWidget     *widget,
										   gchar         *detail,
										   gint           x,
										   gint           y,
										   gint           width,
										   gint           height);

static GtkStyleClass od_scrolled_box_style_class = { 0 };
static void (* old_draw_shadow) (GtkStyle      *style,
								 GdkWindow     *window,
								 GtkStateType   state_type,
								 GtkShadowType  shadow_type,
								 GdkRectangle  *area,
								 GtkWidget     *widget,
								 gchar         *detail,
								 gint           x,
								 gint           y,
								 gint           width,
								 gint           height ) = NULL;
#endif

/*	Internal viewport class
	
	The reason we have it at all is that GtkViewport::draw blindly assumes that
	its GtkContainer::border_width == style->klass->xthickness == style->klass->ythickness.
	In our case, border_width==0 always, while the thickness can be anything.
	
	Quite a few users have complained about this bug... WHICH IS IN GTK DAMNIT...
	but we fix it anyway. Gentoo is supposed to rock, and we are supposed to be cool people so
	we do this..
*/
#define OD_TYPE_VIEWPORT            (od_viewport_get_type ())
#define OD_VIEWPORT(obj)            (GTK_CHECK_CAST ((obj), OD_TYPE_VIEWPORT, ODViewport))
#define OD_VIEWPORT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), OD_TYPE_VIEWPORT, ODViewportClass))
#define OD_IS_VIEWPORT(obj)         (GTK_CHECK_TYPE ((obj), OD_TYPE_VIEWPORT))
#define OD_IS_VIEWPORT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), OD_TYPE_VIEWPORT))

typedef struct _ODViewport		ODViewport;
typedef struct _ODViewportClass	ODViewportClass;

struct _ODViewport {
	GtkViewport	parent;
};

struct _ODViewportClass {
	GtkViewportClass parent_class;
};

static GtkType		od_viewport_get_type	(void);
static GtkWidget *	od_viewport_new			(GtkAdjustment		*hadjustment,
											 GtkAdjustment		*vadjustment);
static void			od_viewport_class_init	(ODViewportClass	*klass);
static void			od_viewport_init		(ODViewport			*viewport);
static void			od_viewport_draw		(GtkWidget			*widget,
											 GdkRectangle		*area);
static gint			od_viewport_expose		(GtkWidget			*widget,
											 GdkEventExpose		*event);


/* Class functions */
GtkType od_scrolled_box_get_type (void) {
	static GtkType box_type = 0;
	
	if (!box_type) {
		static const GtkTypeInfo box_info = {
			"ODScrolledBox",
			sizeof (ODScrolledBox),
			sizeof (ODScrolledBoxClass),
			(GtkClassInitFunc) od_scrolled_box_class_init,
			(GtkObjectInitFunc) od_scrolled_box_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
		box_type = gtk_type_unique (GTK_TYPE_SCROLLED_WINDOW, &box_info);
	}
	return box_type;
}

static void od_scrolled_box_class_init (ODScrolledBoxClass *klass) {
	GtkScrolledWindowClass *scwin_class;
	GtkWidgetClass *widget_class;
	GtkObjectClass *object_class;

	parent_class = gtk_type_class(gtk_scrolled_window_get_type());
	
	scwin_class = GTK_SCROLLED_WINDOW_CLASS(klass);
	widget_class = GTK_WIDGET_CLASS(klass);
	object_class = GTK_OBJECT_CLASS(klass);

	widget_class->size_request	= od_scrolled_box_size_request;

	scwin_class->scrollbar_spacing = 1;
}


static void od_scrolled_box_init (ODScrolledBox *box) {
	box->vvisible = 0;
	box->hvisible = 0;
}


/* new and destroy */
GtkWidget * od_scrolled_box_new (void) {
	GtkWidget *widget, *viewport, *scrollbar;
  #if BORDERLESS
	static GtkStyle *style = NULL;
  #endif

	widget = gtk_widget_new (od_scrolled_box_get_type(),
							 "hadjustment", NULL,
							 "vadjustment", NULL,
							 NULL);

	/* To have a borderless viewport, we create our own */
	if (!(viewport = GTK_BIN(widget)->child)) {
		viewport = od_viewport_new(NULL, NULL);
		gtk_container_set_border_width(GTK_CONTAINER(viewport), 0);
		gtk_container_add(GTK_CONTAINER(widget), viewport);
	}
/*
	gtk_container_add(GTK_CONTAINER(viewport), gtk_vbox_new (TRUE, 0);
*/
	gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_NONE);

	scrollbar = GTK_SCROLLED_WINDOW(widget)->vscrollbar;
	gtk_signal_connect (GTK_OBJECT(scrollbar), "button_release_event",
					   (GtkCallback) od_scrolled_box_range_release, widget);
	gtk_signal_connect (GTK_OBJECT(scrollbar), "button_press_event",
					   (GtkCallback) od_scrolled_box_range_press, widget);

  #if BORDERLESS	
	/* A hack to remove the border around the scrollbar... */
	if (old_draw_shadow == NULL) {
		gtk_widget_ensure_style(scrollbar);
		style = col_style_copy(gtk_widget_get_style(scrollbar));

		od_scrolled_box_style_class = *style->klass;
		old_draw_shadow = style->klass->draw_shadow;
		od_scrolled_box_style_class.draw_shadow = od_scrolled_box_draw_shadow;
		style->klass = &od_scrolled_box_style_class;

		style->klass->xthickness = 0;
		style->klass->ythickness = 0;
	}
	gtk_widget_set_style(scrollbar, style);
	gtk_widget_queue_resize (widget);
  #endif

	return widget;
}

/* Events */
static void od_scrolled_box_size_request (GtkWidget *widget, GtkRequisition *requisition) {
	GtkScrolledWindow	*scrolled_window;
	ODScrolledBox		*scrolled_box;
	GtkWidget			*viewport, *container, *child;
	GtkTable			*table;
	GList				*cur;
	guint				i, nv, nh, width, height;
	GtkRequisition		child_requisition;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (OD_IS_SCROLLED_BOX (widget));
	g_return_if_fail (requisition != NULL);
	
	scrolled_window = GTK_SCROLLED_WINDOW (widget);
	scrolled_box	= OD_SCROLLED_BOX (widget);
	viewport		= GTK_BIN(widget)->child;
	
	((GtkWidgetClass *)parent_class)->size_request (widget, requisition);
	
	if (   (   scrolled_box->vvisible != 0
			|| scrolled_box->hvisible != 0)
		&& viewport
		&& GTK_IS_VIEWPORT(viewport)
		&& GTK_WIDGET_VISIBLE(viewport)
		&& (container = GTK_WIDGET(GTK_BIN(viewport)->child))
		&& GTK_IS_CONTAINER(container)
		&& GTK_WIDGET_VISIBLE(container))
	{
		width  = 0;
		height = 0;
		nv = 0;
		nh = 0;
		
		if (GTK_IS_VBOX(container)) {
			for (cur = GTK_BOX(container)->children; cur!=NULL && nv < scrolled_box->vvisible; cur=cur->next) {
				child = ((GtkBoxChild *)(cur->data))->widget;
			
				if (child && GTK_WIDGET_VISIBLE(child)) {
					gtk_widget_get_child_requisition(child, &child_requisition);
					height += child_requisition.height;
					nv++;
				}
			}
			height += GTK_CONTAINER(container)->border_width;
			if (nv <= scrolled_box->vvisible)
				height += GTK_CONTAINER(container)->border_width;
		} else if (GTK_IS_HBOX(container)) {
			for (cur = GTK_BOX(container)->children; cur!=NULL && nh < scrolled_box->hvisible; cur=cur->next) {
				child = ((GtkBoxChild *)(cur->data))->widget;
			
				if (child && GTK_WIDGET_VISIBLE(child)) {
					gtk_widget_get_child_requisition(child, &child_requisition);
					width += child_requisition.width;
					nh++;
				}
			}
			width += GTK_CONTAINER(container)->border_width;
			if (nh <= scrolled_box->hvisible)
				width += GTK_CONTAINER(container)->border_width;
		} else if (GTK_IS_TABLE(container)) {
			table = GTK_TABLE(container);
		
			for (i=0; i<table->nrows && nv < scrolled_box->vvisible; i++) {
				if (!table->rows[i].empty) {
					height += table->rows[i].requisition + table->rows[i].spacing;
					nv++;
				}
			}
		
			for (i=0; i<table->ncols && nh < scrolled_box->hvisible; i++) {
				if (!table->cols[i].empty) {
					width += table->cols[i].requisition + table->cols[i].spacing;
					nh++;
				}
			}

			height += GTK_CONTAINER(container)->border_width;
			if (nv <= scrolled_box->vvisible)
				height += GTK_CONTAINER(container)->border_width;
		
			width += GTK_CONTAINER(container)->border_width;
			if (nh <= scrolled_box->hvisible)
				width += GTK_CONTAINER(container)->border_width;
		} else {
			return;
		}

		requisition->height	= MAX(requisition->height, height + GTK_CONTAINER(widget)->border_width * 2);
		requisition->width	= MAX(requisition->width, width + GTK_CONTAINER(widget)->border_width * 2);
	}
}


static gint od_scrolled_box_range_press (GtkRange *range, GdkEventButton *event, ODScrolledBox *box) {
	g_return_val_if_fail (range != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_VSCROLLBAR(range), FALSE);
	g_return_val_if_fail (OD_IS_SCROLLED_BOX(box), FALSE);

	switch (event->button) {
	  case 2:
	  case 3:
		gtk_signal_emit_stop_by_name(GTK_OBJECT(range), "button_press_event");
		return TRUE;

	  default:
		return FALSE;
	}
	
	return TRUE;
}

static gint od_scrolled_box_range_release (GtkRange *range, GdkEventButton *event, ODScrolledBox *box) {
	GtkAdjustment *adjustment;
	gfloat val, mod;
	
	g_return_val_if_fail (range != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_VSCROLLBAR(range), FALSE);
	g_return_val_if_fail (OD_IS_SCROLLED_BOX(box), FALSE);

	if (event->button != 2 && event->button != 3)
		return FALSE;

	adjustment = gtk_range_get_adjustment (range);
	val = adjustment->value;

	if (event->button == 3) {
		if (val >= adjustment->upper - adjustment->page_size) {
			val = adjustment->lower;
		} else {
			val = val - fmod(val - adjustment->lower, adjustment->page_size)
				+ adjustment->page_size;
			if (val > adjustment->upper - adjustment->page_size)
				val = adjustment->upper - adjustment->page_size;
		}
	} else {
		mod = fmod(val - adjustment->lower, adjustment->page_size);
		val -= mod;
		if (mod < 1.0e-4)
			val -= adjustment->page_size;

		if (val < adjustment->lower)
			val = adjustment->upper - adjustment->page_size;
	}
	
	gtk_adjustment_set_value (adjustment, val);
	gtk_signal_emit_stop_by_name(GTK_OBJECT(range), "button_release_event");
	return TRUE;
}


/* Interface */
void
od_scrolled_box_set_n_visible	(ODScrolledBox	*box,
								 gushort		hvisible,
								 gushort		vvisible)
{
	gushort oldv, oldh;
	
	g_return_if_fail (box != NULL);
	g_return_if_fail (OD_IS_SCROLLED_BOX(box));
	
	oldv = box->hvisible; box->hvisible = hvisible;
	oldh = box->vvisible; box->vvisible = vvisible;

	if (vvisible != oldv || hvisible != oldh)
		gtk_widget_queue_resize(GTK_WIDGET(box));
}

void od_scrolled_box_set_num (ODScrolledBox	*box, guint num) {
	g_return_if_fail (box != NULL);
	g_return_if_fail (OD_IS_SCROLLED_BOX (box));

	od_scrolled_box_set_n_visible (box, 0, num);
}


#if BORDERLESS
/* Style */
static void od_scrolled_box_draw_shadow ( GtkStyle      *style,
										  GdkWindow     *window,
										  GtkStateType   state_type,
										  GtkShadowType  shadow_type,
										  GdkRectangle  *area,
										  GtkWidget     *widget,
										  gchar         *detail,
										  gint           x,
										  gint           y,
										  gint           width,
										  gint           height)
{
	if (GTK_IS_VSCROLLBAR (widget)
		&& widget->parent
		&& OD_IS_SCROLLED_BOX(widget->parent)
		&& shadow_type == GTK_SHADOW_IN
		&& !(   GTK_RANGE(widget)->in_child == GTK_RANGE_CLASS (GTK_OBJECT (widget)->klass)->step_forw
             || GTK_RANGE(widget)->in_child == GTK_RANGE_CLASS (GTK_OBJECT (widget)->klass)->step_back))
	{
		old_draw_shadow (style, window, state_type, GTK_SHADOW_NONE, area, widget, detail,
						 x, y, width, height);
	} else {
		old_draw_shadow (style, window, state_type, shadow_type, area, widget, detail,
						 x, y, width, height);
	}
}
#endif

/* ODViewport */

static GtkType
od_viewport_get_type (void)
{
	static GtkType viewport_type = 0;
	
	if (!viewport_type) {
		static const GtkTypeInfo viewport_info = {
			"ODViewport",
			sizeof (ODViewport),
			sizeof (ODViewportClass),
			(GtkClassInitFunc) od_viewport_class_init,
			(GtkObjectInitFunc) od_viewport_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
	
		viewport_type = gtk_type_unique (GTK_TYPE_VIEWPORT, &viewport_info);
	}
	
	return viewport_type;
}

static void
od_viewport_class_init (ODViewportClass *klass)
{
	GtkWidgetClass	*widget_class;
	
	widget_class = (GtkWidgetClass *)klass;
	widget_class->draw			= od_viewport_draw;
	widget_class->expose_event	= od_viewport_expose;
}

static void
od_viewport_init (ODViewport *viewport)
{
	((GtkContainer *)viewport)->border_width = 0;
}

static GtkWidget *
od_viewport_new (GtkAdjustment *hadjustment,
				 GtkAdjustment *vadjustment)
{
	GtkWidget *viewport;
	
	viewport = gtk_widget_new (OD_TYPE_VIEWPORT,
							 "hadjustment", hadjustment,
							 "vadjustment", vadjustment,
							 NULL);
	
	return viewport;
}

static void
od_viewport_draw (GtkWidget	*widget, GdkRectangle *area)
{
	GtkViewport		*viewport;
	GtkBin			*bin;
	GdkRectangle	tmp_area;	/* same as child_area, border_width == 0, no border! */

	g_return_if_fail (widget != NULL);
	g_return_if_fail (OD_IS_VIEWPORT(widget));
	g_return_if_fail (area != NULL);
	
	if (GTK_WIDGET_DRAWABLE(widget)) {
		viewport = GTK_VIEWPORT(widget);
		bin = GTK_BIN(widget);
		
	  /*
		gdk_window_clear_area(viewport->bin_window, area->x, area->y, area->width, area->height);
	  */
		
		tmp_area = *area;
		tmp_area.x += viewport->hadjustment->value;
		tmp_area.y += viewport->vadjustment->value;
		
		if (bin->child)
			gtk_widget_draw(bin->child, &tmp_area);
	}
}

static gint
od_viewport_expose (GtkWidget *widget, GdkEventExpose *event)
{
	GtkViewport		*viewport;
	GtkBin			*bin;
	GdkEventExpose	child_event;
	
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (OD_IS_VIEWPORT(widget), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);

	if (GTK_WIDGET_DRAWABLE(widget)) {
		viewport = GTK_VIEWPORT(widget);
		bin = GTK_BIN(widget);
		
/*		g_return_val_if_fail (event->window != viewport->bin_window, FALSE);*/
		
	  /*
		gdk_window_clear_area(viewport->bin_window, area->x, area->y, area->width, area->height);
	  */

		child_event = *event;
		
		if (   (bin->child != NULL)
			&& GTK_WIDGET_NO_WINDOW (bin->child)
			&& gtk_widget_intersect (bin->child, &event->area, &child_event.area))
				gtk_widget_event (bin->child, (GdkEvent*) &child_event);
	}
	return FALSE;
}

