/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

/**************/
/* structures */
/**************/

struct canvas_pak
{
gint active;
gpointer model;
gint x,y;              /* origin */
gint width,height;     /* canvas dimensions */
gint size;
GtkWidget *glarea;
};


struct pipe_pak
{
gdouble v1[3];
gdouble v2[3];
gdouble radius;
gdouble colour[4];
};

/**************/
/* prototypes */
/**************/

struct canvas_pak *gl_new_canvas(gint width, gint height);

gint redraw_handler(gpointer *);
void redraw_canvas(gint);
void draw_objs(struct canvas_pak *, struct model_pak *);
void gl_draw(struct canvas_pak *, struct model_pak *);
gint gl_init_visual(void);
void gl_init_projection(struct model_pak *);
void gl_select_box(GtkWidget *);
void gl_get_world_coords(gint , gint , gdouble *);
void gl_get_window_coords(gdouble *, gint *);
GSList *gl_seek_bond(GtkWidget *, gint, gint, struct model_pak *);
void gl_vertex_win(gint, gint);

void set_colour(GdkColor *, gint );
gchar *get_mode_label(struct model_pak *);

void gl_free_points(struct point_pak *);
void gl_init_sphere(struct point_pak *);
void gl_draw_sphere(struct point_pak *, gdouble *, gdouble);
void gl_init_circle(struct point_pak *, gint);
void gl_draw_circle(struct point_pak *, gdouble *, gdouble);
void gl_draw_ring(struct point_pak *, gdouble *, gdouble, gdouble);
void gl_draw_cylinder(struct point_pak *, gdouble *, gdouble *, gdouble);
void gl_draw_box(gint, gint, gint, gint);

void draw_cylinder(gdouble *, gdouble *, gdouble, guint);
void draw_cone(gdouble *, gdouble *, gdouble, gint);
void draw_vector(gdouble *, gdouble *, gdouble);
void draw_arc(gdouble *, gdouble *, gdouble *);

void gl_print_win(gint, gint, gchar *);

void stereo_init_window(struct canvas_pak *);
gint stereo_expose_event(GtkWidget *, GdkEventExpose *);
void stereo_close_window(void);
void stereo_open_window(void);
void stereo_draw(void);

void graph_draw(struct canvas_pak *, struct model_pak *);


