from ConfigBoolean import ConfigBoolean
from ConfigColor import ConfigColor
from ConfigEnum import ConfigEnum
from ConfigFloat import ConfigFloat
from ConfigFont import ConfigFont
from ConfigInteger import ConfigInteger
from ConfigString import ConfigString
from ConfigTitle import ConfigTitle
from ConfigURI import ConfigURI

from utils.HIGDialog import HIGDialog

import gtk


#
# Class for the configuration dialog.
#
class ConfigDialog(HIGDialog):

    # mapping between item types and their widgets
    __ITEM_TABLE = {"boolean": ConfigBoolean,
                    "color": ConfigColor,
                    "enum": ConfigEnum,
                    "float": ConfigFloat,
                    "font": ConfigFont,
                    "integer": ConfigInteger,
                    "string": ConfigString,
                    "title": ConfigTitle,
                    "uri": ConfigURI}


    def __init__(self):

        HIGDialog.__init__(self, None, "", "", (gtk.STOCK_CLOSE,
                                                gtk.RESPONSE_CLOSE))
        self.set_property("title", _("Configuration"))

        def destroy(*args): self.destroy()

        self.connect("response", destroy)


    def __add_line(self, page, page_lines, indent, widgets, help):

        tooltips = gtk.Tooltips()

        if (len(widgets) == 2):
            page.attach(widgets[0], 0, 1, page_lines - 1, page_lines,
                        gtk.FILL, 0, indent, 3)
            page.attach(widgets[1], 1, 2, page_lines - 1, page_lines,
                        gtk.EXPAND | gtk.FILL, 0, 0, 3)
            if (help): tooltips.set_tip(widgets[1], help)
        else:
            page.attach(widgets[0], 0, 2, page_lines - 1, page_lines,
                        gtk.EXPAND | gtk.FILL, 0, indent, 3)
            if (help): tooltips.set_tip(widgets[0], help)


    def set_items(self, items, getter, setter):

        page_lines = 0
        page = gtk.Table(1, 2)
        page.show()
        notebook = None
        item_list = []

        for itype, attrs in items:
            if (itype == "page"):
                if (not notebook):
                    align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
                    #align.set_property("right-padding", 2)
                    align.show()
                    notebook = gtk.Notebook()
                    notebook.set_property("border-width", 6)
                    notebook.show()
                    align.add(notebook)
                    self.vbox.pack_start(align, False, False, 0)

                label = attrs.get("label", "")
                tab = gtk.Label(label)
                tab.show()
                box = gtk.VBox()
                box.set_property("border-width", 12)
                box.show()
                box.add(page)
                notebook.append_page(box, tab)

                # create a new page
                page_lines = 0
                page = gtk.Table(1, 2)
                page.show()

            elif (itype == "item"):
                label = attrs.get("label", "")
                value = attrs.get("value", "")
                item_list.append((label, value))

            else:
                try:
                    widgetclass = self.__ITEM_TABLE[itype]
                except KeyError:
                    raise KeyError(_("No such item: %s") % (itype))

                if (itype == "enum"):
                    widget = widgetclass(attrs, getter, setter, item_list)
                    item_list = []
                else:
                    widget = widgetclass(attrs, getter, setter)

                widgets = widget.get_widgets()
                help = attrs.get("help", "")

                indent = (itype != "title") and 12 or 0
                page_lines += 1
                page.resize(page_lines, 2)
                self.__add_line(page, page_lines, indent, widgets, help)

        # add the only page manually if there's no notebook
        if (not notebook):
            self.vbox.pack_start(page, False, False, 0)

